/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.confluence.parser.list;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.doxia.module.confluence.parser.TextBlock;
import org.apache.maven.doxia.module.confluence.parser.list.BulletedListBlock;
import org.apache.maven.doxia.module.confluence.parser.list.ListBlock;
import org.apache.maven.doxia.module.confluence.parser.list.ListBlockParser;
import org.apache.maven.doxia.module.confluence.parser.list.ListItemBlock;
import org.apache.maven.doxia.module.confluence.parser.list.NumberedListBlock;
import org.apache.maven.doxia.module.confluence.parser.list.TreeComponent;

public class TreeListBuilder {
    private TreeComponent root;
    private TreeComponent current;

    public TreeListBuilder() throws IllegalArgumentException {
        this.current = this.root = new TreeComponent(null, "root", 0);
    }

    public void feedEntry(int type, int level, String text) {
        int incomingLevel = level - 1;
        int currentDepth = this.current.getDepth();
        if (incomingLevel != currentDepth) {
            if (incomingLevel > currentDepth) {
                List components = this.current.getChildren();
                if (components.size() == 0) {
                    int n = incomingLevel - currentDepth;
                    for (int i = 0; i < n; ++i) {
                        this.current = this.current.addChildren("", type);
                    }
                } else {
                    this.current = (TreeComponent)components.get(components.size() - 1);
                }
            } else {
                int n = currentDepth - incomingLevel;
                for (int i = 0; i < n; ++i) {
                    this.current = this.current.getFather();
                    if (this.current != null) continue;
                    throw new IllegalStateException();
                }
            }
        }
        this.current.addChildren(text, type);
    }

    public ListBlock getBlock() {
        return this.getList(this.root);
    }

    private ListBlock getList(TreeComponent treeComponent) {
        List list = this.getListItems(treeComponent);
        int type = ((TreeComponent)treeComponent.getChildren().get(0)).getType();
        if (type == ListBlockParser.BULLETED_LIST) {
            return new BulletedListBlock(list);
        }
        return new NumberedListBlock(list);
    }

    private List getListItems(TreeComponent tc) {
        ArrayList<ListItemBlock> blocks = new ArrayList<ListItemBlock>();
        Iterator i = tc.getChildren().iterator();
        while (i.hasNext()) {
            TreeComponent child = (TreeComponent)i.next();
            ArrayList<TextBlock> text = new ArrayList<TextBlock>();
            if (child.getFather() != null) {
                text.add(new TextBlock(child.getText()));
            }
            if (child.getChildren().size() != 0) {
                blocks.add(new ListItemBlock(text, this.getList(child)));
                continue;
            }
            blocks.add(new ListItemBlock(text));
        }
        return blocks;
    }
}

