/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.irplugin;

import com.jaspersoft.jasperserver.irplugin.DockingUtil;
import com.jaspersoft.jasperserver.irplugin.Encrypter;
import com.jaspersoft.jasperserver.irplugin.JServer;
import com.jaspersoft.jasperserver.irplugin.UpgradeSearch;
import com.jaspersoft.jasperserver.irplugin.gui.JRPluginConfigurationDialog;
import com.jaspersoft.jasperserver.irplugin.gui.RepositoryExplorer;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.sheet.Tag;
import it.businesslogic.ireport.plugin.IReportPlugin;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.LanguageChangedListener;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class IRPlugin
extends IReportPlugin {
    public static String configFileName = "jasperserverplugin.xml";
    public static String REQUIRED_VERSION = "";
    public static String CURRENT_VERSION = "";
    public static final String PROPERTY_CHECK_FOR_UPDATE = "PROPERTY_CHECK_FOR_UPDATE";
    public static final String PROPERTY_USE_PROXY = "PROPERTY_USE_PROXY";
    public static final String PROPERTY_PROXY_URL = "PROPERTY_PROXY_URL";
    public static final String PROPERTY_PROXY_USE_AUTH = "PROPERTY_PROXY_USE_AUTH";
    public static final String PROPERTY_PROXY_USERNAME = "PROPERTY_PROXY_USERNAME";
    public static final String PROPERTY_PROXY_PASSWORD = "PROPERTY_PROXY_PASSWORD";
    private boolean viewVisible = false;
    private boolean firstTime = true;
    public static final String localPackageName = "com/jaspersoft/jasperserver/irplugin/locale/";
    public static final String baseName = "irplugin";
    private static ResourceBundle oLanguage = null;
    private static Locale pluginLocale = null;
    private static IRPlugin mainInstance = null;
    private List jServers = new ArrayList();
    private Properties properties = new Properties();
    private Properties brandingProperties = new Properties();
    private RepositoryExplorer repositoryExplorer = null;
    boolean firstCall = true;

    public static IRPlugin getMainInstance() {
        return mainInstance;
    }

    public IRPlugin() {
        mainInstance = this;
    }

    public void call() {
        if (this.getRepositoryExplorer() == null) {
            this.loadConfiguration();
            this.setRepositoryExplorer(new RepositoryExplorer(this));
            IRPlugin.getMainInstance().applyProxySettings();
        }
        MainFrame.getMainInstance();
        if (MainFrame.constTitle.compareTo("iReport 1.2.6 ") < 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JOptionPane.showMessageDialog((Component)MainFrame.getMainInstance(), IRPlugin.getFormattedString("messages.requirements", "JasperReports plugin requires iReport {0} or above!", new Object[]{"1.2.6"}));
                }
            });
            return;
        }
        if (!this.isViewVisible() || !this.getRepositoryExplorer().isShowing()) {
            DockingUtil.installUI(this.getRepositoryExplorer());
        }
        if (!this.firstTime || this.getProperties().getProperty(PROPERTY_CHECK_FOR_UPDATE, "true").equals("true")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        UpgradeSearch us = new UpgradeSearch();
                        Thread t = new Thread(us);
                        t.start();
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
        if (!this.firstTime) {
            pluginLocale = I18n.getCurrentLocale();
            I18n.addOnLanguageChangedListener((LanguageChangedListener)new LanguageChangedListener(){

                public void languageChanged(LanguageChangedEvent languageChangedEvent) {
                    for (int i = 0; i < IRPlugin.this.getJServers().size(); ++i) {
                        ((JServer)IRPlugin.this.getJServers().get(i)).setLocale(languageChangedEvent.getLocale().getLanguage());
                    }
                }
            });
        }
        this.firstTime = false;
    }

    public void configure() {
        JRPluginConfigurationDialog cup = new JRPluginConfigurationDialog((Frame)this.getMainFrame(), true);
        cup.setVisible(true);
    }

    public void applyProxySettings() {
        Properties props = IRPlugin.getMainInstance().getProperties();
        System.getProperties().remove("proxySet");
        System.getProperties().remove("proxyHost");
        System.getProperties().remove("proxyPort");
        System.getProperties().remove("http.proxyHost");
        System.getProperties().remove("http.proxyPort");
        System.getProperties().remove("http.proxyUser");
        System.getProperties().remove("http.proxyPassword");
        System.getProperties().remove("https.proxyHost");
        System.getProperties().remove("https.proxyPort");
        if (props.getProperty(PROPERTY_USE_PROXY, "false").equals("true")) {
            String urlProxy = props.getProperty(PROPERTY_PROXY_URL, "");
            String port = "8080";
            String server = urlProxy;
            if (urlProxy.indexOf(":") > 0) {
                port = urlProxy.substring(urlProxy.indexOf(":") + 1);
                server = urlProxy.substring(0, urlProxy.indexOf(":"));
            }
            System.getProperties().put("http.proxyHost", server);
            System.getProperties().put("http.proxyPort", port);
            if (props.getProperty(PROPERTY_PROXY_USE_AUTH, "false").equals("true")) {
                String userName = props.getProperty(PROPERTY_PROXY_USERNAME, "");
                String userPass = props.getProperty(PROPERTY_PROXY_PASSWORD, "");
                System.getProperties().put("http.proxyUser", userName);
                System.getProperties().put("http.proxyPassword", userPass);
            }
        }
    }

    public void loadConfiguration() {
        this.setProperties(new Properties());
        File configFile = new File(MainFrame.IREPORT_USER_HOME_DIR, configFileName);
        try {
            if (configFile.exists()) {
                this.getProperties().loadFromXML(new FileInputStream(configFile));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Properties props = this.getProperties();
        int i = 0;
        while (props.getProperty("server." + i + ".name") != null) {
            JServer server = new JServer();
            server.setName(props.getProperty("server." + i + ".name"));
            server.setUrl(props.getProperty("server." + i + ".url"));
            server.setUsername(props.getProperty("server." + i + ".username"));
            String pwd = null;
            if (props.getProperty("server." + i + ".password.enc") != null) {
                Encrypter enc = new Encrypter(this.getBrandingProperties().getProperty("irplugin.encrypt.passwords.key", "54fj245vn3vfdsmce4mg0jvs"));
                pwd = enc.decrypt(props.getProperty("server." + i + ".password.enc"));
            } else {
                pwd = props.getProperty("server." + i + ".password");
            }
            server.setPassword(pwd);
            server.setLocale(I18n.getCurrentLocale().getLanguage());
            this.getJServers().add(server);
            ++i;
        }
        this.addProperties("/com/jaspersoft/jasperserver/irplugin/default.jasperserver_irplugin.properties", this.getBrandingProperties());
        this.addProperties("/com/jaspersoft/jasperserver/irplugin/jasperserver_irplugin.properties", this.getBrandingProperties());
        System.out.println(this.getBrandingProperties() + "");
        REQUIRED_VERSION = this.getBrandingProperties().getProperty("irplugin.server.required.version");
        CURRENT_VERSION = this.getBrandingProperties().getProperty("irplugin.version");
        try {
            Method m = MainFrame.class.getMethod("addLinkType", String.class);
            m.invoke((Object)MainFrame.getMainInstance(), "ReportExecution");
        }
        catch (NoSuchMethodException ex) {
        }
        catch (IllegalAccessException ex) {
        }
        catch (InvocationTargetException ex) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private void addProperties(String resourceUri, Properties props) {
        try {
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(resourceUri);
            if (is == null) {
                return;
            }
            props.load(is);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean saveConfiguration() {
        File dir = new File(MainFrame.IREPORT_USER_HOME_DIR);
        int i = 0;
        while (this.getProperties().getProperty("server." + i + ".name") != null) {
            this.getProperties().remove("server." + i + ".name");
            this.getProperties().remove("server." + i + ".url");
            this.getProperties().remove("server." + i + ".username");
            this.getProperties().remove("server." + i + ".password");
            this.getProperties().remove("server." + i + ".password.enc");
            ++i;
        }
        for (i = 0; i < this.getJServers().size(); ++i) {
            JServer server = (JServer)this.getJServers().get(i);
            this.getProperties().setProperty("server." + i + ".name", server.getName());
            this.getProperties().setProperty("server." + i + ".url", server.getUrl());
            this.getProperties().setProperty("server." + i + ".username", server.getUsername());
            if (this.getBrandingProperties().getProperty("irplugin.encrypt.passwords", "true").equals("true")) {
                Encrypter enc = new Encrypter(this.getBrandingProperties().getProperty("irplugin.encrypt.passwords.key", "54fj245vn3vfdsmce4mg0jvs"));
                this.getProperties().setProperty("server." + i + ".password.enc", enc.encrypt(server.getPassword()));
                continue;
            }
            this.getProperties().setProperty("server." + i + ".password", server.getPassword());
        }
        try {
            if (dir.exists()) {
                if (!dir.isDirectory()) {
                    JOptionPane.showMessageDialog((Component)this.getMainFrame(), IRPlugin.getFormattedString("messages.error.1", "{0}\nis not a directory!\nPlease rename this file and retry to save config!", new Object[]{"" + dir.getPath()}), "", 0);
                    return false;
                }
            } else {
                dir.mkdirs();
            }
            File configFile = new File(dir, configFileName);
            this.getProperties().storeToXML(new FileOutputStream(configFile), "JasperServer Plugin configuration file\n (c) 2006 by JasperSoft");
            return true;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog((Component)this.getMainFrame(), IRPlugin.getFormattedString("messages.error.2", "An error is occurred saving Plugin config:\n{0}\nPlease try to save config again!", new Object[]{"" + ex.getMessage()}), "", 0);
            return false;
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public List getJServers() {
        return this.jServers;
    }

    public void setJServers(List jServers) {
        this.jServers = jServers;
    }

    public static String createTmpFileName(String filePrefix, String fileExtension) {
        filePrefix = filePrefix == null ? "" : filePrefix + "_";
        if (fileExtension != null && !fileExtension.startsWith(".")) {
            fileExtension = "." + fileExtension;
        }
        if (fileExtension == null) {
            fileExtension = ".tmp";
        }
        MainFrame.getMainInstance();
        String tmpDirectory = MainFrame.IREPORT_USER_HOME_DIR;
        tmpDirectory = tmpDirectory + File.separator + "jstmp";
        File tmpDirectoryFile = new File(tmpDirectory);
        if (!tmpDirectoryFile.exists()) {
            tmpDirectoryFile.mkdirs();
        }
        return tmpDirectoryFile + File.separator + filePrefix + new Date().getTime() + fileExtension;
    }

    public RepositoryExplorer getRepositoryExplorer() {
        return this.repositoryExplorer;
    }

    public void setRepositoryExplorer(RepositoryExplorer repositoryExplorer) {
        this.repositoryExplorer = repositoryExplorer;
    }

    public boolean isViewVisible() {
        return this.viewVisible;
    }

    public void setViewVisible(boolean viewVisible) {
        this.viewVisible = viewVisible;
    }

    public static String getString(String cID, String defaultValue) {
        return IRPlugin.getString(cID, I18n.getCurrentLocale(), defaultValue);
    }

    public static String getFormattedString(String cID, String defaultValue, Object[] args) {
        String pattern = IRPlugin.getString(cID, I18n.getCurrentLocale(), defaultValue);
        MessageFormat mf = new MessageFormat(pattern, I18n.getCurrentLocale());
        return mf.format(args);
    }

    private static String getString(String cID, Locale currentLocale, String defaultValue) {
        try {
            String newKey;
            String s;
            if (oLanguage == null || !pluginLocale.equals(currentLocale)) {
                pluginLocale = currentLocale;
                oLanguage = ResourceBundle.getBundle("com/jaspersoft/jasperserver/irplugin/locale/irplugin", currentLocale);
            }
            if ((s = oLanguage.getString(cID)) != null && s.startsWith("${") && s.endsWith("}") && (newKey = s.substring(2, s.length() - 1)).length() > 0) {
                return I18n.getString((String)newKey, (String)defaultValue);
            }
            return s;
        }
        catch (MissingResourceException ex) {
            System.out.println("IRPlugin: Can't find the translation for key = " + cID + ": using default (" + defaultValue + ")");
        }
        catch (Exception ex) {
            System.out.println("IRPlugin: Exception loading cID = " + cID + ": " + ex.getMessage());
        }
        return defaultValue;
    }

    public static ResourceBundle getOLanguage() {
        return oLanguage;
    }

    public static void setOLanguage(ResourceBundle aOLanguage) {
        oLanguage = aOLanguage;
    }

    public Properties getBrandingProperties() {
        return this.brandingProperties;
    }

    public void setBrandingProperties(Properties brandingProperties) {
        this.brandingProperties = brandingProperties;
    }

    public List getSupportedQueryLanguages() {
        Iterator<Object> iter = this.getBrandingProperties().keySet().iterator();
        ArrayList<Object> list = new ArrayList<Object>();
        while (iter.hasNext()) {
            String key = "" + iter.next();
            if (!key.startsWith("query.language.") || key.endsWith(".enabled")) continue;
            String language = key.substring(15);
            if (!this.getBrandingProperties().getProperty(key + ".enabled", "true").equals("true")) continue;
            list.add(new Tag((Object)language, this.getBrandingProperties().getProperty(key)));
        }
        Object[] tobeordered = list.toArray();
        Arrays.sort(tobeordered, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Tag)o1).getName().compareTo(((Tag)o2).getName());
            }

            public boolean equals(Object obj) {
                return obj != null && this.equals(obj);
            }
        });
        list.clear();
        for (int i = 0; i < tobeordered.length; ++i) {
            list.add(tobeordered[i]);
        }
        return list;
    }

    public static boolean isValidUrl(String url) {
        String strRegex = "((([0-9]{1,3}\\.){3})[0-9]{1,3})|(([0-9a-z][0-9a-z-]{0,61})?[0-9a-z]\\.?)++(:[0-9]{1,4})?";
        return url.matches(strRegex);
    }
}

