/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.scheduling.beans;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobCalendarTrigger;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobTrigger;
import com.jaspersoft.jasperserver.export.modules.scheduling.beans.ReportJobTriggerBean;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class ReportJobCalendarTriggerBean
extends ReportJobTriggerBean {
    private String minutes;
    private String hours;
    private byte daysType;
    private String weekDays;
    private String monthDays;
    private String months;
    private static final String ENUM_SEPARATOR = ",";
    private static final String ENUM_SEPARATOR_REGEX = ",";

    public void copyFrom(ReportJobTrigger trigger) {
        super.copyFrom(trigger);
        ReportJobCalendarTrigger calTrigger = (ReportJobCalendarTrigger)trigger;
        this.setMinutes(calTrigger.getMinutes());
        this.setHours(calTrigger.getHours());
        this.setDaysType(calTrigger.getDaysType());
        this.setWeekDays(this.toEnumerationString(calTrigger.getWeekDays()));
        this.setMonthDays(calTrigger.getMonthDays());
        this.setMonths(this.toEnumerationString(calTrigger.getMonths()));
    }

    public ReportJobTrigger toJobTrigger() {
        return new ReportJobCalendarTrigger();
    }

    public void copyTo(ReportJobTrigger trigger) {
        super.copyTo(trigger);
        ReportJobCalendarTrigger calTrigger = (ReportJobCalendarTrigger)trigger;
        calTrigger.setMinutes(this.getMinutes());
        calTrigger.setHours(this.getHours());
        calTrigger.setDaysType(this.getDaysType());
        calTrigger.setWeekDays(this.parseEnumerationString(this.getWeekDays()));
        calTrigger.setMonthDays(this.getMonthDays());
        calTrigger.setMonths(this.parseEnumerationString(this.getMonths()));
    }

    protected String toEnumerationString(Set vals) {
        if (vals == null || vals.isEmpty()) {
            return null;
        }
        StringBuffer str = new StringBuffer();
        TreeSet sorted = new TreeSet(vals);
        for (Byte val : sorted) {
            str.append(val.byteValue());
            str.append(",");
        }
        return str.substring(0, str.length() - 1);
    }

    protected SortedSet parseEnumerationString(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        TreeSet<Byte> valsSet = new TreeSet<Byte>();
        String[] vals = str.split(",");
        for (int i = 0; i < vals.length; ++i) {
            String strVal = vals[i];
            try {
                Byte val = Byte.valueOf(strVal);
                valsSet.add(val);
                continue;
            }
            catch (NumberFormatException e) {
                throw new JSExceptionWrapper((Exception)e);
            }
        }
        return valsSet;
    }

    public byte getDaysType() {
        return this.daysType;
    }

    public void setDaysType(byte daysType) {
        this.daysType = daysType;
    }

    public String getHours() {
        return this.hours;
    }

    public void setHours(String hours) {
        this.hours = hours;
    }

    public String getMinutes() {
        return this.minutes;
    }

    public void setMinutes(String minutes) {
        this.minutes = minutes;
    }

    public String getMonthDays() {
        return this.monthDays;
    }

    public void setMonthDays(String monthDays) {
        this.monthDays = monthDays;
    }

    public String getMonths() {
        return this.months;
    }

    public void setMonths(String months) {
        this.months = months;
    }

    public String getWeekDays() {
        return this.weekDays;
    }

    public void setWeekDays(String weekDays) {
        this.weekDays = weekDays;
    }
}

