/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.io;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.export.Parameters;
import com.jaspersoft.jasperserver.export.io.ExportOutput;
import com.jaspersoft.jasperserver.export.io.ExportOutputFactory;
import com.jaspersoft.jasperserver.export.io.FileSystemOutput;
import com.jaspersoft.jasperserver.export.io.PathProcessor;
import com.jaspersoft.jasperserver.export.io.PathProcessorFactory;
import java.util.Properties;

public class FileSystemOutputFactory
implements ExportOutputFactory {
    private String exportDirParameter;
    private PathProcessorFactory pathProcessorFactory;
    private String propertyPathProcessorId;

    public boolean matches(Parameters parameters) {
        return parameters.hasParameter(this.exportDirParameter);
    }

    public ExportOutput createOutput(Parameters parameters) {
        String exportDir = parameters.getParameterValue(this.getExportDirParameter());
        if (exportDir == null) {
            throw new JSException("jsexception.no.export.folder.specified");
        }
        String processorId = this.pathProcessorFactory.getDefaultOutputProcessor();
        PathProcessor processor = this.pathProcessorFactory.getProcessor(processorId);
        Properties properties = new Properties();
        properties.setProperty(this.propertyPathProcessorId, processorId);
        return new FileSystemOutput(exportDir, processor, properties);
    }

    public String getExportDirParameter() {
        return this.exportDirParameter;
    }

    public void setExportDirParameter(String exportFolderParameter) {
        this.exportDirParameter = exportFolderParameter;
    }

    public PathProcessorFactory getPathProcessorFactory() {
        return this.pathProcessorFactory;
    }

    public void setPathProcessorFactory(PathProcessorFactory pathProcessorFactory) {
        this.pathProcessorFactory = pathProcessorFactory;
    }

    public String getPropertyPathProcessorId() {
        return this.propertyPathProcessorId;
    }

    public void setPropertyPathProcessorId(String propertyPathProcessorId) {
        this.propertyPathProcessorId = propertyPathProcessorId;
    }
}

