/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.export.BaseExporterImporter;
import com.jaspersoft.jasperserver.export.ImportTask;
import com.jaspersoft.jasperserver.export.Importer;
import com.jaspersoft.jasperserver.export.io.ImportInput;
import com.jaspersoft.jasperserver.export.modules.Attributes;
import com.jaspersoft.jasperserver.export.modules.ImporterModule;
import com.jaspersoft.jasperserver.export.modules.ImporterModuleContext;
import com.jaspersoft.jasperserver.export.modules.MapAttributes;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ImporterImpl
extends BaseExporterImporter
implements Importer {
    private static final Log log = LogFactory.getLog(ImporterImpl.class);
    protected ImportTask task;
    protected ImportInput input;

    public void setTask(ImportTask task) {
        this.task = task;
        this.input = task == null ? null : task.getInput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performImport() {
        try {
            this.input.open();
            boolean close = true;
            try {
                this.process();
                close = false;
                this.input.close();
            }
            finally {
                if (close) {
                    try {
                        this.input.close();
                    }
                    catch (IOException ioe) {
                        log.info((Object)"Error while closing input", (Throwable)ioe);
                    }
                }
            }
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    protected void process() {
        Document indexDocument = this.readIndexDocument();
        Element indexRoot = indexDocument.getRootElement();
        Properties properties = new Properties();
        Iterator it = indexRoot.elementIterator(this.getPropertyElementName());
        while (it.hasNext()) {
            Element propElement = (Element)it.next();
            String propKey = propElement.attribute(this.getPropertyNameAttribute()).getValue();
            Attribute valueAttr = propElement.attribute(this.getPropertyValueAttribute());
            String value = valueAttr == null ? null : valueAttr.getValue();
            properties.setProperty(propKey, value);
        }
        this.input.propertiesRead(properties);
        Attributes contextAttributes = this.createContextAttributes();
        contextAttributes.setAttribute("sourceJsVersion", properties.getProperty("jsVersion"));
        contextAttributes.setAttribute("targetJsVersion", super.getJsVersion());
        Iterator it2 = indexRoot.elementIterator(this.getIndexModuleElementName());
        while (it2.hasNext()) {
            Element moduleElement = (Element)it2.next();
            String moduleId = moduleElement.attribute(this.getIndexModuleIdAttributeName()).getValue();
            ImporterModule module = this.getModuleRegister().getImporterModule(moduleId);
            if (module == null) {
                throw new JSException("jsexception.import.module.not.found", new Object[]{moduleId});
            }
            commandOut.debug("Invoking module " + module);
            contextAttributes.setAttribute("appContext", this.task.getApplicationContext());
            ModuleContextImpl moduleContext = new ModuleContextImpl(moduleElement, contextAttributes);
            module.init(moduleContext);
            module.process();
        }
    }

    protected Attributes createContextAttributes() {
        MapAttributes contextAttributes = new MapAttributes();
        return contextAttributes;
    }

    protected Document readIndexDocument() {
        InputStream indexInput = this.getIndexInput();
        boolean close = true;
        try {
            SAXReader reader = new SAXReader();
            reader.setEncoding(this.getCharacterEncoding());
            Document document = reader.read(indexInput);
            close = false;
            indexInput.close();
            Document document2 = document;
            return document2;
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new JSExceptionWrapper((Exception)e);
        }
        catch (DocumentException e) {
            log.error((Object)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
        finally {
            if (close) {
                try {
                    indexInput.close();
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        }
    }

    protected InputStream getIndexInput() {
        try {
            return this.input.getFileInputStream(this.getIndexFilename());
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    protected class ModuleContextImpl
    implements ImporterModuleContext {
        private final Element moduleElement;
        private final Attributes attributes;

        public ModuleContextImpl(Element moduleElement, Attributes attributes) {
            this.moduleElement = moduleElement;
            this.attributes = attributes;
        }

        public String getCharacterEncoding() {
            return ImporterImpl.this.getCharacterEncoding();
        }

        public ImportTask getImportTask() {
            return ImporterImpl.this.task;
        }

        public Element getModuleIndexElement() {
            return this.moduleElement;
        }

        public Attributes getAttributes() {
            return this.attributes;
        }
    }
}

