/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2x;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.velocity.util.EnumerationIterator;
import org.apache.velocity.util.introspection.Info;
import org.apache.velocity.util.introspection.UberspectImpl;
import org.apache.velocity.util.introspection.VelMethod;
import org.hibernate.tool.hbm2x.ExporterException;

public class HibernateUberspect
extends UberspectImpl {
    private static Map methodErrors;

    public Iterator getIterator(Object obj, Info i) throws Exception {
        if (obj instanceof Iterator) {
            return (Iterator)obj;
        }
        if (obj instanceof Enumeration) {
            return new EnumerationIterator((Enumeration)obj);
        }
        return super.getIterator(obj, i);
    }

    public VelMethod getMethod(Object obj, String methodName, Object[] args, Info i) throws Exception {
        VelMethod method = super.getMethod(obj, methodName, args, i);
        if (method == null && methodErrors != null) {
            String local;
            Integer val;
            String where = "<null>";
            if (obj != null) {
                where = obj.getClass().getName();
            }
            if ((val = (Integer)methodErrors.get(local = methodName + "(" + args.length + " parameters) on " + where)) == null) {
                val = new Integer(0);
            }
            val = new Integer(val + 1);
            methodErrors.put(local, val);
            throw new ExporterException("Method " + local + " referenced in [" + i.getTemplateName() + "] not found.");
        }
        return method;
    }

    public static int getMethodNotFoundCount() {
        return methodErrors == null ? -1 : methodErrors.size();
    }

    public static void initMethodNotFoundCount() {
        methodErrors = new HashMap();
    }

    public static String getMethodErrors() {
        if (methodErrors == null) {
            return "";
        }
        Iterator iterator = methodErrors.entrySet().iterator();
        StringBuffer buf = new StringBuffer();
        while (iterator.hasNext()) {
            Map.Entry element = iterator.next();
            buf.append(element.getKey() + ":" + element.getValue() + "\n");
        }
        return buf.toString();
    }
}

