/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.ant;

import java.io.File;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.hibernate.tool.ant.ExporterTask;
import org.hibernate.tool.ant.HibernateToolTask;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.tool.hbm2x.Exporter;

public class Hbm2DDLExporterTask
extends ExporterTask {
    boolean exportToDatabase = true;
    boolean scriptToConsole = true;
    boolean schemaUpdate = false;
    String delimiter = ";";
    boolean drop = false;
    boolean create = true;
    boolean format = false;
    String outputfileName = null;
    private boolean haltOnError = false;

    public Hbm2DDLExporterTask(HibernateToolTask parent) {
        super(parent);
    }

    public void execute() {
        if (this.schemaUpdate) {
            SchemaUpdate update = new SchemaUpdate(this.parent.getConfiguration());
            update.execute(this.scriptToConsole, this.exportToDatabase);
        } else {
            SchemaExport export = new SchemaExport(this.parent.getConfiguration());
            if (this.outputfileName != null) {
                export.setOutputFile(new File(this.getDestdir(), this.outputfileName).toString());
            }
            if (this.delimiter != null) {
                export.setDelimiter(this.delimiter);
            }
            export.setHaltOnError(this.haltOnError);
            export.setFormat(this.format);
            if (this.drop && this.create) {
                export.create(this.scriptToConsole, this.exportToDatabase);
            } else {
                export.execute(this.scriptToConsole, this.exportToDatabase, this.drop, this.create);
            }
            if (export.getExceptions().size() > 0) {
                Iterator iterator = export.getExceptions().iterator();
                int cnt = 1;
                this.parent.log(export.getExceptions().size() + " errors occurred while performing <hbm2ddl>.", 1);
                while (iterator.hasNext()) {
                    Throwable throwable = (Throwable)iterator.next();
                    this.parent.log("Error #" + cnt + ": " + throwable.toString(), 1);
                }
                if (this.haltOnError) {
                    throw new BuildException("Errors while performing <hbm2ddl>");
                }
            }
        }
    }

    public void setExport(boolean export) {
        this.exportToDatabase = export;
    }

    public void setUpdate(boolean update) {
        this.schemaUpdate = update;
    }

    public void setConsole(boolean console) {
        this.scriptToConsole = console;
    }

    public void setFormat(boolean format) {
        this.format = format;
    }

    public void setOutputFileName(String fileName) {
        this.outputfileName = fileName;
    }

    public void setDrop(boolean drop) {
        this.drop = drop;
    }

    public void setCreate(boolean create) {
        this.create = create;
    }

    public String getName() {
        return "hbm2ddl (Generates database schema)";
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setHaltonerror(boolean haltOnError) {
        this.haltOnError = haltOnError;
    }

    protected Exporter createExporter() {
        throw new IllegalStateException("Should not call create exporter on hbm2ddl");
    }
}

