/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.Element;
import org.hibernate.MappingException;
import org.hibernate.cfg.reveng.JDBCToHibernateTypeHelper;
import org.hibernate.cfg.reveng.OverrideRepository;
import org.hibernate.cfg.reveng.SQLTypeMapping;
import org.hibernate.cfg.reveng.TableFilter;
import org.hibernate.cfg.reveng.TableIdentifier;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;
import org.hibernate.util.StringHelper;

public final class OverrideBinder {
    private OverrideBinder() {
    }

    public static void bindRoot(OverrideRepository repository, Document doc) {
        Element rootElement = doc.getRootElement();
        Element element = rootElement.element("type-mapping");
        if (element != null) {
            OverrideBinder.bindTypeMappings(element, repository);
        }
        List filters = rootElement.elements("table-filter");
        OverrideBinder.bindTableFilters(filters, repository);
        List tables = rootElement.elements("table");
        OverrideBinder.bindTables(tables, repository);
    }

    private static void bindTables(List tables, OverrideRepository repository) {
        Iterator iterator = tables.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            Table table = new Table();
            table.setCatalog(repository.getCatalog(element.attributeValue("catalog")));
            table.setSchema(repository.getSchema(element.attributeValue("schema")));
            table.setName(element.attributeValue("name"));
            String wantedClassName = element.attributeValue("class");
            Element identifier = element.element("primary-key");
            OverrideBinder.bindIdentifiers(identifier, table, repository);
            List columns = element.elements("column");
            OverrideBinder.bindColumns(columns, table, repository);
            List foreignKeys = element.elements("foreign-key");
            OverrideBinder.bindForeignKeys(foreignKeys, table, repository);
            repository.addTable(table, wantedClassName);
        }
    }

    private static void bindIdentifiers(Element identifier, Table table, OverrideRepository repository) {
        if (identifier == null) {
            return;
        }
        Element element = identifier.element("generator");
        if (element != null) {
            String identifierClass = element.attributeValue("class");
            Properties params = new Properties();
            Iterator iter = element.elementIterator("param");
            while (iter.hasNext()) {
                Element childNode = (Element)iter.next();
                params.setProperty(childNode.attributeValue("name"), childNode.getText());
            }
            repository.addTableIdentifierStrategy(table, identifierClass, params);
        }
        List boundColumnNames = OverrideBinder.bindColumns(identifier.elements("column"), table, repository);
        repository.addPrimaryKeyNamesForTable(table, boundColumnNames);
    }

    private static void bindForeignKeys(List foreignKeys, Table table, OverrideRepository repository) {
        Iterator iterator = foreignKeys.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            String foreignTableName = element.attributeValue("foreign-table");
            if (foreignTableName == null) continue;
            Table foreignTable = new Table();
            foreignTable.setName(foreignTableName);
            foreignTable.setCatalog(OverrideBinder.getCatalog(repository, element.attributeValue("foreign-catalog"), table.getCatalog()));
            foreignTable.setSchema(OverrideBinder.getSchema(repository, element.attributeValue("foreign-schema"), table.getSchema()));
            ArrayList<Column> localColumns = new ArrayList<Column>();
            ArrayList<Column> foreignColumns = new ArrayList<Column>();
            Iterator columnRefs = element.elements("column-ref").iterator();
            while (columnRefs.hasNext()) {
                Element columnRef = (Element)columnRefs.next();
                String localColumnName = columnRef.attributeValue("local-column");
                String foreignColumnName = columnRef.attributeValue("foreign-column");
                Column localColumn = new Column(localColumnName);
                Column foreignColumn = new Column(foreignColumnName);
                localColumns.add(localColumn);
                foreignColumns.add(foreignColumn);
            }
            ForeignKey key = table.createForeignKey(null, localColumns, foreignTableName, foreignColumns);
            key.setReferencedTable(foreignTable);
        }
    }

    private static String getSchema(OverrideRepository repository, String first, String second) {
        if (first == null) {
            return repository.getSchema(second);
        }
        return first;
    }

    private static String getCatalog(OverrideRepository repository, String first, String second) {
        if (first == null) {
            return repository.getCatalog(second);
        }
        return first;
    }

    private static List bindColumns(List columns, Table table, OverrideRepository repository) {
        Iterator iterator = columns.iterator();
        ArrayList<String> columnNames = new ArrayList<String>();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            Column column = new Column();
            column.setName(element.attributeValue("name"));
            String attributeValue = element.attributeValue("jdbc-type");
            if (StringHelper.isNotEmpty((String)attributeValue)) {
                column.setSqlTypeCode(new Integer(JDBCToHibernateTypeHelper.getJDBCType(attributeValue)));
            }
            if (table.getColumn(column) != null) {
                throw new MappingException("Column " + column.getName() + " already exists in table " + TableIdentifier.create(table));
            }
            table.addColumn(column);
            columnNames.add(column.getName());
            repository.setTypeNameForColumn(TableIdentifier.create(table), column.getName(), element.attributeValue("type"));
            repository.setPropertyNameForColumn(TableIdentifier.create(table), column.getName(), element.attributeValue("property"));
            String foreignTableName = element.attributeValue("foreign-table");
            if (foreignTableName == null) continue;
            ArrayList<Column> localColumns = new ArrayList<Column>();
            localColumns.add(column);
            ArrayList<Column> foreignColumns = new ArrayList<Column>();
            Table foreignTable = new Table();
            foreignTable.setName(foreignTableName);
            foreignTable.setCatalog(OverrideBinder.getCatalog(repository, element.attributeValue("foreign-catalog"), table.getCatalog()));
            foreignTable.setSchema(OverrideBinder.getSchema(repository, element.attributeValue("foreign-schema"), table.getSchema()));
            String foreignColumnName = element.attributeValue("foreign-column");
            if (foreignColumnName == null) {
                throw new MappingException("foreign-column is required when foreign-table is specified on " + column);
            }
            Column foreignColumn = new Column();
            foreignColumn.setName(foreignColumnName);
            foreignColumns.add(foreignColumn);
            ForeignKey key = table.createForeignKey(null, localColumns, foreignTableName, foreignColumns);
            key.setReferencedTable(foreignTable);
        }
        return columnNames;
    }

    private static void bindTableFilters(List filters, OverrideRepository respository) {
        Iterator iterator = filters.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            TableFilter filter = new TableFilter();
            filter.setMatchCatalog(element.attributeValue("match-catalog"));
            filter.setMatchSchema(element.attributeValue("match-schema"));
            filter.setMatchName(element.attributeValue("match-name"));
            filter.setExclude(Boolean.valueOf(element.attributeValue("exclude")));
            filter.setPackage(element.attributeValue("package"));
            respository.addTableFilter(filter);
        }
    }

    private static void bindTypeMappings(Element typeMapping, OverrideRepository repository) {
        Iterator iterator = typeMapping.elements("sql-type").iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            SQLTypeMapping mapping = new SQLTypeMapping(JDBCToHibernateTypeHelper.getJDBCType(element.attributeValue("jdbc-type")));
            mapping.setHibernateType(element.attributeValue("hibernate-type"));
            mapping.setLength(OverrideBinder.getInteger(element.attributeValue("length"), Integer.MAX_VALUE));
            mapping.setPrecision(OverrideBinder.getInteger(element.attributeValue("precision"), Integer.MAX_VALUE));
            mapping.setScale(OverrideBinder.getInteger(element.attributeValue("scale"), Integer.MAX_VALUE));
            String notNull = element.attributeValue("not-null");
            if (notNull == null) {
                mapping.setNullable(null);
            } else {
                boolean nullable = notNull.equals("false");
                mapping.setNullable(nullable);
            }
            repository.addTypeMapping(mapping);
        }
    }

    private static int getInteger(String string, int defaultValue) {
        if (string == null) {
            return defaultValue;
        }
        return Integer.parseInt(string);
    }
}

