/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.jaspersoft.jasperserver.api.engine.jasperreports.common;

import java.util.Locale;
import java.util.Map;

/**
 * @author sanda zaharia
 * @version $Id: PdfExportParametersBean.java 19922 2010-12-11 14:59:51Z tmatyashovsky $
 */
public class PdfExportParametersBean extends AbstractExportParameters {
	
	private Map localizedFontMap;
	
	public void setPropertyValues(Object object){
		if(object instanceof PdfExportParametersBean){
			PdfExportParametersBean bean =(PdfExportParametersBean)object;
			this.setLocalizedFontMap(bean.getLocalizedFontMap());
		}
	}

	/**
	 * @return Returns the localizedFontMap.
	 */
	public Map getLocalizedFontMap() {
		return localizedFontMap;
	}

	/**
	 * @param localizedFontMap The localizedFontMap to set.
	 */
	public void setLocalizedFontMap(Map localizedFontMap) {
		this.localizedFontMap = localizedFontMap;
	}
	
	public Map getFontMap(Locale locale) 
	{
		String language = locale.getLanguage();
		String country = locale.getCountry();
		
		Map fontMap = (Map)localizedFontMap.get(language + "_" + country);
		
		if (fontMap == null)
			fontMap = (Map)localizedFontMap.get(language);
		
		return fontMap;
	}
}
