#!/bin/sh
#
# script to run encript command
#

#
# Collect the command line args
#
CMD_LINE_ARGS=$*

JS_CMD_NAME=$0
 

#
# Set command class
#
JS_ENC_CMD_CLASS=com.jaspersoft.jasperserver.export.util.EncryptionUtils
 
#
# Loop through and add all class jars
#
# Jars are in ../jasperserver/WEB-INF/lib or lib
#

if test -d lib
then
    for i in lib/*.jar
    do
        EXP_CLASSPATH="$EXP_CLASSPATH:$i"
    done

else

    for i in ../jasperserver/WEB-INF/lib/*.jar
    do
        EXP_CLASSPATH="$EXP_CLASSPATH:$i"
    done

fi


#
# Locate the java binary bundled with installer
#
# If "../java/bin/java" exists, use it
#

JAVA_EXEC=java

if test -f ../java/bin/java
then
    JAVA_HOME=../java
    PATH=$JAVA_HOME/bin:$PATH
    JAVA_EXEC=$JAVA_HOME/bin/java
fi

# run java
$JAVA_EXEC -cp "$EXP_CLASSPATH" $JS_ENC_CMD_CLASS $JS_CMD_NAME $CMD_LINE_ARGS
