/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.jaspersoft.jasperserver.search.factory.impl;

import com.jaspersoft.jasperserver.search.common.RepositorySearchConfiguration;
import com.jaspersoft.jasperserver.search.common.SearchMode;
import com.jaspersoft.jasperserver.search.factory.RepositorySearchModeFactory;
import com.jaspersoft.jasperserver.search.state.InitialStateResolver;
import com.jaspersoft.jasperserver.search.util.JSONConverter;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Yuriy Plakosh
 * @version $Id$
 */
public class RepositorySearchModeFactoryImpl implements RepositorySearchModeFactory {
    private Map<SearchMode, RepositorySearchConfiguration> repositorySearchConfigurationMap =
            new HashMap<SearchMode, RepositorySearchConfiguration>(SearchMode.values().length);
    private Map<SearchMode, JSONConverter> jsonConverterMap =
            new HashMap<SearchMode, JSONConverter>(SearchMode.values().length);
    private Map<SearchMode, InitialStateResolver> initialStateResolverMap =
            new HashMap<SearchMode, InitialStateResolver>(SearchMode.values().length);

    public void setSearchModeConfiguration(RepositorySearchConfiguration configuration) {
        repositorySearchConfigurationMap.put(SearchMode.SEARCH, configuration);
    }

    public void setBrowseModeConfiguration(RepositorySearchConfiguration configuration) {
        repositorySearchConfigurationMap.put(SearchMode.BROWSE, configuration);
    }

    public void setSearchModeConverter(JSONConverter converter) {
        jsonConverterMap.put(SearchMode.SEARCH, converter);
    }

    public void setBrowseModeConverter(JSONConverter converter) {
        jsonConverterMap.put(SearchMode.BROWSE, converter);
    }

    public void setSearchInitialStateResolver(InitialStateResolver initialStateResolver) {
        initialStateResolverMap.put(SearchMode.SEARCH, initialStateResolver);
    }

    public void setBrowseInitialStateResolver(InitialStateResolver initialStateResolver) {
        initialStateResolverMap.put(SearchMode.BROWSE, initialStateResolver);
    }

    public RepositorySearchConfiguration getConfiguration(SearchMode mode) {
        return repositorySearchConfigurationMap.get(mode);
    }

    public JSONConverter getConverter(SearchMode mode) {
        return jsonConverterMap.get(mode);
    }

    public InitialStateResolver getInitialStateResolver(SearchMode mode) {
        return initialStateResolverMap.get(mode);
    }
}
