/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.irplugin.gui;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.irplugin.JServer;
import com.jaspersoft.jasperserver.irplugin.RepositoryFile;
import com.jaspersoft.jasperserver.irplugin.RepositoryFolder;
import com.jaspersoft.jasperserver.irplugin.RepositoryReportUnit;
import  javax.swing.tree.*;
import  javax.swing.*;
import  java.awt.*;
/**
 *
 * @author  Administrator
 */
public class RepositoryTreeCellRenderer extends DefaultTreeCellRenderer {

    static ImageIcon serverIcon;
    static ImageIcon folderIcon;
    static ImageIcon reportUnitIcon;
    static ImageIcon datasourceJndiIcon;
    static ImageIcon datasourceJdbcIcon;
    static ImageIcon datasourceBeanIcon;
    static ImageIcon datasourceIcon;
    static ImageIcon imageIcon;
    static ImageIcon jrxmlIcon;
    static ImageIcon fontIcon;
    static ImageIcon jarIcon;
    static ImageIcon refIcon;
    static ImageIcon bundleIcon;
    static ImageIcon inputcontrolIcon;
    static ImageIcon datatypeIcon;
    static ImageIcon lovIcon;
    static ImageIcon unknowIcon;
    static ImageIcon queryIcon;
    static ImageIcon waitingIcon;
    
    static ImageIcon reportOptionsResourceIcon;
    


    static 
    {
        if (serverIcon == null) serverIcon = new javax.swing.ImageIcon(RepositoryTreeCellRenderer.class.getResource("/com/jaspersoft/jasperserver/irplugin/res/server.png"));
        if (folderIcon == null) folderIcon = new javax.swing.ImageIcon(RepositoryTreeCellRenderer.class.getResource("/com/jaspersoft/jasperserver/irplugin/res/folder.png"));
        if (reportUnitIcon == null) reportUnitIcon = new javax.swing.ImageIcon(RepositoryTreeCellRenderer.class.getResource("/com/jaspersoft/jasperserver/irplugin/res/reportunit.png"));
        
        if (datasourceJndiIcon == null) datasourceJndiIcon = new javax.swing.ImageIcon(RepositoryTreeCellRenderer.class.getResource("/com/jaspersoft/jasperserver/irplugin/res/datasource_jndi.png"));
        if (datasourceIcon == null) datasourceIcon = new javax.swing.ImageIcon(RepositoryTreeCellRenderer.class.getResource("/com/jaspersoft/jasperserver/irplugin/res/datasource.png"));
        if (datasourceJdbcIcon == null) datasourceJdbcIcon = new javax.swing.ImageIcon(RepositoryTreeCellRenderer.class.getResource("/com/jaspersoft/jasperserver/irplugin/res/datasource_jdbc.png"));
        if (imageIcon == null) imageIcon = new javax.swing.ImageIcon(RepositoryTreeCellRenderer.class.getResource("/com/jaspersoft/jasperserver/irplugin/res/picture.png"));
        if (jrxmlIcon == null) jrxmlIcon = new javax.swing.ImageIcon(RepositoryTreeCellRenderer.class.getResource("/com/jaspersoft/jasperserver/irplugin/res/jrxml_file.png"));
        
        if (refIcon == null) refIcon = new javax.swing.ImageIcon(RepositoryTreeCellRenderer.class.getResource("/com/jaspersoft/jasperserver/irplugin/res/link.png"));
        if (bundleIcon == null) bundleIcon = new javax.swing.ImageIcon(RepositoryTreeCellRenderer.class.getResource("/com/jaspersoft/jasperserver/irplugin/res/bundle.png"));
        if (fontIcon == null) fontIcon = new javax.swing.ImageIcon(RepositoryTreeCellRenderer.class.getResource("/com/jaspersoft/jasperserver/irplugin/res/font.png"));
        if (jarIcon == null) jarIcon = new javax.swing.ImageIcon(RepositoryTreeCellRenderer.class.getResource("/com/jaspersoft/jasperserver/irplugin/res/jar.png"));
        if (inputcontrolIcon == null) inputcontrolIcon = new javax.swing.ImageIcon(RepositoryTreeCellRenderer.class.getResource("/com/jaspersoft/jasperserver/irplugin/res/inputcontrol.png"));
        if (datatypeIcon == null) datatypeIcon = new javax.swing.ImageIcon(RepositoryTreeCellRenderer.class.getResource("/com/jaspersoft/jasperserver/irplugin/res/datatype.png"));
        if (lovIcon == null) lovIcon = new javax.swing.ImageIcon(RepositoryTreeCellRenderer.class.getResource("/com/jaspersoft/jasperserver/irplugin/res/lov.png"));
        
        if (datasourceBeanIcon == null) datasourceBeanIcon = new javax.swing.ImageIcon(RepositoryTreeCellRenderer.class.getResource("/com/jaspersoft/jasperserver/irplugin/res/datasource_bean.png"));
        if (unknowIcon == null) unknowIcon = new javax.swing.ImageIcon(RepositoryTreeCellRenderer.class.getResource("/com/jaspersoft/jasperserver/irplugin/res/unknow.png"));
        if (queryIcon == null) queryIcon = new javax.swing.ImageIcon(RepositoryTreeCellRenderer.class.getResource("/com/jaspersoft/jasperserver/irplugin/res/query.png"));
        
        if (waitingIcon == null) waitingIcon = new javax.swing.ImageIcon(RepositoryTreeCellRenderer.class.getResource("/com/jaspersoft/jasperserver/irplugin/res/waiting.png"));

        if (reportOptionsResourceIcon == null) reportOptionsResourceIcon  = new javax.swing.ImageIcon(RepositoryTreeCellRenderer.class.getResource("/com/jaspersoft/jasperserver/irplugin/res/reportunit_options.png"));
    }
    
    public RepositoryTreeCellRenderer() {
        super();
    }

    public Component getTreeCellRendererComponent(
                        JTree tree,
                        Object value,
                        boolean sel,
                        boolean expanded,
                        boolean leaf,
                        int row,
                        boolean hasFocus) {

        super.getTreeCellRendererComponent(
                        tree, value, sel,
                        expanded, leaf, row,
                        hasFocus);
            this.setForeground( Color.BLACK);
            ImageIcon icon = getElementIcon(value);
            setIcon(icon);

            setToolTipText(null);

        return this;
    }

    protected ImageIcon getElementIcon(Object value) {
        
        if (!(value instanceof DefaultMutableTreeNode)) return folderIcon;
        
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        this.setForeground( Color.BLACK);

        if (node.getUserObject() instanceof JServer)
        {
            if ( ((JServer)node.getUserObject()).isLoading())
            {
                 this.setText( getText() + " (loading...)" );
                 return waitingIcon;
            }
            else return serverIcon;
        }
        if (node.getUserObject() instanceof RepositoryReportUnit) return reportUnitIcon;
        if (node.getUserObject() instanceof RepositoryFile)
        {
            RepositoryFile file = (RepositoryFile)node.getUserObject();
            return getResourceIcon( file.getDescriptor() );
        }
        if (node.getUserObject() instanceof RepositoryFolder) return folderIcon;
        
        return folderIcon;
    }
    
    public static ImageIcon getResourceIcon(ResourceDescriptor resource)
    {
        if (resource == null) return serverIcon;
        else if (resource.getWsType() == null) return serverIcon;
        else if (resource.getIsReference()) return refIcon;
        else if (resource.getWsType().equals(ResourceDescriptor.TYPE_FOLDER)) return folderIcon;
        else if (resource.getWsType().equals(ResourceDescriptor.TYPE_REPORTUNIT)) return reportUnitIcon;
        else if (resource.getWsType().equals(ResourceDescriptor.TYPE_DATASOURCE_JNDI)) return datasourceJndiIcon;
        else if (resource.getWsType().equals(ResourceDescriptor.TYPE_DATASOURCE_JDBC)) return datasourceJdbcIcon;
        else if (resource.getWsType().equals(ResourceDescriptor.TYPE_DATASOURCE_BEAN)) return datasourceBeanIcon;
        else if (resource.getWsType().equals(ResourceDescriptor.TYPE_OLAP_XMLA_CONNECTION)) return datasourceIcon;
        else if (resource.getWsType().equals(ResourceDescriptor.TYPE_IMAGE)) return imageIcon;
        else if (resource.getWsType().equals(ResourceDescriptor.TYPE_JRXML)) return jrxmlIcon;
        else if (resource.getWsType().equals(ResourceDescriptor.TYPE_FONT)) return fontIcon;
        else if (resource.getWsType().equals(ResourceDescriptor.TYPE_CLASS_JAR)) return jarIcon;
        else if (resource.getWsType().equals(ResourceDescriptor.TYPE_RESOURCE_BUNDLE)) return bundleIcon;
        else if (resource.getWsType().equals(ResourceDescriptor.TYPE_INPUT_CONTROL)) return inputcontrolIcon;
        else if (resource.getWsType().equals(ResourceDescriptor.TYPE_DATA_TYPE)) return datatypeIcon;
        else if (resource.getWsType().equals(ResourceDescriptor.TYPE_LOV)) return lovIcon;
        else if (resource.getWsType().equals(ResourceDescriptor.TYPE_QUERY)) return queryIcon;
        else if (resource.getWsType().equals("ReportOptionsResource")) return reportOptionsResourceIcon;
        return unknowIcon;
        
    }
}

