/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.user.service.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;

public class PasswordExpirationProcessingFilter
implements Filter,
InitializingBean {
    private UserAuthorityService userService;
    private String passwordExpirationInDays;

    protected boolean isPasswordExpired(ExecutionContext context, Authentication auth, int nDays) {
        return this.userService.isPasswordExpired(context, auth.getName(), nDays);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null) {
            String fromTrustedHost = (String)request.getAttribute("fromTrustedHost");
            if ("true".equals(fromTrustedHost)) {
                request.removeAttribute("fromTrustedHost");
                chain.doFilter(request, response);
                return;
            }
            int nDays = 0;
            try {
                nDays = Integer.parseInt(this.passwordExpirationInDays);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (nDays > 0 && this.isPasswordExpired(null, auth, nDays)) {
                SecurityContextHolder.getContext().setAuthentication(null);
                chain.doFilter(request, response);
                return;
            }
        }
        request.removeAttribute("fromTrustedHost");
        chain.doFilter(request, response);
    }

    public void afterPropertiesSet() throws Exception {
    }

    public void destroy() {
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    public UserAuthorityService getUserService() {
        return this.userService;
    }

    public void setUserService(UserAuthorityService userService) {
        this.userService = userService;
    }

    public String getPasswordExpirationInDays() {
        return this.passwordExpirationInDays;
    }

    public void setPasswordExpirationInDays(String passwordExpirationInDays) {
        this.passwordExpirationInDays = passwordExpirationInDays;
    }
}

