/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.olap.service.impl;

import com.jaspersoft.jasperserver.api.JSException;
import mondrian.spi.CatalogLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepositoryCatalogLocator
implements CatalogLocator {
    private static final Log log = LogFactory.getLog(RepositoryCatalogLocator.class);
    public static final String SCHEME_DELIMITER = ":";
    public static final String SCHEME_URL_SEPARATOR = ":/";
    private String scheme;

    public RepositoryCatalogLocator() {
        this("repoint");
    }

    public RepositoryCatalogLocator(String scheme) {
        this.scheme = scheme;
    }

    public String locate(String catalogName) {
        if (catalogName == null || catalogName.trim().length() == 0) {
            throw new JSException("No catalog name given for RepositoryCatalogLocator");
        }
        catalogName = catalogName.trim();
        log.debug((Object)("Got: " + catalogName));
        if (catalogName.startsWith(this.scheme + SCHEME_URL_SEPARATOR)) {
            return catalogName;
        }
        int schemeSeparatorPos = catalogName.indexOf(SCHEME_DELIMITER);
        if (schemeSeparatorPos >= 0) {
            catalogName = catalogName.substring(schemeSeparatorPos + 1);
        }
        if (!catalogName.startsWith("/")) {
            catalogName = "/" + catalogName;
        }
        catalogName = this.scheme + SCHEME_DELIMITER + catalogName;
        log.debug((Object)("returned: " + catalogName));
        return catalogName;
    }
}

