/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.scheduling.quartz;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.LogEvent;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.common.util.CharacterEncodingProvider;
import com.jaspersoft.jasperserver.api.common.util.LocaleHelper;
import com.jaspersoft.jasperserver.api.engine.common.domain.Request;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.common.service.LoggingService;
import com.jaspersoft.jasperserver.api.engine.common.service.SecurityContextProvider;
import com.jaspersoft.jasperserver.api.engine.common.service.VirtualizerFactory;
import com.jaspersoft.jasperserver.api.engine.common.service.impl.ContentResourceURIResolver;
import com.jaspersoft.jasperserver.api.engine.jasperreports.common.CsvExportParametersBean;
import com.jaspersoft.jasperserver.api.engine.jasperreports.common.OdsExportParametersBean;
import com.jaspersoft.jasperserver.api.engine.jasperreports.common.PdfExportParametersBean;
import com.jaspersoft.jasperserver.api.engine.jasperreports.common.TxtExportParametersBean;
import com.jaspersoft.jasperserver.api.engine.jasperreports.common.XlsExportParametersBean;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitRequest;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitResult;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobIdHolder;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobMailNotification;
import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJobRepositoryDestination;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.Output;
import com.jaspersoft.jasperserver.api.engine.scheduling.quartz.ReportOutput;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportJobsPersistenceService;
import com.jaspersoft.jasperserver.api.logging.audit.context.AuditContext;
import com.jaspersoft.jasperserver.api.logging.audit.context.impl.DummyAuditContext;
import com.jaspersoft.jasperserver.api.logging.audit.domain.AuditEvent;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ContentResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataContainerFactory;
import com.jaspersoft.jasperserver.api.metadata.common.domain.MemoryDataContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.util.DataContainerResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.util.DataContainerStreamUtil;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.util.LockHandle;
import com.jaspersoft.jasperserver.api.metadata.common.util.LockManager;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JExcelApiExporter;
import net.sf.jasperreports.engine.export.JExcelApiExporterParameter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRCsvExporterParameter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRTextExporter;
import net.sf.jasperreports.engine.export.JRTextExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.export.oasis.JROdsExporter;
import net.sf.jasperreports.engine.export.oasis.JROdtExporter;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

public class ReportExecutionJob
implements Job {
    private static final Log log = LogFactory.getLog(ReportExecutionJob.class);
    public static final String REPORT_PARAMETER_SCHEDULED_TIME = "_ScheduledTime";
    public static final String REPOSITORY_FILENAME_SEQUENCE_SEPARATOR = "-";
    public static final String REPOSITORY_FILENAME_TIMESTAMP_SEQUENCE_PATTERN = "yyyyMMddHHmm";
    public static final String SCHEDULER_CONTEXT_KEY_APPLICATION_CONTEXT = "applicationContext";
    public static final String SCHEDULER_CONTEXT_KEY_JOB_PERSISTENCE_SERVICE = "jobPersistenceService";
    public static final String SCHEDULER_CONTEXT_KEY_ENGINE_SERVICE = "engineService";
    public static final String SCHEDULER_CONTEXT_KEY_VIRTUALIZER_FACTORY = "virtualizerFactory";
    public static final String SCHEDULER_CONTEXT_KEY_REPOSITORY = "repositoryService";
    public static final String SCHEDULER_CONTEXT_KEY_MAIL_SENDER = "mailSender";
    public static final String SCHEDULER_CONTEXT_KEY_MAIL_FROM_ADDRESS = "mailFromAddress";
    public static final String SCHEDULER_CONTEXT_KEY_LOGGING_SERVICE = "loggingService";
    public static final String SCHEDULER_CONTEXT_KEY_SECURITY_CONTEXT_PROVIDER = "securityContextProvider";
    public static final String SCHEDULER_CONTEXT_KEY_HYPERLINK_PRODUCER_FACTORY = "hyperlinkProducerFactory";
    public static final String SCHEDULER_CONTEXT_KEY_ENCODING_PROVIDER = "encodingProvider";
    public static final String SCHEDULER_CONTEXT_KEY_EXPORT_PARAMETRES_MAP = "exportParametersMap";
    public static final String SCHEDULER_CONTEXT_KEY_DATA_CONTAINER_FACTORY = "dataContainerFactory";
    public static final String SCHEDULER_CONTEXT_KEY_CONTENT_RESOURCE_URI_RESOLVER = "contentResourceURIResolver";
    public static final String SCHEDULER_CONTEXT_KEY_LOCK_MANAGER = "lockManager";
    public static final String SCHEDULER_CONTEXT_KEY_OUTPUT_FORMAT_MAP = "outputFormatMap";
    public static final String SCHEDULER_CONTEXT_KEY_OUTPUT_KEY_MAPPING = "outputKeyMapping";
    public static final String JOB_DATA_KEY_DETAILS_ID = "jobDetailsID";
    public static final String JOB_DATA_KEY_USERNAME = "jobUser";
    public static final String LOGGING_COMPONENT = "reportScheduler";
    protected static final String LOCK_NAME_CONTENT_RESOURCE = "reportSchedulerOutput";
    protected List exceptions = new ArrayList();
    protected ApplicationContext applicationContext;
    protected String username;
    protected ReportJob jobDetails;
    protected JobExecutionContext jobContext;
    protected SchedulerContext schedulerContext;
    protected ExecutionContext executionContext;
    protected static AuditContext auditContext = new DummyAuditContext();

    public static void setAuditContext(AuditContext auditContext) {
        ReportExecutionJob.auditContext = auditContext;
    }

    protected void createAuditEvent() {
        auditContext.doInAuditContext(new AuditContext.AuditContextCallback(){

            public void execute() {
                auditContext.createAuditEvent("runReport");
            }
        });
    }

    protected void addExceptionToAuditEvent(final Throwable ex) {
        auditContext.doInAuditContext("runReport", new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                auditContext.addPropertyToAuditEvent("exception", (Object)ex, auditEvent);
            }
        });
    }

    protected void closeAuditEvent() {
        auditContext.doInAuditContext("runReport", new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                auditContext.closeAuditEvent(auditEvent);
                auditContext.flushContext();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            this.jobContext = context;
            this.schedulerContext = this.jobContext.getScheduler().getContext();
            this.applicationContext = (ApplicationContext)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_APPLICATION_CONTEXT);
            this.username = this.getUsername();
            SecurityContextProvider securityContextProvider = this.getSecurityContextProvider();
            securityContextProvider.setAuthenticatedUser(this.username);
            this.createAuditEvent();
            try {
                this.executeAndSendReport();
            }
            finally {
                securityContextProvider.revertAuthenticatedUser();
            }
        }
        catch (JobExecutionException e) {
            this.addExceptionToAuditEvent(e);
            throw e;
        }
        catch (SchedulerException e) {
            this.addExceptionToAuditEvent(e);
            throw new JobExecutionException((Exception)((Object)e));
        }
        finally {
            this.closeAuditEvent();
            this.clear();
        }
    }

    protected void initJobExecution() {
        this.updateExecutionContextDetails();
    }

    protected void clear() {
        this.exceptions.clear();
        this.jobContext = null;
        this.schedulerContext = null;
        this.jobDetails = null;
        this.executionContext = null;
        this.username = null;
    }

    protected String getUsername() {
        JobDataMap jobDataMap = this.jobContext.getTrigger().getJobDataMap();
        return jobDataMap.getString(JOB_DATA_KEY_USERNAME);
    }

    protected ExecutionContext getExecutionContext() {
        return new ExecutionContextImpl();
    }

    protected void updateExecutionContextDetails() {
        ExecutionContextImpl context = (ExecutionContextImpl)this.executionContext;
        context.setLocale(this.getLocale());
        context.setTimeZone(TimeZone.getDefault());
    }

    protected Locale getJobLocale() {
        String localeCode = this.jobDetails.getOutputLocale();
        Locale locale = localeCode != null && localeCode.length() > 0 ? LocaleHelper.getInstance().getLocale(localeCode) : null;
        return locale;
    }

    protected Locale getMessageLocale() {
        return this.getLocale();
    }

    protected Locale getLocale() {
        Locale locale = null;
        if (this.jobDetails != null) {
            locale = this.getJobLocale();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    protected String getMessage(String key, Object[] arguments) {
        return this.applicationContext.getMessage(key, arguments, this.getMessageLocale());
    }

    protected void handleException(String message, Throwable exc) {
        log.error((Object)message, exc);
        this.exceptions.add(new ExceptionInfo(message, exc));
    }

    protected boolean hasExceptions() {
        return !this.exceptions.isEmpty();
    }

    protected void checkExceptions() throws JobExecutionException {
        if (this.hasExceptions()) {
            ExceptionInfo firstException = (ExceptionInfo)this.exceptions.get(0);
            try {
                this.logExceptions();
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                this.throwJobExecutionException(firstException);
            }
            this.throwJobExecutionException(firstException);
        }
    }

    protected void throwJobExecutionException(ExceptionInfo exceptionInfo) throws JobExecutionException {
        Throwable exception = exceptionInfo.getException();
        JobExecutionException jobException = exception instanceof Exception ? new JobExecutionException(exceptionInfo.getMessage(), (Exception)exception, false) : new JobExecutionException(exceptionInfo.getMessage());
        throw jobException;
    }

    protected void logExceptions() {
        LoggingService loggingService = this.getLoggingService();
        LogEvent event = loggingService.instantiateLogEvent();
        event.setComponent(LOGGING_COMPONENT);
        event.setType((byte)1);
        event.setMessageCode("log.error.report.job.failed");
        if (this.jobDetails != null) {
            event.setResourceURI(this.jobDetails.getSource().getReportUnitURI());
        }
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        if (this.jobDetails != null) {
            printWriter.println("Job: " + this.jobDetails.getLabel() + " (ID: " + this.jobDetails.getId() + ")");
            printWriter.println("Report unit: " + this.jobDetails.getSource().getReportUnitURI());
        }
        printWriter.println("Quartz Job: " + this.jobContext.getJobDetail().getFullName());
        printWriter.println("Quartz Trigger: " + this.jobContext.getTrigger().getFullName());
        printWriter.println("Exceptions:");
        ListIterator it = this.exceptions.listIterator();
        while (it.hasNext()) {
            ExceptionInfo exceptionInfo = (ExceptionInfo)it.next();
            printWriter.println();
            printWriter.println(exceptionInfo.getMessage());
            Throwable exception = exceptionInfo.getException();
            if (exception == null) continue;
            exception.printStackTrace(printWriter);
        }
        printWriter.flush();
        event.setText(writer.toString());
        event.setState((byte)1);
        loggingService.log(event);
    }

    protected SecurityContextProvider getSecurityContextProvider() {
        return (SecurityContextProvider)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_SECURITY_CONTEXT_PROVIDER);
    }

    protected LoggingService getLoggingService() {
        return (LoggingService)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_LOGGING_SERVICE);
    }

    protected ReportJob getJobDetails() {
        ReportJobsPersistenceService persistenceService = this.getPersistenceService();
        JobDataMap jobDataMap = this.jobContext.getTrigger().getJobDataMap();
        long jobId = jobDataMap.getLong(JOB_DATA_KEY_DETAILS_ID);
        ReportJob job = persistenceService.loadJob(this.executionContext, new ReportJobIdHolder(jobId));
        return job;
    }

    protected ReportJobsPersistenceService getPersistenceService() {
        return (ReportJobsPersistenceService)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_JOB_PERSISTENCE_SERVICE);
    }

    protected EngineService getEngineService() {
        EngineService engineService = (EngineService)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_ENGINE_SERVICE);
        return engineService;
    }

    protected VirtualizerFactory getVirtualizerFactory() {
        return (VirtualizerFactory)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_VIRTUALIZER_FACTORY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeAndSendReport() throws JobExecutionException {
        try {
            this.executionContext = this.getExecutionContext();
            this.jobDetails = this.getJobDetails();
            this.initJobExecution();
            ReportUnitResult result = null;
            try {
                ReportJobMailNotification mailNotification;
                try {
                    result = this.executeReport();
                }
                catch (Exception e) {
                    this.handleException(this.getMessage("report.scheduling.error.filling.report", null), e);
                }
                List outputs = null;
                if (result != null) {
                    outputs = this.createReportOutputs(result);
                    this.saveToRepository(outputs);
                }
                if ((mailNotification = this.jobDetails.getMailNotification()) != null) {
                    boolean skipEmpty;
                    boolean bl = skipEmpty = mailNotification.isSkipEmptyReports() && this.isEmpty(result);
                    if (!skipEmpty || this.hasExceptions()) {
                        List attachments = skipEmpty ? null : outputs;
                        try {
                            this.sendMailNotification(attachments);
                        }
                        catch (Exception e) {
                            this.handleException(this.getMessage("report.scheduling.error.sending.email.notification", null), e);
                        }
                    }
                }
            }
            finally {
                VirtualizerFactory virtualizerFactory;
                if (result != null && (virtualizerFactory = this.getVirtualizerFactory()) != null) {
                    virtualizerFactory.disposeVirtualizer(result.getVirtualizer());
                }
            }
        }
        catch (Throwable e) {
            this.handleException(this.getMessage("report.scheduling.error.system", null), e);
        }
        finally {
            this.checkExceptions();
        }
    }

    protected void setReadOnly(ReportUnitResult result) {
        JRVirtualizationContext virtualizationContext;
        if (result.getVirtualizer() != null && (virtualizationContext = JRVirtualizationContext.getRegistered((JasperPrint)result.getJasperPrint())) != null) {
            virtualizationContext.setReadOnly(true);
        }
    }

    protected ReportUnitResult executeReport() {
        Map parametersMap = this.collectReportParameters();
        ReportUnitRequest request = new ReportUnitRequest(this.getReportUnitURI(), parametersMap);
        EngineService engineService = this.getEngineService();
        ReportUnitResult result = (ReportUnitResult)engineService.execute(this.executionContext, (Request)request);
        this.setReadOnly(result);
        return result;
    }

    protected Map collectReportParameters() {
        HashMap params = new HashMap();
        Map jobParams = this.jobDetails.getSource().getParametersMap();
        if (jobParams != null) {
            params.putAll(jobParams);
        }
        this.putAdditionalParameters(params);
        return params;
    }

    protected void putAdditionalParameters(Map parametersMap) {
        VirtualizerFactory virtualizerFactory;
        if (!parametersMap.containsKey(REPORT_PARAMETER_SCHEDULED_TIME)) {
            Date scheduledFireTime = this.jobContext.getScheduledFireTime();
            parametersMap.put(REPORT_PARAMETER_SCHEDULED_TIME, scheduledFireTime);
        }
        if ((virtualizerFactory = this.getVirtualizerFactory()) != null) {
            parametersMap.put("REPORT_VIRTUALIZER", virtualizerFactory.getVirtualizer());
        }
    }

    protected List createReportOutputs(ReportUnitResult result) throws JobExecutionException {
        JasperPrint jasperPrint = result.getJasperPrint();
        String baseFilename = this.jobDetails.getBaseOutputFilename();
        if (this.jobDetails.getContentRepositoryDestination().isSequentialFilenames()) {
            Date scheduledTime = this.jobContext.getScheduledFireTime();
            SimpleDateFormat format = this.getTimestampFormat();
            baseFilename = this.jobDetails.getBaseOutputFilename() + REPOSITORY_FILENAME_SEQUENCE_SEPARATOR + format.format(scheduledTime);
        } else {
            baseFilename = this.jobDetails.getBaseOutputFilename();
        }
        Set outputFormats = this.jobDetails.getOutputFormats();
        ArrayList<ReportOutput> outputs = new ArrayList<ReportOutput>(outputFormats.size());
        for (Byte format : outputFormats) {
            ReportOutput output = null;
            try {
                output = this.getReportOutput(jasperPrint, format, baseFilename);
                outputs.add(output);
            }
            catch (Exception e) {
                String formatKey = this.getMessage("report.scheduling.output.format." + format, null);
                String formatLabel = this.getMessage("report.output." + formatKey + ".label", null);
                this.handleException(this.getMessage("report.scheduling.error.exporting.report", new Object[]{formatLabel}), e);
            }
        }
        return outputs;
    }

    protected SimpleDateFormat getTimestampFormat() {
        String pattern = this.jobDetails.getContentRepositoryDestination().getTimestampPattern();
        if (pattern == null || pattern.length() == 0) {
            pattern = REPOSITORY_FILENAME_TIMESTAMP_SEQUENCE_PATTERN;
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern, this.getLocale());
        return format;
    }

    protected void saveToRepository(List outputs) {
        for (ReportOutput output : outputs) {
            try {
                this.saveToRepository(output);
            }
            catch (Exception e) {
                this.handleException(this.getMessage("report.scheduling.error.saving.to.repository", new Object[]{output.getFilename()}), e);
            }
        }
    }

    protected boolean isEmpty(ReportUnitResult result) {
        JRPrintPage page;
        List elements;
        if (result == null) {
            return false;
        }
        JasperPrint jasperPrint = result.getJasperPrint();
        List pages = jasperPrint.getPages();
        boolean empty = pages == null || pages.isEmpty() ? true : (pages.size() == 1 ? (elements = (page = (JRPrintPage)pages.get(0)).getElements()) == null || elements.isEmpty() : false);
        return empty;
    }

    protected ReportOutput getReportOutput(JasperPrint jasperPrint, Byte format, String baseFilename) throws JobExecutionException {
        if (format == null) {
            throw new JSException("jsexception.report.unknown.output.format", new Object[]{"null"});
        }
        String fileExtension = (String)this.getOutputKeyMapping().get(format.toString());
        if (fileExtension == null) {
            throw new JSException("jsexception.report.unknown.output.format", new Object[]{new Byte(format)});
        }
        return ((Output)this.getOutputFormatMap().get(fileExtension)).getOutput(this.getEngineService(), this.executionContext, this.getReportUnitURI(), this.createDataContainer(), this.getHyperlinkProducerFactory(), this.getRepository(), jasperPrint, baseFilename, this.getLocale(), this.getCharacterEncoding());
    }

    protected String getChildrenFolderName(String resourceName) {
        return this.getRepository().getChildrenFolderName(resourceName);
    }

    protected ReportOutput getPdfOutput(JasperPrint jasperPrint, String baseFilename) throws JobExecutionException {
        HashMap<JRExporterParameter, Object> params = new HashMap<JRExporterParameter, Object>();
        params.put(JRExporterParameter.JASPER_PRINT, jasperPrint);
        DataContainer pdfData = this.createDataContainer();
        boolean close = true;
        OutputStream pdfDataOut = pdfData.getOutputStream();
        try {
            params.put(JRExporterParameter.OUTPUT_STREAM, pdfDataOut);
            PdfExportParametersBean exportParams = (PdfExportParametersBean)this.getExportParametersMap().get("pdf");
            Map localizedFontMap = exportParams.getFontMap(this.getLocale());
            if (localizedFontMap != null) {
                params.put(JRExporterParameter.FONT_MAP, localizedFontMap);
            }
            this.getEngineService().exportToPdf(this.executionContext, this.getReportUnitURI(), params);
            close = false;
            pdfDataOut.close();
        }
        catch (IOException e) {
            throw new JSExceptionWrapper((Exception)e);
        }
        finally {
            if (close) {
                try {
                    pdfDataOut.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error closing stream", (Throwable)e);
                }
            }
        }
        String filename = baseFilename + ".pdf";
        return new ReportOutput(pdfData, "pdf", filename);
    }

    protected String getReportUnitURI() {
        return this.jobDetails.getSource().getReportUnitURI();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ReportOutput getHtmlOutput(JasperPrint jasperPrint, String baseFilename) throws JobExecutionException {
        try {
            String filename = baseFilename + ".html";
            JRHtmlExporter exporter = new JRHtmlExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)this.getCharacterEncoding());
            DataContainer htmlData = this.createDataContainer();
            boolean close = true;
            OutputStream htmlDataOut = htmlData.getOutputStream();
            try {
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)htmlDataOut);
                HashMap images = new HashMap();
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_MAP, images);
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)(this.getChildrenFolderName(filename) + '/'));
                JRHyperlinkProducerFactory hyperlinkProducerFactory = this.getHyperlinkProducerFactory();
                if (hyperlinkProducerFactory != null) {
                    exporter.setParameter(JRExporterParameter.HYPERLINK_PRODUCER_FACTORY, (Object)hyperlinkProducerFactory);
                }
                exporter.exportReport();
                close = false;
                htmlDataOut.close();
                ReportOutput htmlOutput = new ReportOutput(htmlData, "html", filename);
                for (Map.Entry imageEntry : images.entrySet()) {
                    String imageName = (String)imageEntry.getKey();
                    byte[] imageData = (byte[])imageEntry.getValue();
                    MemoryDataContainer imageDataContainer = new MemoryDataContainer(imageData);
                    ReportOutput image = new ReportOutput((DataContainer)imageDataContainer, "img", imageName);
                    htmlOutput.addChild(image);
                }
                ReportOutput reportOutput = htmlOutput;
                return reportOutput;
            }
            catch (IOException e) {
                throw new JSExceptionWrapper((Exception)e);
            }
            finally {
                if (close) {
                    try {
                        htmlDataOut.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error closing stream", (Throwable)e);
                    }
                }
            }
        }
        catch (JRException e) {
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    protected JRHyperlinkProducerFactory getHyperlinkProducerFactory() {
        JRHyperlinkProducerFactory engineService = (JRHyperlinkProducerFactory)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_HYPERLINK_PRODUCER_FACTORY);
        return engineService;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ReportOutput getXlsOutput(JasperPrint jasperPrint, String baseFilename) throws JobExecutionException {
        try {
            JExcelApiExporter exporter = new JExcelApiExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            DataContainer xlsData = this.createDataContainer();
            boolean close = false;
            OutputStream xlsDataOut = xlsData.getOutputStream();
            try {
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)xlsDataOut);
                exporter.setParameter(JExcelApiExporterParameter.CREATE_CUSTOM_PALETTE, (Object)Boolean.TRUE);
                XlsExportParametersBean exportParams = (XlsExportParametersBean)this.getExportParametersMap().get("xls");
                if (exportParams != null) {
                    if (exportParams.getOnePagePerSheet() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)exportParams.getOnePagePerSheet());
                    if (exportParams.getDetectCellType() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_DETECT_CELL_TYPE, (Object)exportParams.getDetectCellType());
                    if (exportParams.getRemoveEmptySpaceBetweenRows() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)exportParams.getRemoveEmptySpaceBetweenRows());
                    if (exportParams.getRemoveEmptySpaceBetweenColumns() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_COLUMNS, (Object)exportParams.getRemoveEmptySpaceBetweenColumns());
                    if (exportParams.getWhitePageBackground() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)exportParams.getWhitePageBackground());
                    if (exportParams.getIgnoreGraphics() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_IGNORE_GRAPHICS, (Object)exportParams.getIgnoreGraphics());
                    if (exportParams.getCollapseRowSpan() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_COLLAPSE_ROW_SPAN, (Object)exportParams.getCollapseRowSpan());
                    if (exportParams.getIgnoreCellBorder() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_IGNORE_CELL_BORDER, (Object)exportParams.getIgnoreCellBorder());
                    if (exportParams.getFontSizeFixEnabled() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_FONT_SIZE_FIX_ENABLED, (Object)exportParams.getFontSizeFixEnabled());
                    if (exportParams.getMaximumRowsPerSheet() != null) {
                        // empty if block
                    }
                    exporter.setParameter(JRXlsExporterParameter.MAXIMUM_ROWS_PER_SHEET, (Object)exportParams.getMaximumRowsPerSheet());
                    if (exportParams.getXlsFormatPatternsMap() == null || !exportParams.getXlsFormatPatternsMap().isEmpty()) {
                        // empty if block
                    }
                    exporter.setParameter(JRXlsExporterParameter.FORMAT_PATTERNS_MAP, (Object)exportParams.getXlsFormatPatternsMap());
                }
                exporter.exportReport();
                close = false;
                xlsDataOut.close();
                String filename = baseFilename + ".xls";
                ReportOutput reportOutput = new ReportOutput(xlsData, "xls", filename);
                return reportOutput;
            }
            catch (IOException e) {
                throw new JSExceptionWrapper((Exception)e);
            }
            finally {
                if (close) {
                    try {
                        xlsDataOut.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error closing stream", (Throwable)e);
                    }
                }
            }
        }
        catch (JRException e) {
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ReportOutput getXlsxOutput(JasperPrint jasperPrint, String baseFilename) throws JobExecutionException {
        try {
            JRXlsxExporter exporter = new JRXlsxExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            DataContainer xlsxData = this.createDataContainer();
            boolean close = false;
            OutputStream xlsxDataOut = xlsxData.getOutputStream();
            try {
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)xlsxDataOut);
                exporter.setParameter(JExcelApiExporterParameter.CREATE_CUSTOM_PALETTE, (Object)Boolean.TRUE);
                XlsExportParametersBean exportParams = (XlsExportParametersBean)this.getExportParametersMap().get("xlsx");
                if (exportParams != null) {
                    if (exportParams.getOnePagePerSheet() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)exportParams.getOnePagePerSheet());
                    if (exportParams.getDetectCellType() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_DETECT_CELL_TYPE, (Object)exportParams.getDetectCellType());
                    if (exportParams.getRemoveEmptySpaceBetweenRows() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)exportParams.getRemoveEmptySpaceBetweenRows());
                    if (exportParams.getRemoveEmptySpaceBetweenColumns() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_COLUMNS, (Object)exportParams.getRemoveEmptySpaceBetweenColumns());
                    if (exportParams.getWhitePageBackground() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)exportParams.getWhitePageBackground());
                    if (exportParams.getIgnoreGraphics() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_IGNORE_GRAPHICS, (Object)exportParams.getIgnoreGraphics());
                    if (exportParams.getCollapseRowSpan() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_COLLAPSE_ROW_SPAN, (Object)exportParams.getCollapseRowSpan());
                    if (exportParams.getIgnoreCellBorder() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_IGNORE_CELL_BORDER, (Object)exportParams.getIgnoreCellBorder());
                    if (exportParams.getFontSizeFixEnabled() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_FONT_SIZE_FIX_ENABLED, (Object)exportParams.getFontSizeFixEnabled());
                    if (exportParams.getMaximumRowsPerSheet() != null) {
                        // empty if block
                    }
                    exporter.setParameter(JRXlsExporterParameter.MAXIMUM_ROWS_PER_SHEET, (Object)exportParams.getMaximumRowsPerSheet());
                    if (exportParams.getXlsFormatPatternsMap() == null || !exportParams.getXlsFormatPatternsMap().isEmpty()) {
                        // empty if block
                    }
                    exporter.setParameter(JRXlsExporterParameter.FORMAT_PATTERNS_MAP, (Object)exportParams.getXlsFormatPatternsMap());
                }
                exporter.exportReport();
                close = false;
                xlsxDataOut.close();
                String filename = baseFilename + ".xlsx";
                ReportOutput reportOutput = new ReportOutput(xlsxData, "xlsx", filename);
                return reportOutput;
            }
            catch (IOException e) {
                throw new JSExceptionWrapper((Exception)e);
            }
            finally {
                if (close) {
                    try {
                        xlsxDataOut.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error closing stream", (Throwable)e);
                    }
                }
            }
        }
        catch (JRException e) {
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ReportOutput getOdsOutput(JasperPrint jasperPrint, String baseFilename) throws JobExecutionException {
        try {
            JROdsExporter exporter = new JROdsExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            DataContainer odsData = this.createDataContainer();
            boolean close = false;
            OutputStream odsDataOut = odsData.getOutputStream();
            try {
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)odsDataOut);
                exporter.setParameter(JExcelApiExporterParameter.CREATE_CUSTOM_PALETTE, (Object)Boolean.TRUE);
                OdsExportParametersBean exportParams = (OdsExportParametersBean)this.getExportParametersMap().get("ods");
                if (exportParams != null) {
                    if (exportParams.getOnePagePerSheet() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)exportParams.getOnePagePerSheet());
                    if (exportParams.getDetectCellType() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_DETECT_CELL_TYPE, (Object)exportParams.getDetectCellType());
                    if (exportParams.getRemoveEmptySpaceBetweenRows() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)exportParams.getRemoveEmptySpaceBetweenRows());
                    if (exportParams.getRemoveEmptySpaceBetweenColumns() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_COLUMNS, (Object)exportParams.getRemoveEmptySpaceBetweenColumns());
                    if (exportParams.getWhitePageBackground() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)exportParams.getWhitePageBackground());
                    if (exportParams.getIgnoreGraphics() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_IGNORE_GRAPHICS, (Object)exportParams.getIgnoreGraphics());
                    if (exportParams.getCollapseRowSpan() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_COLLAPSE_ROW_SPAN, (Object)exportParams.getCollapseRowSpan());
                    if (exportParams.getIgnoreCellBorder() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_IGNORE_CELL_BORDER, (Object)exportParams.getIgnoreCellBorder());
                    if (exportParams.getFontSizeFixEnabled() != null) {
                        // empty if block
                    }
                    exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_FONT_SIZE_FIX_ENABLED, (Object)exportParams.getFontSizeFixEnabled());
                    if (exportParams.getMaximumRowsPerSheet() != null) {
                        // empty if block
                    }
                    exporter.setParameter(JRXlsExporterParameter.MAXIMUM_ROWS_PER_SHEET, (Object)exportParams.getMaximumRowsPerSheet());
                    if (exportParams.getXlsFormatPatternsMap() == null || !exportParams.getXlsFormatPatternsMap().isEmpty()) {
                        // empty if block
                    }
                    exporter.setParameter(JRXlsExporterParameter.FORMAT_PATTERNS_MAP, (Object)exportParams.getXlsFormatPatternsMap());
                }
                exporter.exportReport();
                close = false;
                odsDataOut.close();
                String filename = baseFilename + ".ods";
                ReportOutput reportOutput = new ReportOutput(odsData, "ods", filename);
                return reportOutput;
            }
            catch (IOException e) {
                throw new JSExceptionWrapper((Exception)e);
            }
            finally {
                if (close) {
                    try {
                        odsDataOut.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error closing stream", (Throwable)e);
                    }
                }
            }
        }
        catch (JRException e) {
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ReportOutput getRtfOutput(JasperPrint jasperPrint, String baseFilename) throws JobExecutionException {
        try {
            JRRtfExporter exporter = new JRRtfExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            DataContainer rtfData = this.createDataContainer();
            boolean close = false;
            OutputStream rtfDataOut = rtfData.getOutputStream();
            try {
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)rtfDataOut);
                exporter.exportReport();
                close = false;
                rtfDataOut.close();
                String fileName = baseFilename + ".rtf";
                ReportOutput reportOutput = new ReportOutput(rtfData, "rtf", fileName);
                return reportOutput;
            }
            catch (IOException e) {
                throw new JSExceptionWrapper((Exception)e);
            }
            finally {
                if (close) {
                    try {
                        rtfDataOut.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error closing stream", (Throwable)e);
                    }
                }
            }
        }
        catch (JRException e) {
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ReportOutput getCsvOutput(JasperPrint jasperPrint, String baseFilename) throws JobExecutionException {
        try {
            JRCsvExporter exporter = new JRCsvExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            DataContainer csvData = this.createDataContainer();
            boolean close = false;
            OutputStream csvDataOut = csvData.getOutputStream();
            try {
                exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)this.getCharacterEncoding());
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)csvDataOut);
                CsvExportParametersBean exportParams = (CsvExportParametersBean)this.getExportParametersMap().get("csv");
                if (exportParams != null) {
                    exporter.setParameter((JRExporterParameter)JRCsvExporterParameter.FIELD_DELIMITER, (Object)exportParams.getFieldDelimiter());
                }
                exporter.exportReport();
                close = false;
                csvDataOut.close();
                String fileName = baseFilename + ".csv";
                ReportOutput reportOutput = new ReportOutput(csvData, "csv", fileName);
                return reportOutput;
            }
            catch (IOException e) {
                throw new JSExceptionWrapper((Exception)e);
            }
            finally {
                if (close) {
                    try {
                        csvDataOut.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error closing stream", (Throwable)e);
                    }
                }
            }
        }
        catch (JRException e) {
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ReportOutput getTxtOutput(JasperPrint jasperPrint, String baseFilename) throws JobExecutionException {
        try {
            JRTextExporter exporter = new JRTextExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            DataContainer txtData = this.createDataContainer();
            boolean close = false;
            OutputStream txtDataOut = txtData.getOutputStream();
            try {
                exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)this.getCharacterEncoding());
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)txtDataOut);
                TxtExportParametersBean exportParams = (TxtExportParametersBean)this.getExportParametersMap().get("txt");
                if (exportParams != null) {
                    exporter.setParameter((JRExporterParameter)JRTextExporterParameter.CHARACTER_HEIGHT, (Object)exportParams.getCharacterHeight());
                    exporter.setParameter((JRExporterParameter)JRTextExporterParameter.CHARACTER_WIDTH, (Object)exportParams.getCharacterWidth());
                    exporter.setParameter((JRExporterParameter)JRTextExporterParameter.PAGE_HEIGHT, (Object)exportParams.getPageHeight());
                    exporter.setParameter((JRExporterParameter)JRTextExporterParameter.PAGE_WIDTH, (Object)exportParams.getPageWidth());
                }
                exporter.exportReport();
                close = false;
                txtDataOut.close();
                String fileName = baseFilename + ".txt";
                ReportOutput reportOutput = new ReportOutput(txtData, "txt", fileName);
                return reportOutput;
            }
            catch (IOException e) {
                throw new JSExceptionWrapper((Exception)e);
            }
            finally {
                if (close) {
                    try {
                        txtDataOut.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error closing stream", (Throwable)e);
                    }
                }
            }
        }
        catch (JRException e) {
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ReportOutput getOdtOutput(JasperPrint jasperPrint, String baseFilename) throws JobExecutionException {
        try {
            JROdtExporter exporter = new JROdtExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            DataContainer odtData = this.createDataContainer();
            boolean close = false;
            OutputStream odtDataOut = odtData.getOutputStream();
            try {
                exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)this.getCharacterEncoding());
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)odtDataOut);
                exporter.exportReport();
                close = false;
                odtDataOut.close();
                String fileName = baseFilename + ".odt";
                ReportOutput reportOutput = new ReportOutput(odtData, "odt", fileName);
                return reportOutput;
            }
            catch (IOException e) {
                throw new JSExceptionWrapper((Exception)e);
            }
            finally {
                if (close) {
                    try {
                        odtDataOut.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error closing stream", (Throwable)e);
                    }
                }
            }
        }
        catch (JRException e) {
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ReportOutput getDocxOutput(JasperPrint jasperPrint, String baseFilename) throws JobExecutionException {
        try {
            JRDocxExporter exporter = new JRDocxExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            DataContainer docData = this.createDataContainer();
            boolean close = false;
            OutputStream docDataOut = docData.getOutputStream();
            try {
                exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)this.getCharacterEncoding());
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)docDataOut);
                exporter.exportReport();
                close = false;
                docDataOut.close();
                String fileName = baseFilename + ".docx";
                ReportOutput reportOutput = new ReportOutput(docData, "docx", fileName);
                return reportOutput;
            }
            catch (IOException e) {
                throw new JSExceptionWrapper((Exception)e);
            }
            finally {
                if (close) {
                    try {
                        docDataOut.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error closing stream", (Throwable)e);
                    }
                }
            }
        }
        catch (JRException e) {
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveToRepository(ReportOutput output) {
        RepositoryService repositoryService = this.getRepository();
        ReportJobRepositoryDestination repositoryDestination = this.jobDetails.getContentRepositoryDestination();
        List children = output.getChildren();
        ArrayList<ContentResource> childResources = new ArrayList<ContentResource>(children.size());
        for (ReportOutput childOutput : children) {
            ContentResource childRes = (ContentResource)repositoryService.newResource(this.executionContext, ContentResource.class);
            childRes.setName(childOutput.getFilename());
            childRes.setLabel(childOutput.getFilename());
            childRes.setFileType(childOutput.getFileType());
            childRes.setDataContainer(childOutput.getData());
            childResources.add(childRes);
        }
        ContentResource contentRes = null;
        String resURI = repositoryDestination.getFolderURI() + "/" + output.getFilename();
        LockHandle lock = this.lockOutputResource(resURI);
        try {
            Resource existingRes = repositoryService.getResource(this.executionContext, resURI);
            if (repositoryDestination.isOverwriteFiles()) {
                if (existingRes != null) {
                    if (!(existingRes instanceof ContentResource)) {
                        String quotedResURI = "\"" + resURI + "\"";
                        throw new JSException("jsexception.report.no.content.resource", new Object[]{quotedResURI});
                    }
                    contentRes = (ContentResource)existingRes;
                }
            } else if (existingRes != null) {
                throw new JSException("jsexception.report.resource.already.exists.no.overwrite", new Object[]{resURI});
            }
            if (contentRes == null) {
                contentRes = (ContentResource)repositoryService.newResource(this.executionContext, ContentResource.class);
                contentRes.setName(output.getFilename());
                contentRes.setLabel(output.getFilename());
                contentRes.setDescription(this.getOutputDescription());
                contentRes.setParentFolder(repositoryDestination.getFolderURI());
            }
            contentRes.setFileType(output.getFileType());
            contentRes.setDataContainer(output.getData());
            contentRes.setResources(childResources);
            if (this.executionContext.getAttributes() == null) {
                this.executionContext.setAttributes(new ArrayList());
            }
            this.executionContext.getAttributes().add("isOverwriting");
            repositoryService.saveResource(this.executionContext, (Resource)contentRes);
            output.setRepositoryPath(resURI);
        }
        finally {
            this.unlock(lock);
        }
    }

    protected String getOutputDescription() {
        return this.jobDetails.getContentRepositoryDestination().getOutputDescription();
    }

    protected RepositoryService getRepository() {
        RepositoryService repositoryService = (RepositoryService)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_REPOSITORY);
        return repositoryService;
    }

    protected void sendMailNotification(List reportOutputs) throws JobExecutionException {
        ReportJobMailNotification mailNotification = this.jobDetails.getMailNotification();
        if (mailNotification != null) {
            JavaMailSender mailSender = this.getMailSender();
            String fromAddress = this.getFromAddress();
            try {
                MimeMessage message = mailSender.createMimeMessage();
                MimeMessageHelper messageHelper = new MimeMessageHelper(message, true, this.getCharacterEncoding());
                messageHelper.setFrom(fromAddress);
                messageHelper.setSubject(mailNotification.getSubject());
                StringBuffer messageText = new StringBuffer();
                String text = mailNotification.getMessageText();
                if (text != null) {
                    messageText.append(text);
                }
                this.addMailRecipients(mailNotification, messageHelper);
                if (reportOutputs != null && !reportOutputs.isEmpty()) {
                    byte resultSendType = this.jobDetails.getMailNotification().getResultSendType();
                    if (resultSendType == 2) {
                        for (ReportOutput output : reportOutputs) {
                            this.attachOutput(messageHelper, output);
                        }
                    } else {
                        this.appendRepositoryLinks(messageText, reportOutputs);
                    }
                }
                if (this.hasExceptions()) {
                    for (ExceptionInfo exception : this.exceptions) {
                        messageText.append("\n");
                        messageText.append(exception.getMessage());
                        this.attachException(messageHelper, exception);
                    }
                }
                messageHelper.setText(messageText.toString());
                mailSender.send(message);
            }
            catch (MessagingException e) {
                log.error((Object)"Error while sending report job result mail", (Throwable)e);
                throw new JSExceptionWrapper((Exception)((Object)e));
            }
        }
    }

    protected void appendRepositoryLinks(StringBuffer notificationMessage, List reportOutputs) {
        if (reportOutputs != null && !reportOutputs.isEmpty()) {
            String preamble = this.getMessage("report.scheduling.notification.repository.links.preamble", null);
            notificationMessage.append(preamble);
            String linkDescription = this.getRepositoryLinkDescription();
            ContentResourceURIResolver contentResourceURIResolver = this.getContentResourceURIResolver();
            for (ReportOutput output : reportOutputs) {
                String resourcePath = output.getRepositoryPath();
                if (resourcePath == null) continue;
                String resourceURI = contentResourceURIResolver.resolveURI(resourcePath);
                String line = this.getMessage("report.scheduling.notification.repository.link.line", new Object[]{linkDescription, resourceURI});
                notificationMessage.append(line);
            }
        }
    }

    protected String getRepositoryLinkDescription() {
        String reportURI = this.jobDetails.getSource().getReportUnitURI();
        Resource report = this.getRepository().getResource(this.getExecutionContext(), reportURI, ReportUnit.class);
        return report.getLabel();
    }

    protected ContentResourceURIResolver getContentResourceURIResolver() {
        return (ContentResourceURIResolver)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_CONTENT_RESOURCE_URI_RESOLVER);
    }

    protected LockManager getLockManager() {
        return (LockManager)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_LOCK_MANAGER);
    }

    protected LockHandle lockOutputResource(String uri) {
        return this.getLockManager().lock(LOCK_NAME_CONTENT_RESOURCE, uri);
    }

    protected void unlock(LockHandle lock) {
        this.getLockManager().unlock(lock);
    }

    protected String getCharacterEncoding() {
        CharacterEncodingProvider encodingProvider = (CharacterEncodingProvider)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_ENCODING_PROVIDER);
        return encodingProvider.getCharacterEncoding();
    }

    protected void addMailRecipients(ReportJobMailNotification mailNotification, MimeMessageHelper messageHelper) throws MessagingException {
        List bccAddresses;
        List ccAddresses;
        List toAddresses = mailNotification.getToAddresses();
        if (toAddresses != null && !toAddresses.isEmpty()) {
            String[] addressArray = new String[toAddresses.size()];
            toAddresses.toArray(addressArray);
            messageHelper.setTo(addressArray);
        }
        if ((ccAddresses = mailNotification.getCcAddresses()) != null && !ccAddresses.isEmpty()) {
            String[] addressArray = new String[ccAddresses.size()];
            ccAddresses.toArray(addressArray);
            messageHelper.setCc(addressArray);
        }
        if ((bccAddresses = mailNotification.getBccAddresses()) != null && !bccAddresses.isEmpty()) {
            String[] addressArray = new String[bccAddresses.size()];
            bccAddresses.toArray(addressArray);
            messageHelper.setBcc(addressArray);
        }
    }

    protected void attachOutput(MimeMessageHelper messageHelper, ReportOutput output) throws MessagingException, JobExecutionException {
        DataContainer attachmentData;
        String attachmentName;
        if (output.getChildren().isEmpty()) {
            attachmentName = output.getFilename();
            attachmentData = output.getData();
        } else {
            attachmentData = this.createDataContainer();
            boolean close = true;
            ZipOutputStream zipOut = new ZipOutputStream(attachmentData.getOutputStream());
            try {
                zipOut.putNextEntry(new ZipEntry(output.getFilename()));
                DataContainerStreamUtil.pipeData((InputStream)output.getData().getInputStream(), (OutputStream)zipOut);
                zipOut.closeEntry();
                for (ReportOutput child : output.getChildren()) {
                    String childName = this.getChildrenFolderName(output.getFilename()) + '/' + child.getFilename();
                    zipOut.putNextEntry(new ZipEntry(childName));
                    DataContainerStreamUtil.pipeData((InputStream)child.getData().getInputStream(), (OutputStream)zipOut);
                    zipOut.closeEntry();
                }
                zipOut.finish();
                zipOut.flush();
                close = false;
                zipOut.close();
            }
            catch (IOException e) {
                throw new JSExceptionWrapper((Exception)e);
            }
            finally {
                if (close) {
                    try {
                        zipOut.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error closing stream", (Throwable)e);
                    }
                }
            }
            attachmentName = output.getFilename() + ".zip";
        }
        try {
            attachmentName = MimeUtility.encodeWord((String)attachmentName, (String)this.getCharacterEncoding(), null);
        }
        catch (UnsupportedEncodingException e) {
            throw new JSExceptionWrapper((Exception)e);
        }
        messageHelper.addAttachment(attachmentName, (InputStreamSource)new DataContainerResource(attachmentData));
    }

    protected void attachException(MimeMessageHelper messageHelper, ExceptionInfo exceptionInfo) throws MessagingException {
        Throwable exception = exceptionInfo.getException();
        if (exception == null) {
            return;
        }
        ByteArrayOutputStream bufOut = new ByteArrayOutputStream();
        PrintStream printOut = new PrintStream(bufOut);
        exception.printStackTrace(printOut);
        printOut.flush();
        String attachmentName = "exception_" + System.identityHashCode(exception) + ".txt";
        messageHelper.addAttachment(attachmentName, (InputStreamSource)new ByteArrayResource(bufOut.toByteArray()));
    }

    protected String getFromAddress() {
        String fromAddress = (String)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_MAIL_FROM_ADDRESS);
        return fromAddress;
    }

    protected JavaMailSender getMailSender() {
        JavaMailSender mailSender = (JavaMailSender)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_MAIL_SENDER);
        return mailSender;
    }

    protected Map getExportParametersMap() {
        return (Map)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_EXPORT_PARAMETRES_MAP);
    }

    protected Map getOutputFormatMap() {
        return (Map)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_OUTPUT_FORMAT_MAP);
    }

    protected Map getOutputKeyMapping() {
        return (Map)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_OUTPUT_KEY_MAPPING);
    }

    protected DataContainer createDataContainer() {
        DataContainerFactory factory = (DataContainerFactory)this.schedulerContext.get((Object)SCHEDULER_CONTEXT_KEY_DATA_CONTAINER_FACTORY);
        return factory.createDataContainer();
    }

    protected static class ExceptionInfo {
        private final Throwable exception;
        private final String message;

        public ExceptionInfo(String message, Throwable exception) {
            this.exception = exception;
            this.message = message == null ? exception.getMessage() : message;
        }

        public Throwable getException() {
            return this.exception;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

