/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.CompiledReportProvider;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.RepositoryContextManager;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryContext;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryUtil;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;

public class DefaultRepositoryContextManager
implements RepositoryContextManager {
    private RepositoryService repository;
    private CompiledReportProvider compiledReportProvider;

    public DefaultRepositoryContextManager() {
    }

    public DefaultRepositoryContextManager(RepositoryService repository, CompiledReportProvider compiledReportProvider) {
        this.repository = repository;
        this.compiledReportProvider = compiledReportProvider;
    }

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public CompiledReportProvider getCompiledReportProvider() {
        return this.compiledReportProvider;
    }

    public void setCompiledReportProvider(CompiledReportProvider compiledReportProvider) {
        this.compiledReportProvider = compiledReportProvider;
    }

    public void setRepositoryContext(ExecutionContext context, String reportUnitURI, ReportUnit inMemoryReportUnit) {
        RepositoryContext repositoryContext = this.createRepositoryContext(context, reportUnitURI, inMemoryReportUnit);
        RepositoryUtil.setThreadRepositoryContext(repositoryContext);
    }

    protected RepositoryContext createRepositoryContext(ExecutionContext context, String reportUnitURI, ReportUnit inMemoryReportUnit) {
        RepositoryContext repositoryContext = new RepositoryContext();
        repositoryContext.setRepository(this.repository);
        repositoryContext.setContextResourceURI(reportUnitURI);
        repositoryContext.setReportUnit(inMemoryReportUnit);
        repositoryContext.setExecutionContext(context);
        repositoryContext.setCompiledReportProvider(this.compiledReportProvider);
        return repositoryContext;
    }

    public void resetRepositoryContext() {
        RepositoryUtil.clearThreadRepositoryContext();
    }

    public String getRepositoryPathKey(String path) {
        return path;
    }

    public String getRepositoryUriForKey(String pathKey) {
        return pathKey;
    }
}

