/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.common.service.impl;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.engine.common.service.impl.ContentResourceURIResolver;
import com.jaspersoft.jasperserver.api.engine.common.service.impl.WebDeploymentInformation;
import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.beans.factory.InitializingBean;

public class DefaultContentResourceURIResolver
implements ContentResourceURIResolver,
InitializingBean {
    private WebDeploymentInformation deploymentInformation;
    private String contentControllerPath;
    private URI baseURI;

    public void afterPropertiesSet() throws Exception {
        this.baseURI = new URI(this.deploymentInformation.getDeploymentURI() + this.contentControllerPath);
    }

    public String resolveURI(String repositoryPath) {
        String uriPath = this.baseURI.getPath() + repositoryPath;
        try {
            URI uri = new URI(this.baseURI.getScheme(), this.baseURI.getUserInfo(), this.baseURI.getHost(), this.baseURI.getPort(), uriPath, this.baseURI.getQuery(), this.baseURI.getFragment());
            return uri.toASCIIString();
        }
        catch (URISyntaxException e) {
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    public WebDeploymentInformation getDeploymentInformation() {
        return this.deploymentInformation;
    }

    public void setDeploymentInformation(WebDeploymentInformation deploymentInformation) {
        this.deploymentInformation = deploymentInformation;
    }

    public String getContentControllerPath() {
        return this.contentControllerPath;
    }

    public void setContentControllerPath(String contentControllerPath) {
        this.contentControllerPath = contentControllerPath;
    }
}

