/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.repository.impl;

import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import com.jaspersoft.jasperserver.war.repository.RepositoryDataFilter;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;

public class RepositoryDataFilterImpl
implements RepositoryDataFilter {
    private List uriList;
    private UserAuthorityService userService;
    private String roleToShowFolders;

    public List getUriList() {
        return this.uriList;
    }

    public void setUriList(List uriList) {
        this.uriList = uriList;
    }

    public UserAuthorityService getUserService() {
        return this.userService;
    }

    public void setUserService(UserAuthorityService userService) {
        this.userService = userService;
    }

    public String getRoleToShowFolders() {
        return this.roleToShowFolders;
    }

    public void setRoleToShowFolders(String roleToShowFolders) {
        this.roleToShowFolders = roleToShowFolders;
    }

    public boolean filter(String uri) {
        if (this.uriList != null) {
            for (String uriReEx : this.uriList) {
                Matcher matcher = Pattern.compile(uriReEx, 2).matcher(uri);
                if (!matcher.matches()) continue;
                Authentication existingAuth = SecurityContextHolder.getContext().getAuthentication();
                String userName = existingAuth.getName();
                List userList = this.userService.getUsersInRole(null, this.roleToShowFolders);
                Iterator userIter = userList.iterator();
                while (userIter.hasNext()) {
                    String user = ((User)userIter.next()).getUsername();
                    if (!user.equalsIgnoreCase(userName)) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }
}

