/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.model.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.war.model.JSONObject;
import com.jaspersoft.jasperserver.war.model.TreeDataProvider;
import com.jaspersoft.jasperserver.war.model.TreeNode;
import com.jaspersoft.jasperserver.war.model.impl.TreeNodeImpl;
import java.util.List;

public abstract class BaseTreeDataProvider
implements TreeDataProvider {
    private RepositoryService repositoryService;

    protected JSONObject newExtra(String description, String subType, String creator) {
        return new Extra(description, subType, creator);
    }

    public List getChildren(ExecutionContext executionContext, String parentUri, int depth) {
        TreeNode node = this.getNode(executionContext, parentUri, depth + 1);
        return node.getChildren();
    }

    public TreeNode getNode(ExecutionContext executionContext, String uri, int depth) {
        TreeNode node = this.createRoot(executionContext);
        String[] pathParts = uri.split("/");
        StringBuffer curPath = new StringBuffer();
        if ("/".equals(uri)) {
            return this.cutNodeHierarchyToGivenDepth(node, depth);
        }
        block0: for (int i = 1; i < pathParts.length; ++i) {
            curPath.append("/").append(pathParts[i]);
            for (TreeNode ch : node.getChildren()) {
                if (!curPath.toString().equals(ch.getUriString())) continue;
                node = ch;
                continue block0;
            }
        }
        return this.cutNodeHierarchyToGivenDepth(node, depth);
    }

    protected abstract TreeNode createRoot(ExecutionContext var1);

    protected TreeNode cutNodeHierarchyToGivenDepth(TreeNode node, int depth) {
        if (node == null) {
            return null;
        }
        TreeNode retNode = node.clone(false);
        retNode.getChildren().clear();
        if (depth > 0 && node.getChildren() != null && node.getChildren().size() > 0) {
            for (TreeNode chNode : node.getChildren()) {
                retNode.getChildren().add(this.cutNodeHierarchyToGivenDepth(chNode, depth - 1));
            }
        }
        return retNode;
    }

    protected TreeNode getParentFolderNode(TreeNode parent, String uri) {
        String[] pathParts = uri.split("/");
        StringBuffer curPath = new StringBuffer();
        for (int i = 1; i < pathParts.length - 1; ++i) {
            boolean found = false;
            curPath.append("/").append(pathParts[i]);
            for (TreeNode ch : parent.getChildren()) {
                if (!curPath.toString().equals(ch.getUriString())) continue;
                parent = ch;
                found = true;
                break;
            }
            if (found) continue;
            Folder f = this.repositoryService.getFolder(null, curPath.toString());
            TreeNodeImpl n = new TreeNodeImpl((TreeDataProvider)this, f.getName(), f.getLabel(), f.getResourceType(), f.getURIString(), 1);
            parent.getChildren().add(n);
            parent = n;
        }
        return parent;
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    class Extra
    implements JSONObject {
        private String json;

        Extra(String description, String subType, String creator) {
            this.json = "{\"desc\":" + (description == null ? "null" : "\"" + description.replaceAll("\"", "\\\\\"") + "\"") + ",\"subType\":\"" + subType + "\",\"creator\":\"" + creator + "\"}";
        }

        public String toJSONString() {
            return this.json;
        }
    }
}

