/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.DataType;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.war.dto.RuntimeInputControlWrapper;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.apache.commons.collections.set.ListOrderedSet;

public class ReportParametersUtils {
    public static void setInputControlParameterValue(RuntimeInputControlWrapper wrapper, Object paramValue, RepositoryService repository) {
        wrapper.setErrorMessage(null);
        Object inputValue = ReportParametersUtils.toInputControlValue(wrapper, paramValue, repository);
        wrapper.setValue(inputValue);
    }

    public static Object toInputControlValue(RuntimeInputControlWrapper wrapper, Object paramValue, RepositoryService repository) {
        Object value;
        if (paramValue == null) {
            return null;
        }
        if (wrapper.isMulti()) {
            Set values = ReportParametersUtils.toMultiInputControlValue(paramValue);
            value = values;
        } else {
            DataType datatype = ReportParametersUtils.getDatatype(wrapper.getInputControl(), repository);
            if (datatype != null) {
                switch (datatype.getType()) {
                    case 2: {
                        value = ReportParametersUtils.toInputControlNumber(paramValue);
                        break;
                    }
                    case 1: {
                        value = paramValue.toString();
                        break;
                    }
                    case 3: 
                    case 4: {
                        value = ReportParametersUtils.toInputControlDate(paramValue);
                        break;
                    }
                    default: {
                        value = paramValue;
                        break;
                    }
                }
            } else {
                value = paramValue;
            }
        }
        return value;
    }

    public static Set toMultiInputControlValue(Object paramValue) {
        ListOrderedSet values = new ListOrderedSet();
        if (paramValue != null) {
            if (paramValue instanceof Collection) {
                values.addAll((Collection)paramValue);
            } else if (paramValue.getClass().isArray()) {
                int length = Array.getLength(paramValue);
                for (int idx = 0; idx < length; ++idx) {
                    Object val = Array.get(paramValue, idx);
                    values.add(val);
                }
            }
        }
        return values;
    }

    public static DataType getDatatype(InputControl control, RepositoryService repository) {
        ResourceReference dataTypeRef = control.getDataType();
        DataType dataType = dataTypeRef == null ? null : (dataTypeRef.isLocal() ? (DataType)dataTypeRef.getLocalResource() : (DataType)repository.getResource((ExecutionContext)new ExecutionContextImpl(), dataTypeRef.getReferenceURI()));
        return dataType;
    }

    public static Object toInputControlDate(Object paramValue) {
        if (!(paramValue instanceof Date)) {
            throw new JSException("exception.report.unrecognized.date.type", new Object[]{paramValue.getClass().getName()});
        }
        Date dateValue = (Date)paramValue;
        Date inputValue = new Date(dateValue.getTime());
        return inputValue;
    }

    public static BigDecimal toInputControlNumber(Object paramValue) {
        BigDecimal inputValue;
        if (paramValue instanceof Byte || paramValue instanceof Short || paramValue instanceof Integer || paramValue instanceof Long) {
            inputValue = BigDecimal.valueOf(((Number)paramValue).longValue());
        } else if (paramValue instanceof Float || paramValue instanceof Double) {
            inputValue = BigDecimal.valueOf(((Number)paramValue).doubleValue());
        } else if (paramValue instanceof BigDecimal) {
            inputValue = (BigDecimal)paramValue;
        } else if (paramValue instanceof BigInteger) {
            inputValue = new BigDecimal((BigInteger)paramValue);
        } else if (paramValue instanceof String) {
            inputValue = new BigDecimal((String)paramValue);
        } else {
            throw new JSException("exception.report.unrecognized.number.type", new Object[]{paramValue.getClass().getName()});
        }
        return inputValue;
    }
}

