/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.ws.axis2.authority;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.logging.audit.context.AuditContext;
import com.jaspersoft.jasperserver.api.logging.audit.domain.AuditEvent;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.service.ObjectPermissionService;
import com.jaspersoft.jasperserver.ws.authority.WSObjectPermission;
import com.jaspersoft.jasperserver.ws.axis2.authority.PermissionsManagementService;
import com.jaspersoft.jasperserver.ws.axis2.authority.PermissionsTranslator;
import java.util.List;
import java.util.Locale;
import org.apache.axis.AxisFault;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;

public class PermissionsManagementServiceImpl
implements PermissionsManagementService {
    protected ObjectPermissionService objectPermissionService;
    protected RepositoryService repositoryService;
    protected AuditContext auditContext;

    protected void createPermissionAuditEvent(final String auditEventType) {
        this.auditContext.doInAuditContext(new AuditContext.AuditContextCallback(){

            public void execute() {
                PermissionsManagementServiceImpl.this.auditContext.createAuditEvent(auditEventType);
            }
        });
    }

    protected void closePermissionAuditEvent(String auditEventType) {
        this.auditContext.doInAuditContext(auditEventType, new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                PermissionsManagementServiceImpl.this.auditContext.closeAuditEvent(auditEvent);
            }
        });
    }

    public WSObjectPermission[] getPermissionsForObject(String targetURI) throws AxisFault {
        if (!this.objectPermissionService.isObjectAdministrable(this.makeExecutionContext(), (Object)targetURI)) {
            throw new AxisFault("Access is denied");
        }
        Resource res = this.repositoryService.getResource(this.makeExecutionContext(), targetURI);
        if (res == null && (res = this.repositoryService.getFolder(this.makeExecutionContext(), targetURI)) == null) {
            throw new AxisFault("There is no resource or folder for target URI \"" + targetURI + "\"");
        }
        List objectPermissionsForObject = this.objectPermissionService.getObjectPermissionsForObject(this.makeExecutionContext(), (Object)res);
        return PermissionsTranslator.toWSTenantArray(objectPermissionsForObject);
    }

    public WSObjectPermission putPermission(WSObjectPermission objectPermission) throws AxisFault {
        this.changePermissionConsistencyCheck(objectPermission);
        ObjectPermission op = this.objectPermissionService.newObjectPermission(this.makeExecutionContext());
        PermissionsTranslator.populateObjectPermission(objectPermission, op);
        ObjectPermission existingObjectPermission = this.objectPermissionService.getObjectPermission(this.makeExecutionContext(), op);
        String auditEventType = existingObjectPermission == null ? "createPermission" : "updatePermission";
        this.createPermissionAuditEvent(auditEventType);
        this.objectPermissionService.putObjectPermission(this.makeExecutionContext(), op);
        this.closePermissionAuditEvent(auditEventType);
        return PermissionsTranslator.toWSObjectPermission(this.objectPermissionService.getObjectPermission(this.makeExecutionContext(), op));
    }

    public void deletePermission(WSObjectPermission objectPermission) throws AxisFault {
        this.changePermissionConsistencyCheck(objectPermission);
        ObjectPermission op = this.objectPermissionService.newObjectPermission(this.makeExecutionContext());
        PermissionsTranslator.populateObjectPermission(objectPermission, op);
        this.createPermissionAuditEvent("deletePermission");
        this.objectPermissionService.deleteObjectPermission(this.makeExecutionContext(), op);
        this.closePermissionAuditEvent("deletePermission");
    }

    protected void changePermissionConsistencyCheck(WSObjectPermission objectPermission) throws AxisFault {
        if (StringUtils.isBlank((String)objectPermission.getUri())) {
            throw new AxisFault("URI is blank");
        }
        if (objectPermission.getPermissionRecipient() == null) {
            throw new AxisFault("Permission recipient is null");
        }
        if (this.isPermissionForRootRessource(objectPermission)) {
            throw new AxisFault("Setting/changing/deleting permissions for root URI is forbidden");
        }
    }

    protected boolean isPermissionForRootRessource(WSObjectPermission objectPermission) {
        return "repo:/".equals(objectPermission.getUri()) || "/".equals(objectPermission.getUri());
    }

    public void setObjectPermissionService(ObjectPermissionService objectPermissionService) {
        this.objectPermissionService = objectPermissionService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void setAuditContext(AuditContext auditContext) {
        this.auditContext = auditContext;
    }

    protected ExecutionContext makeExecutionContext() {
        ExecutionContextImpl executionContext = new ExecutionContextImpl();
        executionContext.setLocale(this.getLocale());
        return executionContext;
    }

    protected Locale getLocale() {
        return LocaleContextHolder.getLocale();
    }
}

