/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng.dialect;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.JDBCBinderException;
import org.hibernate.cfg.reveng.dialect.MetaDataDialect;
import org.hibernate.cfg.reveng.dialect.ResultSetIterator;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.mapping.Table;

public class JDBCMetaDataDialect
implements MetaDataDialect {
    private static final Log log = LogFactory.getLog((Class)JDBCMetaDataDialect.class);
    private SQLExceptionConverter sec;
    private ConnectionProvider provider;
    private Connection connection;
    private DatabaseMetaData metaData;

    public void configure(ConnectionProvider provider, SQLExceptionConverter sec) {
        this.provider = provider;
        this.sec = sec;
    }

    public void close() {
        this.metaData = null;
        if (this.connection != null) {
            try {
                this.provider.closeConnection(this.connection);
            }
            catch (SQLException e) {
                this.sec.convert(e, "Problem while closing connection", null);
            }
        }
        this.provider = null;
        this.sec = null;
    }

    protected DatabaseMetaData getMetaData() throws JDBCBinderException {
        if (this.metaData == null) {
            try {
                this.metaData = this.getConnection().getMetaData();
            }
            catch (SQLException e) {
                throw this.sec.convert(e, "Getting database metadata", null);
            }
        }
        return this.metaData;
    }

    public Iterator getTables(final String catalog, final String schema, String table) {
        try {
            log.debug((Object)("getTables(" + catalog + "." + schema + "." + table + ")"));
            ResultSet tableRs = this.getMetaData().getTables(catalog, schema, table, new String[]{"TABLE", "VIEW"});
            return new ResultSetIterator(tableRs, this.sec){
                Map element;
                {
                    super(x0, x1);
                    this.element = new HashMap();
                }

                protected Object convertRow(ResultSet tableRs) throws SQLException {
                    this.element.clear();
                    JDBCMetaDataDialect.this.putTablePart(this.element, tableRs);
                    this.element.put("TABLE_TYPE", tableRs.getString("TABLE_TYPE"));
                    this.element.put("REMARKS", tableRs.getString("REMARKS"));
                    return this.element;
                }

                protected Throwable handleSQLException(SQLException e) {
                    String databaseStructure = JDBCMetaDataDialect.this.getDatabaseStructure(catalog, schema);
                    throw JDBCMetaDataDialect.this.sec.convert(e, "Could not get list of tables from database. Probably a JDBC driver problem. " + databaseStructure, null);
                }
            };
        }
        catch (SQLException e) {
            String databaseStructure = this.getDatabaseStructure(catalog, schema);
            throw this.sec.convert(e, "Could not get list of tables from database. Probably a JDBC driver problem. " + databaseStructure, null);
        }
    }

    private void dumpHeader(ResultSet columnRs) throws SQLException {
        ResultSetMetaData md2 = columnRs.getMetaData();
        int columnCount = md2.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            System.out.print(md2.getColumnName(i) + "|");
        }
        System.out.println();
    }

    private void dumpRow(ResultSet columnRs) throws SQLException {
        ResultSetMetaData md2 = columnRs.getMetaData();
        int columnCount = md2.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            System.out.print(columnRs.getObject(i) + "|");
        }
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDatabaseStructure(String catalog, String schema) {
        ResultSet schemaRs = null;
        ResultSet catalogRs = null;
        String nl = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer(nl);
        sb.append("Configured schema:").append(schema).append(nl);
        sb.append("Configured catalog:").append(catalog).append(nl);
        try {
            schemaRs = this.getMetaData().getSchemas();
            sb.append("Available schemas:").append(nl);
            while (schemaRs.next()) {
                sb.append("  ").append(schemaRs.getString("TABLE_SCHEM")).append(nl);
            }
        }
        catch (SQLException e2) {
            log.warn((Object)"Could not get schemas", (Throwable)e2);
            sb.append("  <SQLException while getting schemas>").append(nl);
        }
        finally {
            try {
                schemaRs.close();
            }
            catch (Exception ignore) {}
        }
        try {
            catalogRs = this.getMetaData().getCatalogs();
            sb.append("Available catalogs:").append(nl);
            while (catalogRs.next()) {
                sb.append("  ").append(catalogRs.getString("TABLE_CAT")).append(nl);
            }
        }
        catch (SQLException e2) {
            log.warn((Object)"Could not get catalogs", (Throwable)e2);
            sb.append("  <SQLException while getting catalogs>").append(nl);
        }
        finally {
            try {
                catalogRs.close();
            }
            catch (Exception ignore) {}
        }
        return sb.toString();
    }

    public void close(Iterator iterator) {
        if (iterator instanceof ResultSetIterator) {
            ((ResultSetIterator)iterator).close();
        }
    }

    public Iterator getIndexInfo(final String catalog, final String schema, final String table) {
        try {
            log.debug((Object)("getIndexInfo(" + catalog + "." + schema + "." + table + ")"));
            ResultSet tableRs = this.getMetaData().getIndexInfo(catalog, schema, table, false, true);
            return new ResultSetIterator(tableRs, this.sec){
                Map element;
                {
                    super(x0, x1);
                    this.element = new HashMap();
                }

                protected Object convertRow(ResultSet rs) throws SQLException {
                    this.element.clear();
                    JDBCMetaDataDialect.this.putTablePart(this.element, rs);
                    this.element.put("INDEX_NAME", rs.getString("INDEX_NAME"));
                    this.element.put("COLUMN_NAME", rs.getString("COLUMN_NAME"));
                    this.element.put("NON_UNIQUE", rs.getBoolean("NON_UNIQUE"));
                    this.element.put("TYPE", new Short(rs.getShort("TYPE")));
                    return this.element;
                }

                protected Throwable handleSQLException(SQLException e) {
                    throw JDBCMetaDataDialect.this.sec.convert(e, "Exception while getting index info for " + Table.qualify((String)catalog, (String)schema, (String)table), null);
                }
            };
        }
        catch (SQLException e) {
            throw this.sec.convert(e, "Exception while getting index info for " + Table.qualify((String)catalog, (String)schema, (String)table), null);
        }
    }

    private void putTablePart(Map element, ResultSet tableRs) throws SQLException {
        element.put("TABLE_NAME", tableRs.getString("TABLE_NAME"));
        element.put("TABLE_SCHEM", tableRs.getString("TABLE_SCHEM"));
        element.put("TABLE_CAT", tableRs.getString("TABLE_CAT"));
    }

    public Iterator getColumns(final String catalog, final String schema, final String table, String column) {
        try {
            log.debug((Object)("getColumns(" + catalog + "." + schema + "." + table + "." + column + ")"));
            ResultSet tableRs = this.getMetaData().getColumns(catalog, schema, table, column);
            return new ResultSetIterator(tableRs, this.sec){
                Map element;
                {
                    super(x0, x1);
                    this.element = new HashMap();
                }

                protected Object convertRow(ResultSet rs) throws SQLException {
                    this.element.clear();
                    JDBCMetaDataDialect.this.putTablePart(this.element, rs);
                    this.element.put("DATA_TYPE", new Integer(rs.getInt("DATA_TYPE")));
                    this.element.put("TYPE_NAME", rs.getString("TYPE_NAME"));
                    this.element.put("COLUMN_NAME", rs.getString("COLUMN_NAME"));
                    this.element.put("NULLABLE", new Integer(rs.getInt("NULLABLE")));
                    this.element.put("COLUMN_SIZE", new Integer(rs.getInt("COLUMN_SIZE")));
                    this.element.put("DECIMAL_DIGITS", new Integer(rs.getInt("DECIMAL_DIGITS")));
                    this.element.put("REMARKS", rs.getString("REMARKS"));
                    return this.element;
                }

                protected Throwable handleSQLException(SQLException e) {
                    throw JDBCMetaDataDialect.this.sec.convert(e, "Error while reading column meta data for " + Table.qualify((String)catalog, (String)schema, (String)table), null);
                }
            };
        }
        catch (SQLException e) {
            throw this.sec.convert(e, "Error while reading column meta data for " + Table.qualify((String)catalog, (String)schema, (String)table), null);
        }
    }

    public Iterator getPrimaryKeys(final String catalog, final String schema, final String table) {
        try {
            log.debug((Object)("getPrimaryKeys(" + catalog + "." + schema + "." + table + ")"));
            ResultSet tableRs = this.getMetaData().getPrimaryKeys(catalog, schema, table);
            return new ResultSetIterator(tableRs, this.sec){
                Map element;
                {
                    super(x0, x1);
                    this.element = new HashMap();
                }

                protected Object convertRow(ResultSet rs) throws SQLException {
                    this.element.clear();
                    JDBCMetaDataDialect.this.putTablePart(this.element, rs);
                    this.element.put("COLUMN_NAME", rs.getString("COLUMN_NAME"));
                    this.element.put("KEY_SEQ", new Short(rs.getShort("KEY_SEQ")));
                    this.element.put("PK_NAME", rs.getString("PK_NAME"));
                    return this.element;
                }

                protected Throwable handleSQLException(SQLException e) {
                    throw JDBCMetaDataDialect.this.sec.convert(e, "Error while reading primary key meta data for " + Table.qualify((String)catalog, (String)schema, (String)table), null);
                }
            };
        }
        catch (SQLException e) {
            throw this.sec.convert(e, "Error while reading primary key meta data for " + Table.qualify((String)catalog, (String)schema, (String)table), null);
        }
    }

    public Iterator getExportedKeys(final String catalog, final String schema, final String table) {
        try {
            log.debug((Object)("getExportedKeys(" + catalog + "." + schema + "." + table + ")"));
            ResultSet tableRs = this.getMetaData().getExportedKeys(catalog, schema, table);
            return new ResultSetIterator(tableRs, this.sec){
                Map element;
                {
                    super(x0, x1);
                    this.element = new HashMap();
                }

                protected Object convertRow(ResultSet rs) throws SQLException {
                    this.element.clear();
                    this.element.put("PKTABLE_NAME", rs.getString("PKTABLE_NAME"));
                    this.element.put("PKTABLE_SCHEM", rs.getString("PKTABLE_SCHEM"));
                    this.element.put("PKTABLE_CAT", rs.getString("PKTABLE_CAT"));
                    this.element.put("FKTABLE_CAT", rs.getString("FKTABLE_CAT"));
                    this.element.put("FKTABLE_SCHEM", rs.getString("FKTABLE_SCHEM"));
                    this.element.put("FKTABLE_NAME", rs.getString("FKTABLE_NAME"));
                    this.element.put("FKCOLUMN_NAME", rs.getString("FKCOLUMN_NAME"));
                    this.element.put("PKCOLUMN_NAME", rs.getString("PKCOLUMN_NAME"));
                    this.element.put("FK_NAME", rs.getString("FK_NAME"));
                    this.element.put("KEY_SEQ", new Short(rs.getShort("KEY_SEQ")));
                    return this.element;
                }

                protected Throwable handleSQLException(SQLException e) {
                    throw JDBCMetaDataDialect.this.sec.convert(e, "Error while reading exported keys meta data for " + Table.qualify((String)catalog, (String)schema, (String)table), null);
                }
            };
        }
        catch (SQLException e) {
            throw this.sec.convert(e, "Error while reading exported keys meta data for " + Table.qualify((String)catalog, (String)schema, (String)table), null);
        }
    }

    protected Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.connection = this.provider.getConnection();
        }
        return this.connection;
    }

    public boolean needQuote(String name) {
        if (name.indexOf(45) > 0) {
            return true;
        }
        return name.indexOf(32) > 0;
    }
}

