/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import java.beans.Introspector;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.reveng.JDBCToHibernateTypeHelper;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategyUtil;
import org.hibernate.cfg.reveng.TableIdentifier;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.mapping.Column;
import org.hibernate.util.StringHelper;

public class DefaultReverseEngineeringStrategy
implements ReverseEngineeringStrategy {
    Log log = LogFactory.getLog((Class)DefaultReverseEngineeringStrategy.class);
    String packageName = "";
    private static Set AUTO_OPTIMISTICLOCK_COLUMNS = new HashSet();

    public String columnToPropertyName(TableIdentifier table, String columnName) {
        String decapitalize = Introspector.decapitalize(this.toUpperCamelCase(columnName));
        return this.keywordCheck(decapitalize);
    }

    private String keywordCheck(String possibleKeyword) {
        if (ReverseEngineeringStrategyUtil.isReservedJavaKeyword(possibleKeyword)) {
            possibleKeyword = possibleKeyword + "_";
        }
        return possibleKeyword;
    }

    protected String toUpperCamelCase(String s) {
        return ReverseEngineeringStrategyUtil.toUpperCamelCase(s);
    }

    public String foreignKeyToCollectionName(String keyname, TableIdentifier fromTable, List fromColumns, TableIdentifier referencedTable, List referencedColumns, boolean uniqueReference) {
        String propertyName = Introspector.decapitalize(StringHelper.unqualify((String)this.tableToClassName(fromTable)));
        propertyName = this.pluralize(propertyName);
        if (!uniqueReference) {
            if (fromColumns != null && fromColumns.size() == 1) {
                String columnName = ((Column)fromColumns.get(0)).getName();
                propertyName = propertyName + "For" + this.toUpperCamelCase(columnName);
            } else {
                propertyName = propertyName + "For" + this.toUpperCamelCase(keyname);
            }
        }
        return propertyName;
    }

    protected String pluralize(String singular) {
        return ReverseEngineeringStrategyUtil.simplePluralize(singular);
    }

    public String foreignKeyToEntityName(String keyname, TableIdentifier fromTable, List fromColumnNames, TableIdentifier referencedTable, List referencedColumnNames, boolean uniqueReference) {
        String propertyName = Introspector.decapitalize(StringHelper.unqualify((String)this.tableToClassName(referencedTable)));
        if (!uniqueReference) {
            if (fromColumnNames != null && fromColumnNames.size() == 1) {
                String columnName = ((Column)fromColumnNames.get(0)).getName();
                propertyName = propertyName + "By" + this.toUpperCamelCase(columnName);
            } else {
                propertyName = propertyName + "By" + this.toUpperCamelCase(keyname);
            }
        }
        return propertyName;
    }

    public void setPackageName(String pkg) {
        if (pkg == null) {
            this.packageName = "";
        }
        this.packageName = pkg.trim();
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String columnToHibernateTypeName(TableIdentifier table, String columnName, int sqlType, int length, int precision, int scale, boolean nullable) {
        String preferredHibernateType = JDBCToHibernateTypeHelper.getPreferredHibernateType(sqlType, length, precision, scale, nullable);
        if (preferredHibernateType == null) {
            this.log.debug((Object)("No preferred hibernate type found for " + table.toString() + " column: " + columnName + " falling back to 'serializable'"));
            return "serializable";
        }
        return preferredHibernateType;
    }

    public boolean excludeTable(TableIdentifier ti) {
        return ti.getName().startsWith("BIN$");
    }

    public String tableToClassName(TableIdentifier tableIdentifier) {
        String pkgName = this.packageName == null ? "" : this.packageName;
        String className = this.toUpperCamelCase(tableIdentifier.getName());
        if (pkgName.length() > 0) {
            return StringHelper.qualify((String)pkgName, (String)className);
        }
        return className;
    }

    public List getForeignKeys(TableIdentifier referencedTable) {
        return Collections.EMPTY_LIST;
    }

    public String getTableIdentifierStrategyName(TableIdentifier identifier) {
        return "assigned";
    }

    public Properties getTableIdentifierProperties(TableIdentifier identifier) {
        return null;
    }

    public List getPrimaryKeyColumnNames(TableIdentifier identifier) {
        return null;
    }

    public String classNameToCompositeIdName(String className) {
        return className + "Id";
    }

    public void configure(ConnectionProvider provider, SQLExceptionConverter sec) {
    }

    public void close() {
    }

    public String getOptimisticLockColumnName(TableIdentifier identifier) {
        return null;
    }

    public Boolean useColumnForOptimisticLock(TableIdentifier identifier, String column) {
        return AUTO_OPTIMISTICLOCK_COLUMNS.contains(column.toLowerCase()) ? Boolean.TRUE : Boolean.FALSE;
    }

    static {
        AUTO_OPTIMISTICLOCK_COLUMNS.add("version");
        AUTO_OPTIMISTICLOCK_COLUMNS.add("timestamp");
    }
}

