/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.search.factory.impl;

import com.jaspersoft.jasperserver.search.common.RepositorySearchConfiguration;
import com.jaspersoft.jasperserver.search.common.SearchMode;
import com.jaspersoft.jasperserver.search.factory.RepositorySearchModeFactory;
import com.jaspersoft.jasperserver.search.state.InitialStateResolver;
import com.jaspersoft.jasperserver.search.util.JSONConverter;
import java.util.HashMap;
import java.util.Map;

public class RepositorySearchModeFactoryImpl
implements RepositorySearchModeFactory {
    private Map<SearchMode, RepositorySearchConfiguration> repositorySearchConfigurationMap = new HashMap<SearchMode, RepositorySearchConfiguration>(SearchMode.values().length);
    private Map<SearchMode, JSONConverter> jsonConverterMap = new HashMap<SearchMode, JSONConverter>(SearchMode.values().length);
    private Map<SearchMode, InitialStateResolver> initialStateResolverMap = new HashMap<SearchMode, InitialStateResolver>(SearchMode.values().length);

    public void setSearchModeConfiguration(RepositorySearchConfiguration configuration) {
        this.repositorySearchConfigurationMap.put(SearchMode.SEARCH, configuration);
    }

    public void setBrowseModeConfiguration(RepositorySearchConfiguration configuration) {
        this.repositorySearchConfigurationMap.put(SearchMode.BROWSE, configuration);
    }

    public void setSearchModeConverter(JSONConverter converter) {
        this.jsonConverterMap.put(SearchMode.SEARCH, converter);
    }

    public void setBrowseModeConverter(JSONConverter converter) {
        this.jsonConverterMap.put(SearchMode.BROWSE, converter);
    }

    public void setSearchInitialStateResolver(InitialStateResolver initialStateResolver) {
        this.initialStateResolverMap.put(SearchMode.SEARCH, initialStateResolver);
    }

    public void setBrowseInitialStateResolver(InitialStateResolver initialStateResolver) {
        this.initialStateResolverMap.put(SearchMode.BROWSE, initialStateResolver);
    }

    public RepositorySearchConfiguration getConfiguration(SearchMode mode) {
        return this.repositorySearchConfigurationMap.get((Object)mode);
    }

    public JSONConverter getConverter(SearchMode mode) {
        return this.jsonConverterMap.get((Object)mode);
    }

    public InitialStateResolver getInitialStateResolver(SearchMode mode) {
        return this.initialStateResolverMap.get((Object)mode);
    }
}

