/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.search.action;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.common.service.SecurityContextProvider;
import com.jaspersoft.jasperserver.api.engine.common.service.impl.NavigationActionModelSupport;
import com.jaspersoft.jasperserver.api.search.SearchCriteriaFactory;
import com.jaspersoft.jasperserver.api.search.SearchFilter;
import com.jaspersoft.jasperserver.api.search.SearchSorter;
import com.jaspersoft.jasperserver.search.action.BaseSearchAction;
import com.jaspersoft.jasperserver.search.action.SearchHolder;
import com.jaspersoft.jasperserver.search.common.CustomFilter;
import com.jaspersoft.jasperserver.search.common.CustomSorter;
import com.jaspersoft.jasperserver.search.common.Option;
import com.jaspersoft.jasperserver.search.common.RepositorySearchConfiguration;
import com.jaspersoft.jasperserver.search.common.ResourceDetails;
import com.jaspersoft.jasperserver.search.common.SearchAttributes;
import com.jaspersoft.jasperserver.search.common.SearchMode;
import com.jaspersoft.jasperserver.search.model.permission.Permission;
import com.jaspersoft.jasperserver.search.service.RepositorySearchService;
import com.jaspersoft.jasperserver.search.state.State;
import com.jaspersoft.jasperserver.search.strategy.ResourceLoadStrategy;
import com.jaspersoft.jasperserver.search.util.JSONConverter;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.webflow.core.collection.SharedAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositorySearchAction
extends BaseSearchAction {
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String ATTRIBUTE_ORGANIZATION_ID = "organizationId";
    private static final String ATTRIBUTE_PUBLIC_FOLDER_URI = "publicFolderUri";
    private static final String ATTRIBUTE_TEMP_FOLDER_URI = "tempFolderUri";
    private static final String ATTRIBUTE_ROOT_FOLDER_URI = "rootFolderUri";
    private static final String ATTRIBUTE_ORGANIZATIONS_FOLDER_URI = "organizationsFolderUri";
    private static final String ATTRIBUTE_FOLDER_SEPARATOR = "folderSeparator";
    private static final String ATTRIBUTE_AJAX_RESPONSE_MODEL = "ajaxResponseModel";
    private static final String ATTRIBUTE_STATE = "state";
    private static final String ATTRIBUTE_CONFIGURATION = "configuration";
    private static final String ATTRIBUTE_PERMISSIONS = "permissions";
    private static final String ATTRIBUTE_JSON_CONFIGURATION = "jsonConfiguration";
    private static final String ATTRIBUTE_MODE = "mode";
    private static final String ATTRIBUTE_SYSTEM_CONFIRM = "systemConfirm";
    private static final String ATTRIBUTE_IS_ANALYSIS_FEATURE_ENABLED = "isAnalysisFeatureEnabled";
    private static final String ATTRIBUTE_IS_DASHBOARD_FEATURE_ENABLED = "isDashboardFeatureEnabled";
    private static final String ATTRIBUTE_IS_ADHOC_FEATURE_ENABLED = "isAdHocFeatureEnabled";
    private static final String ATTRIBUTE_REPOSITORY_SYSTEM_CONFIRM = "repositorySystemConfirm";
    private static final String PARAMETER_ROLLBACK_POSITION = "position";
    private static final String PARAMETER_SORT_BY = "sortBy";
    private static final String PARAMETER_TEXT = "text";
    private static final String PARAMETER_FILTER_ID = "filterId";
    private static final String PARAMETER_FILTER_OPTION = "filterOption";
    private static final String PARAMETER_FOLDER_URI = "folderUri";
    private static final String PARAMETER_RESOURCE_TYPE = "resourceType";
    private static final String PARAMETER_RESOURCE_URI = "resourceUri";
    private static final String PARAMETER_SEARCH_TEXT = "searchText";
    private SecurityContextProvider securityContextProvider;
    private ConfigurationBean configuration;
    private RepositorySearchService repositorySearchService;
    private SearchCriteriaFactory searchCriteriaFactory;
    private ResourceLoadStrategy resourceLoadStrategy;

    public void setSecurityContextProvider(SecurityContextProvider securityContextProvider) {
        this.securityContextProvider = securityContextProvider;
    }

    public void setConfiguration(ConfigurationBean configuration) {
        this.configuration = configuration;
    }

    public void setRepositorySearchService(RepositorySearchService repositorySearchService) {
        this.repositorySearchService = repositorySearchService;
    }

    public void setSearchCriteriaFactory(SearchCriteriaFactory searchCriteriaFactory) {
        this.searchCriteriaFactory = searchCriteriaFactory;
    }

    public void setResourceLoadStrategy(ResourceLoadStrategy resourceLoadStrategy) {
        this.resourceLoadStrategy = resourceLoadStrategy;
    }

    public Event init(RequestContext context) throws JSONException {
        this.initSearchHolder(context);
        this.initState(context);
        SearchMode mode = this.getMode(context);
        context.getRequestScope().put(ATTRIBUTE_ORGANIZATION_ID, (Object)this.securityContextProvider.getContextUser().getTenantId());
        context.getRequestScope().put(ATTRIBUTE_PUBLIC_FOLDER_URI, (Object)this.configuration.getPublicFolderUri());
        context.getRequestScope().put(ATTRIBUTE_TEMP_FOLDER_URI, (Object)this.configuration.getTempFolderUri());
        context.getRequestScope().put(ATTRIBUTE_ROOT_FOLDER_URI, (Object)"/");
        context.getRequestScope().put(ATTRIBUTE_ORGANIZATIONS_FOLDER_URI, (Object)this.configuration.getOrganizationsFolderUri());
        context.getRequestScope().put(ATTRIBUTE_FOLDER_SEPARATOR, (Object)"/");
        context.getRequestScope().put(ATTRIBUTE_STATE, (Object)this.getSearchHolder(context).getState(mode).toJson());
        context.getRequestScope().put(ATTRIBUTE_CONFIGURATION, (Object)this.getConfiguration(context));
        context.getRequestScope().put(ATTRIBUTE_PERMISSIONS, (Object)Permission.values());
        context.getRequestScope().put(ATTRIBUTE_JSON_CONFIGURATION, (Object)this.getConverter(context).createJSONConfiguration());
        context.getRequestScope().put(ATTRIBUTE_MODE, (Object)mode.toString());
        context.getRequestScope().put(ATTRIBUTE_IS_ANALYSIS_FEATURE_ENABLED, (Object)this.isAnalysisFeatureSupported());
        context.getRequestScope().put(ATTRIBUTE_IS_DASHBOARD_FEATURE_ENABLED, (Object)this.isFeatureSupported("DB"));
        context.getRequestScope().put(ATTRIBUTE_IS_ADHOC_FEATURE_ENABLED, (Object)this.isFeatureSupported("AHD"));
        SharedAttributeMap sessionMap = context.getExternalContext().getSessionMap();
        if (sessionMap.contains(ATTRIBUTE_REPOSITORY_SYSTEM_CONFIRM)) {
            context.getRequestScope().put(ATTRIBUTE_SYSTEM_CONFIRM, sessionMap.get(ATTRIBUTE_REPOSITORY_SYSTEM_CONFIRM));
            sessionMap.remove(ATTRIBUTE_REPOSITORY_SYSTEM_CONFIRM);
        }
        return this.success();
    }

    private void initState(RequestContext context) {
        String sortBy;
        String filterOption;
        String filterId;
        SearchHolder searchHolder = this.getSearchHolder(context);
        SearchMode mode = this.getMode(context);
        searchHolder.setLastMode(mode);
        String searchText = this.getDecodedRequestParameter(context, PARAMETER_SEARCH_TEXT);
        boolean isNewSearch = searchText != null;
        State state = searchHolder.getState(this.getMode(context));
        if (state == null || isNewSearch) {
            state = this.getInitialStateResolver(context).getInitialState(this.getConfiguration(context));
            if (isNewSearch) {
                state.updateText(searchText);
            }
            searchHolder.putState(mode, state);
        }
        if (this.isFilterValid(context, filterId = this.getParameter(context, PARAMETER_FILTER_ID), filterOption = this.getParameter(context, PARAMETER_FILTER_OPTION))) {
            state.updateFilter(filterId, filterOption, this.isDefaultFilterOption(context, filterId, filterOption));
        }
        if (this.isSorterValid(context, sortBy = this.getParameter(context, PARAMETER_SORT_BY))) {
            this.getSearchHolder(context).getState(this.getMode(context)).updateSorter(sortBy);
        }
    }

    public Event isServerAvailable(RequestContext context) throws Exception {
        context.getRequestScope().put(ATTRIBUTE_AJAX_RESPONSE_MODEL, (Object)this.getConverter(context).createOKJSONResponse("Yes"));
        return this.success();
    }

    public Event search(RequestContext context) throws JSONException {
        String text = this.getParameter(context, PARAMETER_TEXT);
        this.getSearchHolder(context).getState(this.getMode(context)).updateText(text);
        return this.success();
    }

    public Event sort(RequestContext context) throws JSONException {
        String sortBy = this.getParameter(context, PARAMETER_SORT_BY);
        if (!this.isSorterValid(context, sortBy)) {
            return this.error();
        }
        this.getSearchHolder(context).getState(this.getMode(context)).updateSorter(sortBy);
        return this.success();
    }

    public Event filter(RequestContext context) throws JSONException {
        String filterOption;
        String filterId = this.getParameter(context, PARAMETER_FILTER_ID);
        if (!this.isFilterValid(context, filterId, filterOption = this.getParameter(context, PARAMETER_FILTER_OPTION))) {
            return this.error();
        }
        this.getSearchHolder(context).getState(this.getMode(context)).updateFilter(filterId, filterOption, this.isDefaultFilterOption(context, filterId, filterOption));
        return this.success();
    }

    public Event browse(RequestContext context) throws JSONException {
        String folderUri = this.getParameter(context, PARAMETER_FOLDER_URI);
        this.getSearchHolder(context).getState(this.getMode(context)).updateFolder(folderUri);
        return this.success();
    }

    public Event rollback(RequestContext context) {
        int rollbackPosition = (Integer)this.getParameter(context, PARAMETER_ROLLBACK_POSITION, Integer.class);
        this.getSearchHolder(context).getState(this.getMode(context)).rollback(rollbackPosition, this.getConfiguration(context));
        return this.success();
    }

    public Event next(RequestContext context) {
        SearchMode mode = this.getMode(context);
        State state = this.getSearchHolder(context).getState(mode);
        if (state.getResultIndex() == 0) {
            int resultsCount = this.repositorySearchService.getResultsCount(this.exContext(context), this.searchCriteriaFactory, this.createAllFiltersList(context), this.getSorter(context, state.getSortBy()));
            state.updateResultState(0, resultsCount);
        }
        List<Object> results = state.getResultIndex() >= state.getResultsCount() ? Collections.emptyList() : this.getResults(context, state);
        try {
            JSONConverter converter = this.getConverter(context);
            JSONObject jsonResults = converter.createResult(results, state, state.getFilterPath(this.getConfiguration(context), this.messages));
            JSONObject response = converter.createJSONResponse(jsonResults);
            context.getRequestScope().put(ATTRIBUTE_AJAX_RESPONSE_MODEL, (Object)response.toString());
        }
        catch (JSONException e) {
            return this.error((Exception)((Object)e));
        }
        return this.success();
    }

    private List<ResourceDetails> getResults(RequestContext context, State state) {
        RepositorySearchConfiguration repositorySearchConfiguration = this.getConfiguration(context);
        int itemsPerPage = repositorySearchConfiguration.getItemsPerPage();
        ArrayList<ResourceDetails> results = new ArrayList<ResourceDetails>(itemsPerPage * 2);
        do {
            int itemsToLoad = this.resourceLoadStrategy.getItemsToLoadCount(itemsPerPage, results.size());
            List<ResourceDetails> accessibleResults = this.repositorySearchService.getResults(this.exContext(context), this.searchCriteriaFactory, this.createAllFiltersList(context), this.getSorter(context, state.getSortBy()), state.getResultIndex(), itemsToLoad);
            results.addAll(accessibleResults);
            state.updateResultState(state.getResultIndex() + itemsToLoad, state.getResultsCount());
        } while (results.size() < itemsPerPage && state.getResultIndex() < state.getResultsCount());
        return results;
    }

    private ExecutionContext exContext(RequestContext context) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        ExecutionContext exContext = JasperServerUtil.getExecutionContext((RequestContext)context);
        if (exContext.getAttributes() == null) {
            exContext.setAttributes(new ArrayList());
        }
        exContext.getAttributes().add(authentication.getPrincipal());
        SearchMode mode = this.getMode(context);
        SearchAttributes searchAttributes = new SearchAttributes();
        searchAttributes.setMode(mode);
        searchAttributes.setState(this.getSearchHolder(context).getState(mode));
        exContext.getAttributes().add(searchAttributes);
        return exContext;
    }

    public SearchSorter getSorter(RequestContext context, String id) {
        for (CustomSorter sorter : this.getConfiguration(context).getCustomSorters()) {
            if (!sorter.getId().equals(id)) continue;
            return sorter.getSearchSorter();
        }
        return null;
    }

    private List<SearchFilter> createAllFiltersList(RequestContext context) {
        ArrayList<SearchFilter> filterList = new ArrayList<SearchFilter>();
        RepositorySearchConfiguration configuration = this.getConfiguration(context);
        filterList.addAll(configuration.getSystemFilters());
        filterList.addAll(this.getRestrictionsFilters(context));
        return filterList;
    }

    private List<SearchFilter> getRestrictionsFilters(RequestContext context) {
        SearchMode mode = this.getMode(context);
        State state = this.getSearchHolder(context).getState(mode);
        ArrayList<SearchFilter> filters = new ArrayList<SearchFilter>();
        for (Map.Entry<String, String> entry : state.getCustomFiltersMap().entrySet()) {
            for (CustomFilter filter : this.getConfiguration(context).getCustomFilters()) {
                if (!filter.isRestrictionsFilter() || !filter.getId().equals(entry.getKey())) continue;
                filters.add(filter.getFilter());
            }
        }
        return filters;
    }

    private boolean isDefaultFilterOption(RequestContext context, String filterId, String filterOption) {
        RepositorySearchConfiguration configuration = this.getConfiguration(context);
        for (CustomFilter customFilter : configuration.getCustomFilters()) {
            if (!customFilter.getId().equals(filterId)) continue;
            return customFilter.getDefaultOption().equals(filterOption);
        }
        return false;
    }

    private boolean isFilterValid(RequestContext context, String filterId, String filterOption) {
        if (filterId != null && filterOption != null) {
            RepositorySearchConfiguration configuration = this.getConfiguration(context);
            for (CustomFilter customFilter : configuration.getCustomFilters()) {
                if (!customFilter.getId().equals(filterId)) continue;
                for (Option option : customFilter.getOptions()) {
                    if (!option.getId().equals(filterOption)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isSorterValid(RequestContext context, String sortBy) {
        if (sortBy != null) {
            RepositorySearchConfiguration configuration = this.getConfiguration(context);
            for (CustomSorter customSorter : configuration.getCustomSorters()) {
                if (!customSorter.getId().equals(sortBy)) continue;
                return true;
            }
        }
        return false;
    }

    public Event getChildren(RequestContext context) throws Exception {
        JSONObject response;
        JSONConverter jsonConverter = this.getConverter(context);
        try {
            String resourceType = this.getParameter(context, PARAMETER_RESOURCE_TYPE);
            String resourceUri = this.getParameter(context, PARAMETER_RESOURCE_URI);
            List<ResourceDetails> resourceList = this.repositorySearchService.getResourceChildren(resourceType, resourceUri);
            JSONArray resources = jsonConverter.resourcesToJson(resourceList);
            response = jsonConverter.createJSONResponse(resources);
        }
        catch (Exception e) {
            response = jsonConverter.createErrorJSONResponse(this.getErrorMessage(e));
            this.log.error((Object)"SEARCH_ERROR: Can't load resource children.", (Throwable)e);
        }
        context.getRequestScope().put(ATTRIBUTE_AJAX_RESPONSE_MODEL, (Object)response.toString());
        return this.success();
    }

    protected Boolean isAnalysisFeatureSupported() {
        return true;
    }

    protected Boolean isFeatureSupported(String id) {
        return NavigationActionModelSupport.getInstance().isAvailableProFeature(id);
    }
}

