/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.util;

import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.defaults.DefaultDockingPort;
import org.flexdock.logging.Log;
import org.flexdock.util.LookAndFeelSettings;
import org.flexdock.util.ResourceManager;
import org.flexdock.util.RootWindow;

public class SwingUtility {
    public static Component toComponent(Object obj) {
        return obj instanceof Component ? (Component)obj : null;
    }

    public static void revalidate(Component comp) {
        if (comp instanceof JComponent) {
            ((JComponent)comp).revalidate();
        }
    }

    public static void repaint(Component comp) {
        if (comp instanceof JComponent) {
            ((JComponent)comp).repaint();
        }
    }

    public static void drawRect(Graphics g, Rectangle r) {
        if (g == null || r == null) {
            return;
        }
        g.drawRect(r.x, r.y, r.width, r.height);
    }

    public static DockingPort[] getChildPorts(DockingPort port) {
        if (!(port instanceof DefaultDockingPort)) {
            return new DockingPort[0];
        }
        DefaultDockingPort parent = (DefaultDockingPort)port;
        Component docked = parent.getDockedComponent();
        if (!(docked instanceof JSplitPane)) {
            return new DockingPort[0];
        }
        JSplitPane split = (JSplitPane)docked;
        DockingPort left = null;
        DockingPort right = null;
        if (split.getLeftComponent() instanceof DockingPort) {
            left = (DockingPort)((Object)split.getLeftComponent());
        }
        if (split.getRightComponent() instanceof DockingPort) {
            right = (DockingPort)((Object)split.getRightComponent());
        }
        if (left == null && right == null) {
            return new DockingPort[0];
        }
        if (left == null) {
            return new DockingPort[]{right};
        }
        if (right == null) {
            return new DockingPort[]{left};
        }
        return new DockingPort[]{left, right};
    }

    public static Point[] getPoints(Rectangle rect) {
        return SwingUtility.getPoints(rect, null);
    }

    public static Point[] getPoints(Rectangle rect, Component convertFromScreen) {
        if (rect == null) {
            return null;
        }
        Rectangle r = (Rectangle)rect.clone();
        Point p = r.getLocation();
        if (convertFromScreen != null) {
            SwingUtilities.convertPointFromScreen(p, convertFromScreen);
        }
        r.setLocation(p);
        return new Point[]{p, new Point(p.x + r.width, p.y), new Point(p.x + r.width, p.y + r.height), new Point(p.x, p.y + r.height)};
    }

    public static final void centerOnScreen(Window window) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension windowSize = window.getSize();
        if (windowSize.height > screenSize.height) {
            windowSize.height = screenSize.height;
        }
        if (windowSize.width > screenSize.width) {
            windowSize.width = screenSize.width;
        }
        window.setLocation((screenSize.width - windowSize.width) / 2, (screenSize.height - windowSize.height) / 2);
    }

    public static void center(Window window, Component parent) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle bounds = new Rectangle(parent.getLocationOnScreen(), parent.getSize());
        int w = window.getWidth();
        int h = window.getHeight();
        int x = (int)bounds.getCenterX() - w / 2;
        int y = (int)bounds.getCenterY() - h / 2;
        if (x < 0) {
            x = 0;
        } else if ((double)(x + w) > screenSize.getWidth()) {
            x = (int)screenSize.getWidth() - w;
        }
        if (y < 0) {
            y = 0;
        } else if ((double)(y + h) > screenSize.getHeight()) {
            y = (int)screenSize.getHeight() - h;
        }
        window.setBounds(x, y, w, h);
    }

    public static Container getContentPane(Component c) {
        RootWindow rootWin = RootWindow.getRootContainer(c);
        return rootWin == null ? null : rootWin.getContentPane();
    }

    public static void setPlaf(Class lookAndFeelClass) {
        String className = lookAndFeelClass == null ? null : lookAndFeelClass.getName();
        SwingUtility.setPlaf(className);
    }

    public static void setPlaf(String lookAndFeelClassName) {
        if (SwingUtility.loadSkinLF(lookAndFeelClassName)) {
            return;
        }
        try {
            UIManager.setLookAndFeel(lookAndFeelClassName);
        }
        catch (Exception e) {
            Log.debug(e.getMessage(), e);
        }
    }

    private static boolean loadSkinLF(String themePack) {
        if (themePack == null || !themePack.endsWith(".zip") || !SwingUtility.isSkinLFInstalled()) {
            return false;
        }
        try {
            Skin skin = SkinLookAndFeel.loadThemePack((URL)ResourceManager.getResource(themePack));
            SkinLookAndFeel.setSkin((Skin)skin);
            UIManager.setLookAndFeel(SkinLookAndFeel.class.getName());
            return true;
        }
        catch (Exception e) {
            Log.debug(e.getMessage(), e);
            return false;
        }
    }

    public static void add(Point p1, Point p2) {
        if (p1 != null && p2 != null) {
            p1.x += p2.x;
            p1.y += p2.y;
        }
    }

    public static void subtract(Point p1, Point p2) {
        if (p1 != null && p2 != null) {
            p1.x -= p2.x;
            p1.y -= p2.y;
        }
    }

    public static void translate(Component src, Polygon poly, Component dest) {
        if (src == null || poly == null || dest == null) {
            return;
        }
        Rectangle srcRect = src.getBounds();
        srcRect.setLocation(0, 0);
        Rectangle destRect = SwingUtilities.convertRectangle(src, srcRect, dest);
        int deltaX = destRect.x - srcRect.x;
        int deltaY = destRect.y - srcRect.y;
        int len = poly.npoints;
        int i = 0;
        while (i < len) {
            int n = i;
            poly.xpoints[n] = poly.xpoints[n] + deltaX;
            int n2 = i++;
            poly.ypoints[n2] = poly.ypoints[n2] + deltaY;
        }
    }

    public static void focus(final Component c) {
        RootWindow window = RootWindow.getRootContainer(c);
        if (window == null) {
            return;
        }
        Component root = window.getRootContainer();
        Component comp = c;
        Container parent = comp.getParent();
        while (parent != root) {
            if (parent instanceof JTabbedPane) {
                ((JTabbedPane)parent).setSelectedComponent(comp);
            }
            comp = parent;
            parent = comp.getParent();
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                c.requestFocus();
            }
        });
    }

    public static Component getNearestFocusableComponent(Component c) {
        return SwingUtility.getNearestFocusableComponent(c, null);
    }

    public static Component getNearestFocusableComponent(Component c, Container desiredRoot) {
        Container cnt;
        if (c == null) {
            c = desiredRoot;
        }
        if (c == null) {
            c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        }
        boolean cachedFocusCycleRoot = false;
        if (desiredRoot != null && !(cachedFocusCycleRoot = desiredRoot.isFocusCycleRoot())) {
            desiredRoot.setFocusCycleRoot(true);
        }
        Container focusRoot = null;
        focusRoot = c instanceof Container ? ((cnt = (Container)c).isFocusCycleRoot(cnt) ? cnt : cnt.getFocusCycleRootAncestor()) : c.getFocusCycleRootAncestor();
        Component focuser = null;
        if (focusRoot != null) {
            focuser = focusRoot.getFocusTraversalPolicy().getLastComponent(focusRoot);
        }
        if (desiredRoot != null && !cachedFocusCycleRoot) {
            desiredRoot.setFocusCycleRoot(cachedFocusCycleRoot);
        }
        return focuser;
    }

    public static void activateWindow(Component c) {
        RootWindow window = RootWindow.getRootContainer(c);
        if (window != null && !window.isActive()) {
            window.toFront();
        }
    }

    public static Color brighter(Color color, double factor) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        int i = (int)(1.0 / (1.0 - factor));
        if (red == 0 && green == 0 && blue == 0) {
            return new Color(i, i, i);
        }
        if (red > 0 && red < i) {
            red = i;
        }
        if (green > 0 && green < i) {
            green = i;
        }
        if (blue > 0 && blue < i) {
            blue = i;
        }
        return new Color(Math.min((int)((double)red / factor), 255), Math.min((int)((double)green / factor), 255), Math.min((int)((double)blue / factor), 255));
    }

    public static Color darker(Color color, double factor) {
        return new Color(Math.max((int)((double)color.getRed() * factor), 0), Math.max((int)((double)color.getGreen() * factor), 0), Math.max((int)((double)color.getBlue() * factor), 0));
    }

    public static Color grayScale(Color color) {
        int grayTone = (color.getRed() + color.getGreen() + color.getBlue()) / 3;
        return new Color(grayTone, grayTone, grayTone);
    }

    public static void putClientProperty(Component c, Object key, Object value) {
        if (c instanceof JComponent) {
            ((JComponent)c).putClientProperty(key, value);
        }
    }

    public static Object getClientProperty(Component c, Object key) {
        if (c instanceof JComponent) {
            return ((JComponent)c).getClientProperty(key);
        }
        return null;
    }

    public static void removeClientProperty(Component c, Object key) {
        if (c instanceof JComponent) {
            ((JComponent)c).putClientProperty(key, null);
        }
    }

    public static Window getActiveWindow() {
        KeyboardFocusManager mgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        return mgr.getActiveWindow();
    }

    public static BufferedImage createImage(Component comp) {
        if (comp == null) {
            return null;
        }
        BufferedImage image = (BufferedImage)comp.createImage(comp.getWidth(), comp.getHeight());
        Graphics2D g = image.createGraphics();
        comp.paintAll(g);
        return image;
    }

    public static float getDividerProportion(JSplitPane splitPane) {
        if (splitPane == null) {
            return 0.0f;
        }
        int size = splitPane.getOrientation() == 1 ? splitPane.getWidth() : splitPane.getHeight();
        int divLoc = splitPane.getDividerLocation();
        return size == 0 ? 0.0f : (float)divLoc / (float)size;
    }

    public static Component getOtherComponent(JSplitPane split, Component current) {
        if (split == null || current == null) {
            return null;
        }
        Component other = split.getLeftComponent();
        if (other == current) {
            other = split.getRightComponent();
        }
        return other;
    }

    public static int getSplitPaneSize(JSplitPane splitPane) {
        if (splitPane == null) {
            return 0;
        }
        boolean horiz = splitPane.getOrientation() == 1;
        return horiz ? splitPane.getWidth() : splitPane.getHeight();
    }

    public static void setSplitDivider(final JSplitPane split, float proportion) {
        if (split == null) {
            return;
        }
        proportion = Math.max(0.0f, proportion);
        final float percent = Math.min(1.0f, proportion);
        int size = SwingUtility.getSplitPaneSize(split);
        if (split.isVisible() && size > 0 && EventQueue.isDispatchThread()) {
            split.setDividerLocation(proportion);
            split.validate();
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SwingUtility.setSplitDivider(split, percent);
            }
        });
    }

    public static boolean isSkinLFInstalled() {
        return LookAndFeelSettings.isSkinLFSupported();
    }
}

