/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.undo;

import it.businesslogic.ireport.CrosstabReportElement;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.UndoOperation;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.event.ReportElementChangedEvent;
import it.businesslogic.ireport.undo.PositionedElement;
import java.util.Enumeration;
import java.util.Vector;

public class ChangeEmentsOrderOperation
implements UndoOperation {
    private Vector elements = null;
    private JReportFrame jrf = null;
    private CrosstabReportElement crosstabReportElement = null;

    public ChangeEmentsOrderOperation(JReportFrame jrf, CrosstabReportElement crosstabReportElement) {
        this.crosstabReportElement = crosstabReportElement;
        this.elements = new Vector();
        this.jrf = jrf;
    }

    public ChangeEmentsOrderOperation(JReportFrame jrf) {
        this(jrf, null);
    }

    public void redo() {
        if (this.jrf == null) {
            return;
        }
        Enumeration e = this.getElements().elements();
        Vector<ReportElement> changed_elements = new Vector<ReportElement>();
        while (e.hasMoreElements()) {
            PositionedElement pe = (PositionedElement)e.nextElement();
            ReportElement element = pe.getElement();
            changed_elements.add(element);
            if (this.getCrosstabReportElement() != null) {
                this.getCrosstabReportElement().getElements().remove(pe.getOldPosition());
                this.getCrosstabReportElement().getElements().insertElementAt(element, pe.getNewPosition());
                this.jrf.getCrosstabEditor(this.getCrosstabReportElement()).getPanelEditor().addSelectedElement(element, false);
                this.jrf.getCrosstabEditor(this.getCrosstabReportElement()).getPanelEditor().repaint();
                continue;
            }
            this.jrf.getReport().getElements().remove(pe.getOldPosition());
            this.jrf.getReport().getElements().insertElementAt(element, pe.getNewPosition());
            this.jrf.addSelectedElement(element, false);
            this.jrf.getReportPanel().repaint();
        }
        this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, this.getCrosstabReportElement(), changed_elements, 3));
    }

    public void undo() {
        if (this.jrf == null) {
            return;
        }
        this.jrf.setSelectedElement(null);
        Vector<ReportElement> changed_elements = new Vector<ReportElement>();
        for (int i = this.getElements().size() - 1; i >= 0; --i) {
            PositionedElement pe = (PositionedElement)this.getElements().get(i);
            ReportElement element = pe.getElement();
            changed_elements.add(element);
            if (this.getCrosstabReportElement() != null) {
                this.getCrosstabReportElement().getElements().remove(pe.getNewPosition());
                this.getCrosstabReportElement().getElements().insertElementAt(element, pe.getOldPosition());
                this.jrf.getCrosstabEditor(this.getCrosstabReportElement()).getPanelEditor().addSelectedElement(element, false);
                this.jrf.getCrosstabEditor(this.getCrosstabReportElement()).getPanelEditor().repaint();
                continue;
            }
            this.jrf.getReport().getElements().remove(pe.getNewPosition());
            this.jrf.getReport().getElements().insertElementAt(element, pe.getOldPosition());
            this.jrf.addSelectedElement(element, false);
            this.jrf.getReportPanel().repaint();
        }
        this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, this.getCrosstabReportElement(), changed_elements, 3));
    }

    public String toString() {
        return "change element(s) order";
    }

    public Vector getElements() {
        return this.elements;
    }

    public void setElements(Vector elements) {
        this.elements = elements;
    }

    public void addElement(ReportElement element, int oldPosition, int newPostion) {
        PositionedElement pe = new PositionedElement(element, oldPosition, newPostion);
        this.getElements().add(pe);
    }

    public CrosstabReportElement getCrosstabReportElement() {
        return this.crosstabReportElement;
    }

    public void setCrosstabReportElement(CrosstabReportElement crosstabReportElement) {
        this.crosstabReportElement = crosstabReportElement;
    }
}

