/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.domain.client;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public abstract class ResourceImpl
implements Resource {
    private int version;
    private Date creationDate;
    private Date updateDate;
    private String name;
    private String label;
    private String description;
    private List attributes;
    private String folderUri;
    private transient String uri;

    private static String getParentFolderFromUri(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        int lastSeparator = s.lastIndexOf("/");
        if (lastSeparator < 0) {
            return null;
        }
        if (lastSeparator == 0) {
            return "/";
        }
        return s.substring(0, lastSeparator);
    }

    private static String getNameFromUri(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        int lastSeparator = s.lastIndexOf("/");
        if (lastSeparator < 0 || lastSeparator == s.length() - 1) {
            return null;
        }
        return s.substring(lastSeparator + 1, s.length());
    }

    protected ResourceImpl() {
        this.version = -1;
    }

    protected ResourceImpl(ResourceImpl another) {
        if (another != null) {
            this.attributes = another.attributes != null ? Arrays.asList((Object[])another.attributes.toArray().clone()) : null;
            this.creationDate = another.creationDate != null ? (Date)another.creationDate.clone() : null;
            this.updateDate = another.updateDate != null ? (Date)another.updateDate.clone() : null;
            this.version = another.version;
            this.name = another.name;
            this.label = another.label;
            this.description = another.description;
            this.folderUri = another.folderUri;
            this.uri = another.uri;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.uri = null;
        this.name = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getURIString() {
        if (this.uri == null) {
            StringBuffer sb = new StringBuffer();
            if (this.getParentFolder() != null && !this.getParentFolder().equals("/")) {
                sb.append(this.getParentFolder());
            }
            sb.append("/");
            if (!this.getName().equals("/")) {
                sb.append(this.getName());
            }
            this.uri = sb.toString();
        }
        return this.uri;
    }

    public void setURIString(String uri) {
        this.uri = uri;
        this.name = ResourceImpl.getNameFromUri(uri);
        this.folderUri = ResourceImpl.getParentFolderFromUri(uri);
    }

    public String getPath() {
        return this.getURIString();
    }

    public String getProtocol() {
        return "repo";
    }

    public String getURI() {
        return this.getProtocol() + ":" + this.getPath();
    }

    public String getParentURI() {
        return this.getParentFolder() == null ? null : this.getProtocol() + ":" + this.getParentFolder();
    }

    public String getParentPath() {
        return this.getParentFolder() == null ? null : this.getParentFolder();
    }

    public String getParentFolder() {
        return this.folderUri;
    }

    public void setParentFolder(Folder folder) {
        this.uri = null;
        this.folderUri = folder == null ? null : folder.getURIString();
    }

    public void setParentFolder(String folderURI) {
        this.uri = null;
        this.folderUri = folderURI;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List attrs) {
        this.attributes = attrs;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getResourceType() {
        return this.getImplementingItf().getName();
    }

    public boolean isSameType(Resource resource) {
        return this.getResourceType().equals(resource.getResourceType());
    }

    protected abstract Class getImplementingItf();

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public boolean isNew() {
        return this.version == -1;
    }
}

