/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.util;

public class CubeIndexIterator {
    int[] ni;
    int[] iCurrent;
    boolean firstFast;
    int nDim;

    public CubeIndexIterator(int[] ni, boolean firstFast) {
        this.ni = ni;
        this.firstFast = firstFast;
        this.nDim = ni.length;
        this.iCurrent = new int[this.nDim];
        this.reset();
    }

    public int[] next() {
        if (this.nDim == 0) {
            return null;
        }
        if (this.firstFast) {
            this.iCurrent[0] = this.iCurrent[0] + 1;
            for (int i = 0; i < this.nDim - 1; ++i) {
                if (this.iCurrent[i] <= this.ni[i]) continue;
                int n = i + 1;
                this.iCurrent[n] = this.iCurrent[n] + 1;
                this.iCurrent[i] = 0;
            }
            if (this.iCurrent[this.nDim - 1] > this.ni[this.nDim - 1]) {
                return null;
            }
        } else {
            int n = this.nDim - 1;
            this.iCurrent[n] = this.iCurrent[n] + 1;
            for (int i = this.nDim - 1; i > 0; --i) {
                if (this.iCurrent[i] <= this.ni[i]) continue;
                int n2 = i - 1;
                this.iCurrent[n2] = this.iCurrent[n2] + 1;
                this.iCurrent[i] = 0;
            }
            if (this.iCurrent[0] > this.ni[0]) {
                return null;
            }
        }
        return this.iCurrent;
    }

    public void reset() {
        if (this.nDim == 0) {
            return;
        }
        for (int i = 0; i < this.nDim; ++i) {
            this.iCurrent[i] = !this.firstFast && i == this.nDim - 1 ? -1 : (this.firstFast && i == 0 ? -1 : 0);
        }
    }
}

