/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.mondrian.script;

import com.tonbeller.jpivot.mondrian.MondrianDrillThroughTableModel;
import com.tonbeller.jpivot.mondrian.script.ScriptColumn;
import com.tonbeller.wcf.table.AbstractTableModel;
import com.tonbeller.wcf.table.DefaultCell;
import com.tonbeller.wcf.table.DefaultTableRow;
import com.tonbeller.wcf.table.TableRow;
import groovy.lang.Binding;
import groovy.util.GroovyScriptEngine;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import mondrian.rolap.RolapConnectionProperties;
import org.apache.commons.digester.Digester;
import org.apache.log4j.Logger;

public class ScriptableMondrianDrillThroughTableModel
extends AbstractTableModel {
    private static Logger logger = Logger.getLogger(MondrianDrillThroughTableModel.class);
    private String title = "Drill Through Table";
    private String caption = "";
    private String sql = "";
    private String jdbcUser;
    private String jdbcUrl;
    private String jdbcPassword;
    private String jdbcDriver;
    private String dataSourceName;
    private String catalogExtension;
    private int maxResults;
    private String scriptRootUrl;
    private List scripts = new ArrayList();
    private GroovyScriptEngine scriptEngine = null;
    private DataSource dataSource;
    private static Context jndiContext;
    private boolean ready = false;
    private TableRow[] rows = new TableRow[0];
    private String[] columnTitles = new String[0];
    private Locale locale;

    public int getRowCount() {
        if (!this.ready) {
            this.executeQuery();
        }
        return this.rows.length;
    }

    public TableRow getRow(int rowIndex) {
        if (!this.ready) {
            this.executeQuery();
        }
        return this.rows[rowIndex];
    }

    public String getTitle() {
        return this.title;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
        this.ready = false;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getColumnCount() {
        if (!this.ready) {
            this.executeQuery();
        }
        return this.columnTitles.length;
    }

    public String getColumnTitle(int columnIndex) {
        if (!this.ready) {
            this.executeQuery();
        }
        return this.columnTitles[columnIndex];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQuery() {
        Connection con = null;
        try {
            InputStream catExtIs = ScriptableMondrianDrillThroughTableModel.class.getClassLoader().getResourceAsStream("/" + this.catalogExtension);
            if (catExtIs != null) {
                Digester catExtDigester = new Digester();
                catExtDigester.push((Object)this);
                catExtDigester.addSetProperties("extension");
                catExtDigester.addObjectCreate("extension/script", "com.tonbeller.jpivot.mondrian.script.ScriptColumn");
                catExtDigester.addSetProperties("extension/script");
                catExtDigester.addSetNext("extension/script", "addScript");
                catExtDigester.parse(catExtIs);
                URL scriptsBaseURL = Thread.currentThread().getContextClassLoader().getResource(this.scriptRootUrl);
                this.scriptEngine = new GroovyScriptEngine(new URL[]{scriptsBaseURL});
            }
            con = this.getConnection();
            Statement s = con.createStatement();
            s.setMaxRows(this.maxResults);
            ResultSet rs = s.executeQuery(this.sql);
            ResultSetMetaData md = rs.getMetaData();
            int numCols = md.getColumnCount();
            ArrayList<String> columnTitlesList = new ArrayList<String>();
            for (int i = 0; i < numCols; ++i) {
                columnTitlesList.add(i, md.getColumnName(i + 1));
            }
            ListIterator sIt = this.scripts.listIterator();
            while (sIt.hasNext()) {
                ScriptColumn sc = (ScriptColumn)sIt.next();
                columnTitlesList.add(sc.getPosition() - 1, sc.getTitle());
            }
            this.columnTitles = columnTitlesList.toArray(new String[0]);
            ArrayList<DefaultTableRow> tempRows = new ArrayList<DefaultTableRow>();
            HashMap<String, Object> scriptInput = new HashMap<String, Object>();
            Binding binding = new Binding();
            while (rs.next()) {
                ArrayList<Object> rowList = new ArrayList<Object>();
                scriptInput.clear();
                for (int i = 0; i < numCols; ++i) {
                    rowList.add(i, rs.getObject(i + 1));
                    scriptInput.put(this.columnTitles[i], rs.getObject(i + 1));
                }
                binding.setVariable("input", scriptInput);
                ListIterator sIt2 = this.scripts.listIterator();
                while (sIt2.hasNext()) {
                    ScriptColumn sc = (ScriptColumn)sIt2.next();
                    this.scriptEngine.run(sc.getFile(), binding);
                    Object output = binding.getVariable("output");
                    if (output instanceof Map) {
                        Map outMap = (Map)output;
                        rowList.add(sc.getPosition() - 1, new DefaultCell((String)outMap.get("URL"), (Object)((String)outMap.get("Value"))));
                        continue;
                    }
                    if (output instanceof String) {
                        rowList.add(sc.getPosition() - 1, (String)output);
                        continue;
                    }
                    throw new Exception("Unknown groovy script return type (not a Map nor String).");
                }
                tempRows.add(new DefaultTableRow(rowList.toArray()));
            }
            rs.close();
            this.rows = tempRows.toArray(new TableRow[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)"?", (Throwable)e);
            this.rows = new TableRow[1];
            this.columnTitles = new String[1];
            this.columnTitles[0] = "An error occured";
            Object[] row = new Object[]{e.toString()};
            this.rows[0] = new DefaultTableRow(row);
            this.ready = false;
            return;
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e1) {}
        }
        this.ready = true;
    }

    private Connection getConnection() throws SQLException {
        if (this.dataSourceName == null) {
            if (this.jdbcUrl == null) {
                throw new RuntimeException("Mondrian Connect string '' must contain either '" + RolapConnectionProperties.Jdbc + "' or '" + RolapConnectionProperties.DataSource + "'");
            }
            return DriverManager.getConnection(this.jdbcUrl, this.jdbcUser, this.jdbcPassword);
        }
        return this.getDataSource().getConnection();
    }

    private DataSource getDataSource() {
        if (this.dataSource == null) {
            try {
                this.dataSource = (DataSource)this.getJndiContext().lookup(this.dataSourceName);
            }
            catch (NamingException e) {
                throw new RuntimeException("Error while looking up data source (" + this.dataSourceName + ")", e);
            }
        }
        return this.dataSource;
    }

    private Context getJndiContext() throws NamingException {
        if (jndiContext == null) {
            jndiContext = new InitialContext();
        }
        return jndiContext;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public void setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public void setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = jdbcPassword;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public String getJdbcUser() {
        return this.jdbcUser;
    }

    public void setJdbcUser(String jdbcUser) {
        this.jdbcUser = jdbcUser;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    public String getCatalogExtension() {
        return this.catalogExtension;
    }

    public void setCatalogExtension(String string) {
        this.catalogExtension = string;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public List getScripts() {
        return this.scripts;
    }

    public void setScripts(List scripts) {
        this.scripts = scripts;
    }

    public void addScript(ScriptColumn column) {
        this.scripts.add(column);
    }

    public String getScriptRootUrl() {
        return this.scriptRootUrl;
    }

    public void setScriptRootUrl(String scriptRootUrl) {
        this.scriptRootUrl = scriptRootUrl;
    }

    public Locale getLocale() {
        return this.locale;
    }
}

