/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.vote;

import java.util.Vector;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.security.AccessDeniedException;
import org.springframework.security.Authentication;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.providers.TestingAuthenticationToken;
import org.springframework.security.vote.AffirmativeBased;
import org.springframework.security.vote.DenyAgainVoter;
import org.springframework.security.vote.DenyVoter;
import org.springframework.security.vote.RoleVoter;

public class AffirmativeBasedTests
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(AffirmativeBasedTests.class);
    }

    private AffirmativeBased makeDecisionManager() {
        AffirmativeBased decisionManager = new AffirmativeBased();
        Vector<Object> voters = new Vector<Object>();
        voters.add(new RoleVoter());
        voters.add(new DenyVoter());
        voters.add(new DenyAgainVoter());
        decisionManager.setDecisionVoters(voters);
        return decisionManager;
    }

    private TestingAuthenticationToken makeTestToken() {
        return new TestingAuthenticationToken((Object)"somebody", (Object)"password", "ROLE_1", "ROLE_2");
    }

    public void testOneAffirmativeGrantsAccess() {
        AffirmativeBased mgr = this.makeDecisionManager();
        ConfigAttributeDefinition config = new ConfigAttributeDefinition(new String[]{"ROLE_1", "ROLE_2"});
        mgr.decide((Authentication)new TestingAuthenticationToken((Object)"somebody", (Object)"password", "ROLE_1"), new Object(), config);
    }

    public void testOneAffirmativeVoteOneDenyVoteOneAbstainVoteGrantsAccess() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        AffirmativeBased mgr = this.makeDecisionManager();
        ConfigAttributeDefinition config = new ConfigAttributeDefinition(new String[]{"ROLE_1", "DENY_FOR_SURE"});
        mgr.decide((Authentication)auth, new Object(), config);
    }

    public void testOneAffirmativeVoteTwoAbstainVotesGrantsAccess() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        AffirmativeBased mgr = this.makeDecisionManager();
        ConfigAttributeDefinition config = new ConfigAttributeDefinition("ROLE_2");
        mgr.decide((Authentication)auth, new Object(), config);
    }

    public void testOneDenyVoteTwoAbstainVotesDeniesAccess() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        AffirmativeBased mgr = this.makeDecisionManager();
        ConfigAttributeDefinition config = new ConfigAttributeDefinition("ROLE_WE_DO_NOT_HAVE");
        try {
            mgr.decide((Authentication)auth, new Object(), config);
            AffirmativeBasedTests.fail((String)"Should have thrown AccessDeniedException");
        }
        catch (AccessDeniedException expected) {
            // empty catch block
        }
    }

    public void testThreeAbstainVotesDeniesAccessWithDefault() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        AffirmativeBased mgr = this.makeDecisionManager();
        AffirmativeBasedTests.assertTrue((!mgr.isAllowIfAllAbstainDecisions() ? 1 : 0) != 0);
        ConfigAttributeDefinition config = new ConfigAttributeDefinition("IGNORED_BY_ALL");
        try {
            mgr.decide((Authentication)auth, new Object(), config);
            AffirmativeBasedTests.fail((String)"Should have thrown AccessDeniedException");
        }
        catch (AccessDeniedException expected) {
            // empty catch block
        }
    }

    public void testThreeAbstainVotesGrantsAccessWithoutDefault() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        AffirmativeBased mgr = this.makeDecisionManager();
        mgr.setAllowIfAllAbstainDecisions(true);
        AffirmativeBasedTests.assertTrue((boolean)mgr.isAllowIfAllAbstainDecisions());
        ConfigAttributeDefinition config = new ConfigAttributeDefinition("IGNORED_BY_ALL");
        mgr.decide((Authentication)auth, new Object(), config);
    }

    public void testOneAffirmativeVotesTwoAbstainVotesGrantsAccess() throws Exception {
        TestingAuthenticationToken auth = this.makeTestToken();
        AffirmativeBased mgr = this.makeDecisionManager();
        ConfigAttributeDefinition config = new ConfigAttributeDefinition(new String[]{"ROLE_1", "ROLE_2"});
        mgr.decide((Authentication)auth, new Object(), config);
    }
}

