/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.preauth.x509;

import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.MessageSource;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.SpringSecurityMessageSource;
import org.springframework.security.providers.x509.X509TestUtils;
import org.springframework.security.ui.preauth.x509.SubjectDnX509PrincipalExtractor;

public class SubjectDnX509PrincipalExtractorTests {
    SubjectDnX509PrincipalExtractor extractor;

    @Before
    public void setUp() {
        this.extractor = new SubjectDnX509PrincipalExtractor();
        this.extractor.setMessageSource((MessageSource)new SpringSecurityMessageSource());
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidRegexFails() throws Exception {
        this.extractor.setSubjectDnRegex("CN=(.*?,");
    }

    @Test
    public void defaultCNPatternReturnsExcpectedPrincipal() throws Exception {
        Object principal = this.extractor.extractPrincipal(X509TestUtils.buildTestCertificate());
        Assert.assertEquals((Object)"Luke Taylor", (Object)principal);
    }

    @Test
    public void matchOnEmailReturnsExpectedPrincipal() throws Exception {
        this.extractor.setSubjectDnRegex("emailAddress=(.*?),");
        Object principal = this.extractor.extractPrincipal(X509TestUtils.buildTestCertificate());
        Assert.assertEquals((Object)"luke@monkeymachine", (Object)principal);
    }

    @Test(expected=BadCredentialsException.class)
    public void matchOnShoeSizeThrowsBadCredentials() throws Exception {
        this.extractor.setSubjectDnRegex("shoeSize=(.*?),");
        this.extractor.extractPrincipal(X509TestUtils.buildTestCertificate());
    }
}

