/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.jaas;

import java.net.URL;
import java.security.Security;
import java.util.Arrays;
import java.util.List;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpSession;
import junit.framework.TestCase;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.LockedException;
import org.springframework.security.SpringSecurityException;
import org.springframework.security.context.SecurityContextImpl;
import org.springframework.security.providers.TestingAuthenticationToken;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.providers.jaas.JaasAuthenticationProvider;
import org.springframework.security.providers.jaas.JaasAuthenticationToken;
import org.springframework.security.providers.jaas.JaasEventCheck;
import org.springframework.security.providers.jaas.JaasGrantedAuthority;
import org.springframework.security.providers.jaas.LoginExceptionResolver;
import org.springframework.security.ui.session.HttpSessionDestroyedEvent;

public class JaasAuthenticationProviderTests
extends TestCase {
    private ApplicationContext context;
    private JaasAuthenticationProvider jaasProvider;
    private JaasEventCheck eventCheck;

    protected void setUp() throws Exception {
        String resName = "/" + ((Object)((Object)this)).getClass().getName().replace('.', '/') + ".xml";
        this.context = new ClassPathXmlApplicationContext(resName);
        this.eventCheck = (JaasEventCheck)this.context.getBean("eventCheck");
        this.jaasProvider = (JaasAuthenticationProvider)this.context.getBean("jaasAuthenticationProvider");
    }

    public void testBadPassword() {
        try {
            this.jaasProvider.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"user", (Object)"asdf"));
            JaasAuthenticationProviderTests.fail((String)"LoginException should have been thrown for the bad password");
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
        JaasAuthenticationProviderTests.assertNotNull((String)"Failure event not fired", (Object)this.eventCheck.failedEvent);
        JaasAuthenticationProviderTests.assertNotNull((String)"Failure event exception was null", (Object)this.eventCheck.failedEvent.getException());
        JaasAuthenticationProviderTests.assertNull((String)"Success event was fired", (Object)this.eventCheck.successEvent);
    }

    public void testBadUser() {
        try {
            this.jaasProvider.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"asdf", (Object)"password"));
            JaasAuthenticationProviderTests.fail((String)"LoginException should have been thrown for the bad user");
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
        JaasAuthenticationProviderTests.assertNotNull((String)"Failure event not fired", (Object)this.eventCheck.failedEvent);
        JaasAuthenticationProviderTests.assertNotNull((String)"Failure event exception was null", (Object)this.eventCheck.failedEvent.getException());
        JaasAuthenticationProviderTests.assertNull((String)"Success event was fired", (Object)this.eventCheck.successEvent);
    }

    public void testConfigurationLoop() throws Exception {
        String resName = "/" + ((Object)((Object)this)).getClass().getName().replace('.', '/') + ".conf";
        URL url = ((Object)((Object)this)).getClass().getResource(resName);
        Security.setProperty("login.config.url.1", url.toString());
        this.setUp();
        this.testFull();
    }

    public void testDetectsMissingLoginConfig() throws Exception {
        JaasAuthenticationProvider myJaasProvider = new JaasAuthenticationProvider();
        myJaasProvider.setApplicationEventPublisher((ApplicationEventPublisher)this.context);
        myJaasProvider.setAuthorityGranters(this.jaasProvider.getAuthorityGranters());
        myJaasProvider.setCallbackHandlers(this.jaasProvider.getCallbackHandlers());
        myJaasProvider.setLoginContextName(this.jaasProvider.getLoginContextName());
        try {
            myJaasProvider.afterPropertiesSet();
            JaasAuthenticationProviderTests.fail((String)"Should have thrown ApplicationContextException");
        }
        catch (IllegalArgumentException expected) {
            JaasAuthenticationProviderTests.assertTrue((boolean)expected.getMessage().startsWith("loginConfig must be set on"));
        }
    }

    public void testDetectsMissingLoginContextName() throws Exception {
        JaasAuthenticationProvider myJaasProvider = new JaasAuthenticationProvider();
        myJaasProvider.setApplicationEventPublisher((ApplicationEventPublisher)this.context);
        myJaasProvider.setAuthorityGranters(this.jaasProvider.getAuthorityGranters());
        myJaasProvider.setCallbackHandlers(this.jaasProvider.getCallbackHandlers());
        myJaasProvider.setLoginConfig(this.jaasProvider.getLoginConfig());
        myJaasProvider.setLoginContextName(null);
        try {
            myJaasProvider.afterPropertiesSet();
            JaasAuthenticationProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            JaasAuthenticationProviderTests.assertTrue((boolean)expected.getMessage().startsWith("loginContextName must be set on"));
        }
        myJaasProvider.setLoginContextName("");
        try {
            myJaasProvider.afterPropertiesSet();
            JaasAuthenticationProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            JaasAuthenticationProviderTests.assertTrue((boolean)expected.getMessage().startsWith("loginContextName must be set on"));
        }
    }

    public void testFull() throws Exception {
        GrantedAuthorityImpl role1 = new GrantedAuthorityImpl("ROLE_1");
        GrantedAuthorityImpl role2 = new GrantedAuthorityImpl("ROLE_2");
        GrantedAuthority[] defaultAuths = new GrantedAuthority[]{role1, role2};
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"user", (Object)"password", defaultAuths);
        JaasAuthenticationProviderTests.assertTrue((boolean)this.jaasProvider.supports(UsernamePasswordAuthenticationToken.class));
        Authentication auth = this.jaasProvider.authenticate((Authentication)token);
        JaasAuthenticationProviderTests.assertNotNull((Object)this.jaasProvider.getAuthorityGranters());
        JaasAuthenticationProviderTests.assertNotNull((Object)this.jaasProvider.getCallbackHandlers());
        JaasAuthenticationProviderTests.assertNotNull((Object)this.jaasProvider.getLoginConfig());
        JaasAuthenticationProviderTests.assertNotNull((Object)this.jaasProvider.getLoginContextName());
        List<GrantedAuthority> list = Arrays.asList(auth.getAuthorities());
        JaasAuthenticationProviderTests.assertTrue((String)"GrantedAuthorities should contain ROLE_TEST1", (boolean)list.contains(new GrantedAuthorityImpl("ROLE_TEST1")));
        JaasAuthenticationProviderTests.assertTrue((String)"GrantedAuthorities should contain ROLE_TEST2", (boolean)list.contains(new GrantedAuthorityImpl("ROLE_TEST2")));
        JaasAuthenticationProviderTests.assertTrue((String)"GrantedAuthorities should contain ROLE_1", (boolean)list.contains(role1));
        JaasAuthenticationProviderTests.assertTrue((String)"GrantedAuthorities should contain ROLE_2", (boolean)list.contains(role2));
        boolean foundit = false;
        for (int i = 0; i < list.size(); ++i) {
            GrantedAuthority obj = list.get(i);
            if (!(obj instanceof JaasGrantedAuthority)) continue;
            JaasGrantedAuthority grant = (JaasGrantedAuthority)obj;
            JaasAuthenticationProviderTests.assertNotNull((String)"Principal was null on JaasGrantedAuthority", (Object)grant.getPrincipal());
            foundit = true;
        }
        JaasAuthenticationProviderTests.assertTrue((String)"Could not find a JaasGrantedAuthority", (boolean)foundit);
        JaasAuthenticationProviderTests.assertNotNull((String)"Success event not fired", (Object)this.eventCheck.successEvent);
        JaasAuthenticationProviderTests.assertEquals((String)"Auth objects are not equal", (Object)auth, (Object)this.eventCheck.successEvent.getAuthentication());
        JaasAuthenticationProviderTests.assertNull((String)"Failure event was fired", (Object)this.eventCheck.failedEvent);
    }

    public void testGetApplicationEventPublisher() throws Exception {
        JaasAuthenticationProviderTests.assertNotNull((Object)this.jaasProvider.getApplicationEventPublisher());
    }

    public void testLoginExceptionResolver() {
        JaasAuthenticationProviderTests.assertNotNull((Object)this.jaasProvider.getLoginExceptionResolver());
        this.jaasProvider.setLoginExceptionResolver(new LoginExceptionResolver(){

            public SpringSecurityException resolveException(LoginException e) {
                return new LockedException("This is just a test!");
            }
        });
        try {
            this.jaasProvider.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"user", (Object)"password"));
        }
        catch (LockedException e) {
        }
        catch (Exception e) {
            JaasAuthenticationProviderTests.fail((String)"LockedException should have been thrown and caught");
        }
    }

    public void testLogout() throws Exception {
        MockLoginContext loginContext = new MockLoginContext(this.jaasProvider.getLoginContextName());
        JaasAuthenticationToken token = new JaasAuthenticationToken(null, null, (LoginContext)loginContext);
        SecurityContextImpl context = new SecurityContextImpl();
        context.setAuthentication((Authentication)token);
        MockHttpSession mockSession = new MockHttpSession();
        mockSession.setAttribute("SPRING_SECURITY_CONTEXT", (Object)context);
        this.jaasProvider.onApplicationEvent((ApplicationEvent)new HttpSessionDestroyedEvent((HttpSession)mockSession));
        JaasAuthenticationProviderTests.assertTrue((boolean)loginContext.loggedOut);
    }

    public void testNullDefaultAuthorities() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"user", (Object)"password", null);
        JaasAuthenticationProviderTests.assertTrue((boolean)this.jaasProvider.supports(UsernamePasswordAuthenticationToken.class));
        Authentication auth = this.jaasProvider.authenticate((Authentication)token);
        JaasAuthenticationProviderTests.assertTrue((String)"Only ROLE_TEST1 and ROLE_TEST2 should have been returned", (auth.getAuthorities().length == 2 ? 1 : 0) != 0);
    }

    public void testUnsupportedAuthenticationObjectReturnsNull() {
        JaasAuthenticationProviderTests.assertNull((Object)this.jaasProvider.authenticate((Authentication)new TestingAuthenticationToken((Object)"foo", (Object)"bar", new GrantedAuthority[0])));
    }

    private static class MockLoginContext
    extends LoginContext {
        boolean loggedOut = false;

        public MockLoginContext(String loginModule) throws LoginException {
            super(loginModule);
        }

        public void logout() throws LoginException {
            this.loggedOut = true;
        }
    }
}

