/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.providers.TestingAuthenticationProvider;
import org.springframework.security.providers.TestingAuthenticationToken;

public class TestingAuthenticationProviderTests
extends TestCase {
    public TestingAuthenticationProviderTests() {
    }

    public TestingAuthenticationProviderTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run(TestingAuthenticationProviderTests.class);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testAuthenticates() {
        TestingAuthenticationProvider provider = new TestingAuthenticationProvider();
        TestingAuthenticationToken token = new TestingAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        Authentication result = provider.authenticate((Authentication)token);
        if (!(result instanceof TestingAuthenticationToken)) {
            TestingAuthenticationProviderTests.fail((String)"Should have returned instance of TestingAuthenticationToken");
        }
        TestingAuthenticationToken castResult = (TestingAuthenticationToken)result;
        TestingAuthenticationProviderTests.assertEquals((Object)"Test", (Object)castResult.getPrincipal());
        TestingAuthenticationProviderTests.assertEquals((Object)"Password", (Object)castResult.getCredentials());
        TestingAuthenticationProviderTests.assertEquals((String)"ROLE_ONE", (String)castResult.getAuthorities()[0].getAuthority());
        TestingAuthenticationProviderTests.assertEquals((String)"ROLE_TWO", (String)castResult.getAuthorities()[1].getAuthority());
    }

    public void testSupports() {
        TestingAuthenticationProvider provider = new TestingAuthenticationProvider();
        TestingAuthenticationProviderTests.assertTrue((boolean)provider.supports(TestingAuthenticationToken.class));
        TestingAuthenticationProviderTests.assertTrue((!provider.supports(String.class) ? 1 : 0) != 0);
    }
}

