/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers;

import java.util.Arrays;
import java.util.Vector;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.AccountStatusException;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.AuthenticationServiceException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.MockApplicationEventPublisher;
import org.springframework.security.concurrent.ConcurrentLoginException;
import org.springframework.security.concurrent.ConcurrentSessionController;
import org.springframework.security.concurrent.ConcurrentSessionControllerImpl;
import org.springframework.security.concurrent.NullConcurrentSessionController;
import org.springframework.security.providers.AuthenticationProvider;
import org.springframework.security.providers.ProviderManager;
import org.springframework.security.providers.ProviderNotFoundException;
import org.springframework.security.providers.TestingAuthenticationToken;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;

public class ProviderManagerTests {
    @Test(expected=ProviderNotFoundException.class)
    public void authenticationFailsWithUnsupportedToken() throws Exception {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        ProviderManager mgr = this.makeProviderManager();
        mgr.setApplicationEventPublisher((ApplicationEventPublisher)new MockApplicationEventPublisher(true));
        mgr.authenticate((Authentication)token);
    }

    @Test
    public void authenticationSucceedsWithSupportedTokenAndReturnsExpectedObject() throws Exception {
        TestingAuthenticationToken token = new TestingAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        ProviderManager mgr = this.makeProviderManager();
        mgr.setApplicationEventPublisher((ApplicationEventPublisher)new MockApplicationEventPublisher(true));
        Authentication result = mgr.authenticate((Authentication)token);
        if (!(result instanceof TestingAuthenticationToken)) {
            Assert.fail((String)"Should have returned instance of TestingAuthenticationToken");
        }
        TestingAuthenticationToken castResult = (TestingAuthenticationToken)result;
        Assert.assertEquals((Object)"Test", (Object)castResult.getPrincipal());
        Assert.assertEquals((Object)"Password", (Object)castResult.getCredentials());
        Assert.assertEquals((Object)"ROLE_ONE", (Object)castResult.getAuthorities()[0].getAuthority());
        Assert.assertEquals((Object)"ROLE_TWO", (Object)castResult.getAuthorities()[1].getAuthority());
    }

    @Test
    public void authenticationSuccessWhenFirstProviderReturnsNullButSecondAuthenticates() {
        TestingAuthenticationToken token = new TestingAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        ProviderManager mgr = this.makeProviderManagerWithMockProviderWhichReturnsNullInList();
        mgr.setApplicationEventPublisher((ApplicationEventPublisher)new MockApplicationEventPublisher(true));
        Authentication result = mgr.authenticate((Authentication)token);
        if (!(result instanceof TestingAuthenticationToken)) {
            Assert.fail((String)"Should have returned instance of TestingAuthenticationToken");
        }
        TestingAuthenticationToken castResult = (TestingAuthenticationToken)result;
        Assert.assertEquals((Object)"Test", (Object)castResult.getPrincipal());
        Assert.assertEquals((Object)"Password", (Object)castResult.getCredentials());
        Assert.assertEquals((Object)"ROLE_ONE", (Object)castResult.getAuthorities()[0].getAuthority());
        Assert.assertEquals((Object)"ROLE_TWO", (Object)castResult.getAuthorities()[1].getAuthority());
    }

    @Test
    public void concurrentSessionControllerConfiguration() throws Exception {
        ProviderManager target = new ProviderManager();
        Assert.assertNotNull((Object)target.getSessionController());
        Assert.assertTrue((boolean)(target.getSessionController() instanceof NullConcurrentSessionController));
        ConcurrentSessionControllerImpl impl = new ConcurrentSessionControllerImpl();
        target.setSessionController((ConcurrentSessionController)impl);
        Assert.assertEquals((Object)impl, (Object)target.getSessionController());
    }

    @Test(expected=IllegalArgumentException.class)
    public void startupFailsIfProviderListDoesNotContainProviders() throws Exception {
        Vector<String> providers = new Vector<String>();
        providers.add("THIS_IS_NOT_A_PROVIDER");
        ProviderManager mgr = new ProviderManager();
        mgr.setProviders(providers);
    }

    @Test(expected=IllegalArgumentException.class)
    public void getProvidersFailsIfProviderListNotSet() throws Exception {
        ProviderManager mgr = new ProviderManager();
        mgr.afterPropertiesSet();
        mgr.getProviders();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testStartupFailsIfProviderListNull() throws Exception {
        ProviderManager mgr = new ProviderManager();
        mgr.setProviders(null);
    }

    @Test
    public void detailsAreNotSetOnAuthenticationTokenIfAlreadySetByProvider() throws Exception {
        String requestDetails = "(Request Details)";
        final String resultDetails = "(Result Details)";
        ProviderManager authMgr = this.makeProviderManager();
        AuthenticationProvider provider = new AuthenticationProvider(){

            public Authentication authenticate(Authentication authentication) throws AuthenticationException {
                ((TestingAuthenticationToken)authentication).setDetails(resultDetails);
                return authentication;
            }

            public boolean supports(Class authentication) {
                return true;
            }
        };
        authMgr.setProviders(Arrays.asList(provider));
        TestingAuthenticationToken request = this.createAuthenticationToken();
        request.setDetails(requestDetails);
        Authentication result = authMgr.authenticate((Authentication)request);
        Assert.assertEquals((Object)resultDetails, (Object)result.getDetails());
    }

    @Test
    public void detailsAreSetOnAuthenticationTokenIfNotAlreadySetByProvider() throws Exception {
        Object details = new Object();
        ProviderManager authMgr = this.makeProviderManager();
        TestingAuthenticationToken request = this.createAuthenticationToken();
        request.setDetails(details);
        Authentication result = authMgr.authenticate((Authentication)request);
        Assert.assertEquals((Object)details, (Object)result.getDetails());
    }

    @Test(expected=AccountStatusException.class)
    public void accountStatusExceptionPreventsCallsToSubsequentProviders() throws Exception {
        ProviderManager authMgr = this.makeProviderManager();
        authMgr.setProviders(Arrays.asList(new MockProviderWhichThrowsAccountStatusException(), new MockProviderWhichThrowsConcurrentLoginException()));
        authMgr.authenticate((Authentication)this.createAuthenticationToken());
    }

    @Test(expected=ConcurrentLoginException.class)
    public void concurrentLoginExceptionPreventsCallsToSubsequentProviders() throws Exception {
        ProviderManager authMgr = this.makeProviderManager();
        authMgr.setProviders(Arrays.asList(new MockProviderWhichThrowsConcurrentLoginException(), new MockProviderWhichThrowsAccountStatusException()));
        authMgr.authenticate((Authentication)this.createAuthenticationToken());
    }

    private TestingAuthenticationToken createAuthenticationToken() {
        return new TestingAuthenticationToken((Object)"name", (Object)"password", (GrantedAuthority[])new GrantedAuthorityImpl[0]);
    }

    private ProviderManager makeProviderManager() throws Exception {
        MockProvider provider1 = new MockProvider();
        Vector<MockProvider> providers = new Vector<MockProvider>();
        providers.add(provider1);
        ProviderManager mgr = new ProviderManager();
        mgr.setProviders(providers);
        mgr.afterPropertiesSet();
        return mgr;
    }

    private ProviderManager makeProviderManagerWithMockProviderWhichReturnsNullInList() {
        MockProviderWhichReturnsNull provider1 = new MockProviderWhichReturnsNull();
        MockProvider provider2 = new MockProvider();
        Vector<Object> providers = new Vector<Object>();
        providers.add(provider1);
        providers.add(provider2);
        ProviderManager mgr = new ProviderManager();
        mgr.setProviders(providers);
        return mgr;
    }

    private class MockProviderWhichThrowsConcurrentLoginException
    implements AuthenticationProvider {
        private MockProviderWhichThrowsConcurrentLoginException() {
        }

        public Authentication authenticate(Authentication authentication) throws AuthenticationException {
            throw new ConcurrentLoginException("xxx"){};
        }

        public boolean supports(Class authentication) {
            return true;
        }
    }

    private class MockProviderWhichThrowsAccountStatusException
    implements AuthenticationProvider {
        private MockProviderWhichThrowsAccountStatusException() {
        }

        public Authentication authenticate(Authentication authentication) throws AuthenticationException {
            throw new AccountStatusException("xxx"){};
        }

        public boolean supports(Class authentication) {
            return true;
        }
    }

    private class MockProviderWhichReturnsNull
    implements AuthenticationProvider {
        private MockProviderWhichReturnsNull() {
        }

        public Authentication authenticate(Authentication authentication) throws AuthenticationException {
            if (this.supports(authentication.getClass())) {
                return null;
            }
            throw new AuthenticationServiceException("Don't support this class");
        }

        public boolean supports(Class authentication) {
            return TestingAuthenticationToken.class.isAssignableFrom(authentication);
        }
    }

    private class MockProvider
    implements AuthenticationProvider {
        private MockProvider() {
        }

        public Authentication authenticate(Authentication authentication) throws AuthenticationException {
            if (this.supports(authentication.getClass())) {
                return authentication;
            }
            throw new AuthenticationServiceException("Don't support this class");
        }

        public boolean supports(Class authentication) {
            return TestingAuthenticationToken.class.isAssignableFrom(authentication);
        }
    }
}

