/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.intercept.web;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.intercept.AbstractSecurityInterceptor;
import org.springframework.security.intercept.web.FilterInvocation;
import org.springframework.security.intercept.web.FilterSecurityInterceptor;
import org.springframework.security.intercept.web.WebInvocationPrivilegeEvaluator;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.util.FilterInvocationUtils;

public class WebInvocationPrivilegeEvaluatorTests
extends TestCase {
    public WebInvocationPrivilegeEvaluatorTests() {
    }

    public WebInvocationPrivilegeEvaluatorTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run(WebInvocationPrivilegeEvaluatorTests.class);
    }

    private FilterSecurityInterceptor makeFilterSecurityInterceptor() {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("org/springframework/security/intercept/web/applicationContext.xml");
        return (FilterSecurityInterceptor)context.getBean("securityInterceptor");
    }

    public void testAllowsAccess1() throws Exception {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("MOCK_INDEX")});
        FilterInvocation fi = FilterInvocationUtils.create((String)"/foo/index.jsp");
        FilterSecurityInterceptor interceptor = this.makeFilterSecurityInterceptor();
        WebInvocationPrivilegeEvaluator wipe = new WebInvocationPrivilegeEvaluator();
        wipe.setSecurityInterceptor((AbstractSecurityInterceptor)interceptor);
        wipe.afterPropertiesSet();
        WebInvocationPrivilegeEvaluatorTests.assertTrue((boolean)wipe.isAllowed(fi, (Authentication)token));
    }

    public void testAllowsAccess2() throws Exception {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("MOCK_USER")});
        FilterInvocation fi = FilterInvocationUtils.create((String)"/anything.jsp");
        FilterSecurityInterceptor interceptor = this.makeFilterSecurityInterceptor();
        WebInvocationPrivilegeEvaluator wipe = new WebInvocationPrivilegeEvaluator();
        wipe.setSecurityInterceptor((AbstractSecurityInterceptor)interceptor);
        wipe.afterPropertiesSet();
        WebInvocationPrivilegeEvaluatorTests.assertTrue((boolean)wipe.isAllowed(fi, (Authentication)token));
    }

    public void testDeniesAccess1() throws Exception {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("MOCK_NOTHING_USEFUL")});
        FilterInvocation fi = FilterInvocationUtils.create((String)"/anything.jsp");
        FilterSecurityInterceptor interceptor = this.makeFilterSecurityInterceptor();
        WebInvocationPrivilegeEvaluator wipe = new WebInvocationPrivilegeEvaluator();
        wipe.setSecurityInterceptor((AbstractSecurityInterceptor)interceptor);
        wipe.afterPropertiesSet();
        WebInvocationPrivilegeEvaluatorTests.assertFalse((boolean)wipe.isAllowed(fi, (Authentication)token));
    }
}

