/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.intercept.method;

import java.lang.reflect.Method;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.intercept.method.MapBasedMethodDefinitionSource;

public class MapBasedMethodDefinitionSourceTests {
    private final ConfigAttributeDefinition ROLE_A = new ConfigAttributeDefinition("ROLE_A");
    private final ConfigAttributeDefinition ROLE_B = new ConfigAttributeDefinition("ROLE_B");
    private MapBasedMethodDefinitionSource mds;
    private Method someMethodString;
    private Method someMethodInteger;

    @Before
    public void initialize() throws Exception {
        this.mds = new MapBasedMethodDefinitionSource();
        this.someMethodString = MockService.class.getMethod("someMethod", String.class);
        this.someMethodInteger = MockService.class.getMethod("someMethod", Integer.class);
    }

    @Test
    public void wildcardedMatchIsOverwrittenByMoreSpecificMatch() {
        this.mds.addSecureMethod(MockService.class, "some*", this.ROLE_A);
        this.mds.addSecureMethod(MockService.class, "someMethod*", this.ROLE_B);
        Assert.assertEquals((Object)this.ROLE_B, (Object)this.mds.getAttributes(this.someMethodInteger, MockService.class));
    }

    @Test
    public void methodsWithDifferentArgumentsAreMatchedCorrectly() throws Exception {
        this.mds.addSecureMethod(MockService.class, this.someMethodInteger, this.ROLE_A);
        this.mds.addSecureMethod(MockService.class, this.someMethodString, this.ROLE_B);
        Assert.assertEquals((Object)this.ROLE_A, (Object)this.mds.getAttributes(this.someMethodInteger, MockService.class));
        Assert.assertEquals((Object)this.ROLE_B, (Object)this.mds.getAttributes(this.someMethodString, MockService.class));
    }

    private class MockService {
        private MockService() {
        }

        public void someMethod(String s) {
        }

        public void someMethod(Integer i) {
        }
    }
}

