/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.intercept;

import junit.framework.TestCase;
import org.springframework.security.Authentication;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.intercept.InterceptorStatusToken;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.util.SimpleMethodInvocation;

public class InterceptorStatusTokenTests
extends TestCase {
    public InterceptorStatusTokenTests() {
    }

    public InterceptorStatusTokenTests(String arg0) {
        super(arg0);
    }

    public void testNoArgConstructorDoesntExist() {
        Class<InterceptorStatusToken> clazz = InterceptorStatusToken.class;
        try {
            clazz.getDeclaredConstructor(null);
            InterceptorStatusTokenTests.fail((String)"Should have thrown NoSuchMethodException");
        }
        catch (NoSuchMethodException expected) {
            InterceptorStatusTokenTests.assertTrue((boolean)true);
        }
    }

    public void testOperation() {
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition("FOO");
        SimpleMethodInvocation mi = new SimpleMethodInvocation();
        InterceptorStatusToken token = new InterceptorStatusToken((Authentication)new UsernamePasswordAuthenticationToken((Object)"rod", (Object)"koala"), true, attr, (Object)mi);
        InterceptorStatusTokenTests.assertTrue((boolean)token.isContextHolderRefreshRequired());
        InterceptorStatusTokenTests.assertEquals((Object)attr, (Object)token.getAttr());
        InterceptorStatusTokenTests.assertEquals((Object)mi, (Object)token.getSecureObject());
        InterceptorStatusTokenTests.assertEquals((Object)"rod", (Object)token.getAuthentication().getPrincipal());
    }
}

