/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.intercept;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.MockAccessDecisionManager;
import org.springframework.security.MockAfterInvocationManager;
import org.springframework.security.MockAuthenticationManager;
import org.springframework.security.MockRunAsManager;
import org.springframework.security.intercept.AbstractSecurityInterceptor;
import org.springframework.security.intercept.ObjectDefinitionSource;
import org.springframework.security.intercept.method.MockMethodDefinitionSource;
import org.springframework.security.util.SimpleMethodInvocation;

public class AbstractSecurityInterceptorTests
extends TestCase {
    public AbstractSecurityInterceptorTests() {
    }

    public AbstractSecurityInterceptorTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run(AbstractSecurityInterceptorTests.class);
    }

    public void testDetectsIfInvocationPassedIncompatibleSecureObject() throws Exception {
        MockSecurityInterceptorWhichOnlySupportsStrings si = new MockSecurityInterceptorWhichOnlySupportsStrings();
        si.setRunAsManager(new MockRunAsManager());
        si.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        si.setAfterInvocationManager(new MockAfterInvocationManager());
        si.setAccessDecisionManager(new MockAccessDecisionManager());
        si.setObjectDefinitionSource((ObjectDefinitionSource)new MockMethodDefinitionSource(false, true));
        try {
            si.beforeInvocation(new SimpleMethodInvocation());
            AbstractSecurityInterceptorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AbstractSecurityInterceptorTests.assertTrue((boolean)expected.getMessage().startsWith("Security invocation attempted for object"));
        }
    }

    public void testDetectsViolationOfGetSecureObjectClassMethod() throws Exception {
        MockSecurityInterceptorReturnsNull si = new MockSecurityInterceptorReturnsNull();
        si.setRunAsManager(new MockRunAsManager());
        si.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        si.setAfterInvocationManager(new MockAfterInvocationManager());
        si.setAccessDecisionManager(new MockAccessDecisionManager());
        si.setObjectDefinitionSource((ObjectDefinitionSource)new MockMethodDefinitionSource(false, true));
        try {
            si.afterPropertiesSet();
            AbstractSecurityInterceptorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AbstractSecurityInterceptorTests.assertEquals((String)"Subclass must provide a non-null response to getSecureObjectClass()", (String)expected.getMessage());
        }
    }

    private class MockSecurityInterceptorWhichOnlySupportsStrings
    extends AbstractSecurityInterceptor {
        private ObjectDefinitionSource objectDefinitionSource;

        private MockSecurityInterceptorWhichOnlySupportsStrings() {
        }

        public Class getSecureObjectClass() {
            return String.class;
        }

        public ObjectDefinitionSource obtainObjectDefinitionSource() {
            return this.objectDefinitionSource;
        }

        public void setObjectDefinitionSource(ObjectDefinitionSource objectDefinitionSource) {
            this.objectDefinitionSource = objectDefinitionSource;
        }
    }

    private class MockSecurityInterceptorReturnsNull
    extends AbstractSecurityInterceptor {
        private ObjectDefinitionSource objectDefinitionSource;

        private MockSecurityInterceptorReturnsNull() {
        }

        public Class getSecureObjectClass() {
            return null;
        }

        public ObjectDefinitionSource obtainObjectDefinitionSource() {
            return this.objectDefinitionSource;
        }

        public void setObjectDefinitionSource(ObjectDefinitionSource objectDefinitionSource) {
            this.objectDefinitionSource = objectDefinitionSource;
        }
    }
}

