/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.concurrent;

import java.util.Date;
import javax.servlet.http.HttpSession;
import junit.framework.TestCase;
import org.springframework.context.ApplicationEvent;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.security.concurrent.SessionInformation;
import org.springframework.security.concurrent.SessionRegistryImpl;
import org.springframework.security.ui.session.HttpSessionDestroyedEvent;

public class SessionRegistryImplTests
extends TestCase {
    private SessionRegistryImpl sessionRegistry;

    protected void setUp() throws Exception {
        this.sessionRegistry = new SessionRegistryImpl();
    }

    public void testEventPublishing() {
        MockHttpSession httpSession = new MockHttpSession();
        String principal = "Some principal object";
        String sessionId = httpSession.getId();
        SessionRegistryImplTests.assertNotNull((Object)sessionId);
        this.sessionRegistry.registerNewSession(sessionId, (Object)principal);
        this.sessionRegistry.onApplicationEvent((ApplicationEvent)new HttpSessionDestroyedEvent((HttpSession)httpSession));
        SessionRegistryImplTests.assertNull((Object)this.sessionRegistry.getSessionInformation(sessionId));
    }

    public void testMultiplePrincipals() throws Exception {
        String principal1 = "principal_1";
        String principal2 = "principal_2";
        String sessionId1 = "1234567890";
        String sessionId2 = "9876543210";
        String sessionId3 = "5432109876";
        this.sessionRegistry.registerNewSession(sessionId1, (Object)principal1);
        this.sessionRegistry.registerNewSession(sessionId2, (Object)principal1);
        this.sessionRegistry.registerNewSession(sessionId3, (Object)principal2);
        SessionRegistryImplTests.assertEquals((Object)principal1, (Object)this.sessionRegistry.getAllPrincipals()[0]);
        SessionRegistryImplTests.assertEquals((Object)principal2, (Object)this.sessionRegistry.getAllPrincipals()[1]);
    }

    public void testSessionInformationLifecycle() throws Exception {
        String principal = "Some principal object";
        String sessionId = "1234567890";
        this.sessionRegistry.registerNewSession(sessionId, (Object)principal);
        Date currentDateTime = this.sessionRegistry.getSessionInformation(sessionId).getLastRequest();
        SessionRegistryImplTests.assertEquals((Object)principal, (Object)this.sessionRegistry.getSessionInformation(sessionId).getPrincipal());
        SessionRegistryImplTests.assertEquals((String)sessionId, (String)this.sessionRegistry.getSessionInformation(sessionId).getSessionId());
        SessionRegistryImplTests.assertNotNull((Object)this.sessionRegistry.getSessionInformation(sessionId).getLastRequest());
        SessionRegistryImplTests.assertEquals((int)1, (int)this.sessionRegistry.getAllSessions((Object)principal, false).length);
        Thread.sleep(1000L);
        this.sessionRegistry.refreshLastRequest(sessionId);
        Date retrieved = this.sessionRegistry.getSessionInformation(sessionId).getLastRequest();
        SessionRegistryImplTests.assertTrue((boolean)retrieved.after(currentDateTime));
        SessionRegistryImplTests.assertEquals((Object)retrieved, (Object)this.sessionRegistry.getAllSessions((Object)principal, false)[0].getLastRequest());
        this.sessionRegistry.removeSessionInformation(sessionId);
        SessionRegistryImplTests.assertNull((Object)this.sessionRegistry.getSessionInformation(sessionId));
        SessionRegistryImplTests.assertNull((Object)this.sessionRegistry.getAllSessions((Object)principal, false));
    }

    public void testTwoSessionsOnePrincipalExpiring() throws Exception {
        String principal = "Some principal object";
        String sessionId1 = "1234567890";
        String sessionId2 = "9876543210";
        this.sessionRegistry.registerNewSession(sessionId1, (Object)principal);
        SessionInformation[] sessions = this.sessionRegistry.getAllSessions((Object)principal, false);
        SessionRegistryImplTests.assertEquals((int)1, (int)sessions.length);
        SessionRegistryImplTests.assertTrue((boolean)this.contains(sessionId1, principal));
        this.sessionRegistry.registerNewSession(sessionId2, (Object)principal);
        sessions = this.sessionRegistry.getAllSessions((Object)principal, false);
        SessionRegistryImplTests.assertEquals((int)2, (int)sessions.length);
        SessionRegistryImplTests.assertTrue((boolean)this.contains(sessionId2, principal));
        SessionInformation session = this.sessionRegistry.getSessionInformation(sessionId2);
        session.expireNow();
        SessionRegistryImplTests.assertTrue((boolean)this.sessionRegistry.getSessionInformation(sessionId2).isExpired());
        SessionRegistryImplTests.assertFalse((boolean)this.sessionRegistry.getSessionInformation(sessionId1).isExpired());
    }

    public void testTwoSessionsOnePrincipalHandling() throws Exception {
        String principal = "Some principal object";
        String sessionId1 = "1234567890";
        String sessionId2 = "9876543210";
        this.sessionRegistry.registerNewSession(sessionId1, (Object)principal);
        SessionInformation[] sessions = this.sessionRegistry.getAllSessions((Object)principal, false);
        SessionRegistryImplTests.assertEquals((int)1, (int)sessions.length);
        SessionRegistryImplTests.assertTrue((boolean)this.contains(sessionId1, principal));
        this.sessionRegistry.registerNewSession(sessionId2, (Object)principal);
        sessions = this.sessionRegistry.getAllSessions((Object)principal, false);
        SessionRegistryImplTests.assertEquals((int)2, (int)sessions.length);
        SessionRegistryImplTests.assertTrue((boolean)this.contains(sessionId2, principal));
        this.sessionRegistry.removeSessionInformation(sessionId1);
        sessions = this.sessionRegistry.getAllSessions((Object)principal, false);
        SessionRegistryImplTests.assertEquals((int)1, (int)sessions.length);
        SessionRegistryImplTests.assertTrue((boolean)this.contains(sessionId2, principal));
        this.sessionRegistry.removeSessionInformation(sessionId2);
        SessionRegistryImplTests.assertNull((Object)this.sessionRegistry.getSessionInformation(sessionId2));
        SessionRegistryImplTests.assertNull((Object)this.sessionRegistry.getAllSessions((Object)principal, false));
    }

    boolean contains(String sessionId, Object principal) {
        SessionInformation[] info = this.sessionRegistry.getAllSessions(principal, false);
        for (int i = 0; i < info.length; ++i) {
            if (!sessionId.equals(info[i].getSessionId())) continue;
            return true;
        }
        return false;
    }
}

