/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authoritymapping;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.springframework.security.authoritymapping.XmlMappableAttributesRetriever;

public class XmlMappableRolesRetrieverTests
extends TestCase {
    private static final String DEFAULT_XML = "<roles><role>Role1</role><role>Role2</role></roles>";
    private static final String DEFAULT_XPATH = "/roles/role/text()";
    private static final String[] DEFAULT_EXPECTED_ROLES = new String[]{"Role1", "Role2"};

    public final void testAfterPropertiesSetException() {
        TestXmlMappableAttributesRetriever t = new TestXmlMappableAttributesRetriever();
        try {
            t.afterPropertiesSet();
            XmlMappableRolesRetrieverTests.fail((String)"AfterPropertiesSet didn't throw expected exception");
        }
        catch (IllegalArgumentException expected) {
        }
        catch (Exception unexpected) {
            XmlMappableRolesRetrieverTests.fail((String)"AfterPropertiesSet throws unexpected exception");
        }
    }

    public void testGetMappableRoles() {
        XmlMappableAttributesRetriever r = this.getXmlMappableRolesRetriever(true, this.getDefaultInputStream(), DEFAULT_XPATH);
        String[] resultRoles = r.getMappableAttributes();
        XmlMappableRolesRetrieverTests.assertNotNull((String)"Result roles should not be null", (Object)resultRoles);
        XmlMappableRolesRetrieverTests.assertTrue((String)"Number of result roles doesn't match expected number of roles", (resultRoles.length == DEFAULT_EXPECTED_ROLES.length ? 1 : 0) != 0);
        List<String> resultRolesColl = Arrays.asList(resultRoles);
        List<String> expectedRolesColl = Arrays.asList(DEFAULT_EXPECTED_ROLES);
        XmlMappableRolesRetrieverTests.assertTrue((String)"Role collections do not match", (expectedRolesColl.containsAll(resultRolesColl) && resultRolesColl.containsAll(expectedRolesColl) ? 1 : 0) != 0);
    }

    public void testCloseInputStream() {
        this.testCloseInputStream(true);
    }

    public void testDontCloseInputStream() {
        this.testCloseInputStream(false);
    }

    private void testCloseInputStream(boolean closeAfterRead) {
        CloseableByteArrayInputStream is = this.getDefaultInputStream();
        XmlMappableAttributesRetriever r = this.getXmlMappableRolesRetriever(closeAfterRead, is, DEFAULT_XPATH);
        r.getMappableAttributes();
        XmlMappableRolesRetrieverTests.assertEquals((boolean)is.isClosed(), (boolean)closeAfterRead);
    }

    private XmlMappableAttributesRetriever getXmlMappableRolesRetriever(boolean closeInputStream, InputStream is, String xpath) {
        TestXmlMappableAttributesRetriever result = new TestXmlMappableAttributesRetriever();
        result.setCloseInputStream(closeInputStream);
        result.setXmlInputStream(is);
        result.setXpathExpression(xpath);
        try {
            result.afterPropertiesSet();
        }
        catch (Exception e) {
            XmlMappableRolesRetrieverTests.fail((String)("Unexpected exception" + e.toString()));
        }
        return result;
    }

    private CloseableByteArrayInputStream getDefaultInputStream() {
        return this.getInputStream(DEFAULT_XML);
    }

    private CloseableByteArrayInputStream getInputStream(String data) {
        return new CloseableByteArrayInputStream(data.getBytes());
    }

    private static final class CloseableByteArrayInputStream
    extends ByteArrayInputStream {
        private boolean closed = false;

        public CloseableByteArrayInputStream(byte[] buf) {
            super(buf);
        }

        public void close() throws IOException {
            super.close();
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }
    }

    private static final class TestXmlMappableAttributesRetriever
    extends XmlMappableAttributesRetriever {
        private TestXmlMappableAttributesRetriever() {
        }
    }
}

