/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.io.BufferedOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.maven.surefire.report.AbstractReporter;
import org.apache.maven.surefire.report.ReportEntry;

public class DetailedConsoleReporter
extends AbstractReporter {
    private static final int BUFFER_SIZE = 4096;
    private PrintWriter writer;
    private StringBuffer reportContent;
    private long batteryStartTime;
    String newLine = System.getProperty("line.separator");

    public DetailedConsoleReporter() {
        this.writer = new PrintWriter(new OutputStreamWriter(new BufferedOutputStream(System.out, 4096)));
    }

    public void writeMessage(String message) {
        this.writer.println(message);
        this.writer.flush();
    }

    public void runStarting(int testCount) {
        this.writer.println();
        this.writer.println("-------------------------------------------------------");
        this.writer.println(" T E S T S");
        this.writer.println("-------------------------------------------------------");
        this.writer.flush();
    }

    public void batteryStarting(ReportEntry report) throws Exception {
        this.batteryStartTime = System.currentTimeMillis();
        this.reportContent = new StringBuffer();
        this.writer.println("[surefire] Running " + report.getName());
    }

    public void batteryCompleted(ReportEntry report) {
        long runTime = System.currentTimeMillis() - this.batteryStartTime;
        StringBuffer batterySummary = new StringBuffer();
        batterySummary.append("[surefire] Tests run: " + String.valueOf(this.getNbTests())).append(", Failures: " + String.valueOf(this.getNbFailures())).append(", Errors: " + String.valueOf(this.getNbErrors())).append(", Time elapsed: " + this.elapsedTimeAsString(runTime)).append(" sec").append(this.newLine).append("[surefire] " + this.newLine);
        this.reportContent = batterySummary.append(this.reportContent);
        this.writer.println(this.reportContent.toString());
        this.writer.flush();
    }

    public void testStarting(ReportEntry report) {
        super.testStarting(report);
        this.reportContent.append("[surefire] " + report.getName());
    }

    public void testSucceeded(ReportEntry report) {
        super.testSucceeded(report);
        long runTime = this.endTime - this.startTime;
        this.writeTimeElapsed(runTime);
        this.reportContent.append(this.newLine);
    }

    public void testError(ReportEntry report, String stdOut, String stdErr) {
        super.testError(report, stdOut, stdErr);
        long runTime = this.endTime - this.startTime;
        this.writeTimeElapsed(runTime);
        this.reportContent.append("  <<< ERROR!" + this.newLine);
        this.reportContent.append(this.getStackTrace(report) + this.newLine);
    }

    public void testFailed(ReportEntry report, String stdOut, String stdErr) {
        super.testFailed(report, stdOut, stdErr);
        long runTime = this.endTime - this.startTime;
        this.writeTimeElapsed(runTime);
        this.reportContent.append("  <<< FAILURE!" + this.newLine);
        this.reportContent.append(this.getStackTrace(report) + this.newLine);
    }

    public void dispose() {
        this.errors = 0;
        this.failures = 0;
        this.completedCount = 0;
    }

    private void writeTimeElapsed(long sec) {
        this.reportContent.append("  Time elapsed: " + this.elapsedTimeAsString(sec) + " sec");
    }

    private String getStackTrace(ReportEntry report) {
        StringWriter writer = new StringWriter();
        report.getThrowable().printStackTrace(new PrintWriter(writer));
        writer.flush();
        return writer.toString();
    }
}

