/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.util;

import com.jaspersoft.jasperserver.export.Parameters;
import com.jaspersoft.jasperserver.export.ParametersImpl;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommandUtils {
    public static final String ARG_PREFIX = "--";
    public static final int ARG_PREFIX_LEGTH = "--".length();
    public static final char ARG_VALUE_SEPARATOR = '=';
    public static final String VALUES_SEPARATORS = System.getProperty("path.separator") + ",";
    public static final String SPRING_CONFIG_ARG = "--configResources";
    public static final String SPRING_CONFIG_FILE = "ApplicationContext";
    protected static final Log log = LogFactory.getLog(CommandUtils.class);

    public static Parameters parse(String[] inArgs) {
        ParametersImpl params = new ParametersImpl();
        String[] args = CommandUtils.preParse(inArgs);
        for (int i = 1; i < args.length; ++i) {
            String argn;
            int j;
            String value;
            String param;
            String arg = args[i];
            if (!arg.startsWith(ARG_PREFIX) || arg.length() <= ARG_PREFIX_LEGTH) continue;
            int sepIdx = arg.indexOf(61);
            if (sepIdx >= 0) {
                param = arg.substring(ARG_PREFIX_LEGTH, sepIdx);
                value = arg.substring(sepIdx + 1);
            } else {
                param = arg.substring(ARG_PREFIX_LEGTH);
                value = null;
            }
            params.addParameter(param);
            if (value != null) {
                CommandUtils.addParameterValues(params, param, value);
            }
            for (j = i + 1; j < args.length && !(argn = args[j]).startsWith(ARG_PREFIX); ++j) {
                CommandUtils.addParameterValues(params, param, argn);
            }
            i = j - 1;
        }
        return params;
    }

    protected static String[] preParse(String[] args) {
        return CommandUtils.breakParms(CommandUtils.checkSpringConfigs(args));
    }

    protected static String[] checkSpringConfigs(String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].indexOf(SPRING_CONFIG_ARG) >= 0) {
                if (args[i].indexOf(SPRING_CONFIG_FILE) < 0) {
                    list.add(CommandUtils.getSpringFiles(args[i]));
                    continue;
                }
                list.add(args[i]);
                continue;
            }
            list.add(args[i]);
        }
        return list.toArray(new String[list.size()]);
    }

    protected static String getSpringFiles(String arg) {
        return arg;
    }

    protected static String[] breakParms(String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            int last;
            int first = args[i].indexOf(ARG_PREFIX);
            if (first < (last = args[i].lastIndexOf(ARG_PREFIX))) {
                StringTokenizer tok = new StringTokenizer(args[i]);
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken();
                    list.add(token);
                }
                continue;
            }
            if (first == last) {
                list.add(args[i]);
                continue;
            }
            log.error((Object)("ERROR: an argument string should always have an ARG_PREFIX (--) arg=" + args[i]));
        }
        return list.toArray(new String[list.size()]);
    }

    protected static void addParameterValues(ParametersImpl params, String param, String argn) {
        StringTokenizer tok = new StringTokenizer(argn, VALUES_SEPARATORS);
        while (tok.hasMoreTokens()) {
            String value = tok.nextToken();
            params.addParameterValue(param, value);
        }
    }
}

