/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.irplugin.wsclient;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.activation.DataSource;

public class MonitoredDataSource
implements DataSource {
    private final DataSource dataSource;
    private final Map openInputStreams = new HashMap();

    public MonitoredDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getContentType() {
        return this.dataSource.getContentType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        InputStream stream = this.dataSource.getInputStream();
        if (stream == null) {
            return stream;
        }
        Map map = this.openInputStreams;
        synchronized (map) {
            InputStream monitored = (InputStream)this.openInputStreams.get(stream);
            if (monitored == null) {
                monitored = new MonitoredInputStream(stream);
                this.openInputStreams.put(stream, monitored);
            }
            return monitored;
        }
    }

    public String getName() {
        return this.dataSource.getName();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.dataSource.getOutputStream();
    }

    protected void closingInputStream(InputStream stream) {
        this.openInputStreams.remove(stream);
    }

    public void close() {
        if (!this.openInputStreams.isEmpty()) {
            for (InputStream stream : this.openInputStreams.keySet()) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected class MonitoredInputStream
    extends FilterInputStream {
        public MonitoredInputStream(InputStream in) {
            super(in);
        }

        public void close() throws IOException {
            MonitoredDataSource.this.closingInputStream(this.in);
            super.close();
        }
    }
}

