/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.artifact.filter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.shared.artifact.filter.StatisticsReportingArtifactFilter;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;

public class PatternIncludesArtifactFilter
implements ArtifactFilter,
StatisticsReportingArtifactFilter {
    private final List positivePatterns;
    private final List negativePatterns;
    private final boolean actTransitively;
    private Set patternsTriggered = new HashSet();
    private List filteredArtifactIds = new ArrayList();

    public PatternIncludesArtifactFilter(List patterns) {
        this(patterns, false);
    }

    public PatternIncludesArtifactFilter(List patterns, boolean actTransitively) {
        this.actTransitively = actTransitively;
        ArrayList<String> pos = new ArrayList<String>();
        ArrayList<String> neg = new ArrayList<String>();
        if (patterns != null && !patterns.isEmpty()) {
            Iterator it = patterns.iterator();
            while (it.hasNext()) {
                String pattern = (String)it.next();
                if (pattern.startsWith("!")) {
                    neg.add(pattern.substring(1));
                    continue;
                }
                pos.add(pattern);
            }
        }
        this.positivePatterns = pos;
        this.negativePatterns = neg;
    }

    public boolean include(Artifact artifact) {
        boolean shouldInclude = this.patternMatches(artifact);
        if (!shouldInclude) {
            this.addFilteredArtifactId(artifact.getId());
        }
        return shouldInclude;
    }

    protected boolean patternMatches(Artifact artifact) {
        return this.positiveMatch(artifact) == Boolean.TRUE || this.negativeMatch(artifact) == Boolean.FALSE;
    }

    protected void addFilteredArtifactId(String artifactId) {
        this.filteredArtifactIds.add(artifactId);
    }

    private Boolean negativeMatch(Artifact artifact) {
        if (this.negativePatterns == null || this.negativePatterns.isEmpty()) {
            return null;
        }
        return this.match(artifact, this.negativePatterns);
    }

    protected Boolean positiveMatch(Artifact artifact) {
        if (this.positivePatterns == null || this.positivePatterns.isEmpty()) {
            return null;
        }
        return this.match(artifact, this.positivePatterns);
    }

    private boolean match(Artifact artifact, List patterns) {
        List depTrail;
        String shortId = ArtifactUtils.versionlessKey((Artifact)artifact);
        String id = artifact.getDependencyConflictId();
        String wholeId = artifact.getId();
        if (this.matchAgainst(wholeId, patterns, false)) {
            return true;
        }
        if (this.matchAgainst(id, patterns, false)) {
            return true;
        }
        if (this.matchAgainst(shortId, patterns, false)) {
            return true;
        }
        if (this.actTransitively && (depTrail = artifact.getDependencyTrail()) != null && !depTrail.isEmpty()) {
            String trailStr = "," + StringUtils.join(depTrail.iterator(), (String)",");
            return this.matchAgainst(trailStr, patterns, true);
        }
        return false;
    }

    private boolean matchAgainst(String value, List patterns, boolean regionMatch) {
        Iterator i = patterns.iterator();
        while (i.hasNext()) {
            String pattern = (String)i.next();
            if (regionMatch && pattern.indexOf(42) > -1) continue;
            if (regionMatch) {
                if (value.indexOf(pattern) > -1) {
                    this.patternsTriggered.add(pattern);
                    return true;
                }
            } else if (value.equals(pattern)) {
                this.patternsTriggered.add(pattern);
                return true;
            }
            if (pattern.indexOf(42) <= -1) continue;
            String[] subPatterns = pattern.split("\\*");
            int[] idxes = new int[subPatterns.length];
            for (int j = 0; j < subPatterns.length; ++j) {
                String subPattern = subPatterns[j];
                if (subPattern == null || subPattern.length() < 1) {
                    idxes[j] = j == 0 ? 0 : idxes[j - 1];
                    continue;
                }
                int lastIdx = j == 0 ? 0 : idxes[j - 1];
                idxes[j] = value.indexOf(subPattern, lastIdx);
                if (idxes[j] < 0) continue;
                this.patternsTriggered.add(pattern);
                return true;
            }
        }
        return false;
    }

    public void reportMissedCriteria(Logger logger) {
        if (!this.positivePatterns.isEmpty() || !this.negativePatterns.isEmpty()) {
            ArrayList missed = new ArrayList();
            missed.addAll(this.positivePatterns);
            missed.addAll(this.negativePatterns);
            missed.removeAll(this.patternsTriggered);
            if (!missed.isEmpty() && logger.isWarnEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("The following patterns were never triggered in this ");
                buffer.append(this.getFilterDescription());
                buffer.append(':');
                Iterator it = missed.iterator();
                while (it.hasNext()) {
                    String pattern = (String)it.next();
                    buffer.append("\no  '").append(pattern).append("'");
                }
                buffer.append("\n");
                logger.warn(buffer.toString());
            }
        }
    }

    public String toString() {
        return "Includes filter:" + this.getPatternsAsString();
    }

    protected String getPatternsAsString() {
        StringBuffer buffer = new StringBuffer();
        Iterator it = this.positivePatterns.iterator();
        while (it.hasNext()) {
            String pattern = (String)it.next();
            buffer.append("\no '").append(pattern).append("'");
        }
        return buffer.toString();
    }

    protected String getFilterDescription() {
        return "artifact inclusion filter";
    }

    public void reportFilteredArtifacts(Logger logger) {
        if (!this.filteredArtifactIds.isEmpty() && logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer("The following artifacts were removed by this " + this.getFilterDescription() + ": ");
            Iterator it = this.filteredArtifactIds.iterator();
            while (it.hasNext()) {
                String artifactId = (String)it.next();
                buffer.append('\n').append(artifactId);
            }
            logger.debug(buffer.toString());
        }
    }

    public boolean hasMissedCriteria() {
        if (!this.positivePatterns.isEmpty() || !this.negativePatterns.isEmpty()) {
            ArrayList missed = new ArrayList();
            missed.addAll(this.positivePatterns);
            missed.addAll(this.negativePatterns);
            missed.removeAll(this.patternsTriggered);
            return !missed.isEmpty();
        }
        return false;
    }
}

