/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.PolicyQualifierInfo;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralSubtree;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.NameConstraints;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.provider.PKIXPolicyNode;

public class PKIXCertPathValidatorSpi
extends CertPathValidatorSpi {
    private static final String CERTIFICATE_POLICIES = X509Extensions.CertificatePolicies.getId();
    private static final String POLICY_MAPPINGS = X509Extensions.PolicyMappings.getId();
    private static final String INHIBIT_ANY_POLICY = X509Extensions.InhibitAnyPolicy.getId();
    private static final String ISSUING_DISTRIBUTION_POINT = X509Extensions.IssuingDistributionPoint.getId();
    private static final String DELTA_CRL_INDICATOR = X509Extensions.DeltaCRLIndicator.getId();
    private static final String POLICY_CONSTRAINTS = X509Extensions.PolicyConstraints.getId();
    private static final String BASIC_CONSTRAINTS = X509Extensions.BasicConstraints.getId();
    private static final String SUBJECT_ALTERNATIVE_NAME = X509Extensions.SubjectAlternativeName.getId();
    private static final String NAME_CONSTRAINTS = X509Extensions.NameConstraints.getId();
    private static final String KEY_USAGE = X509Extensions.KeyUsage.getId();
    private static final String CRL_NUMBER = X509Extensions.CRLNumber.getId();
    private static final String ANY_POLICY = "2.5.29.32.0";
    private static final int KEY_CERT_SIGN = 5;
    private static final int CRL_SIGN = 6;

    private DERObject getExtensionValue(X509Extension x509Extension, String string) throws CertPathValidatorException {
        byte[] byArray = x509Extension.getExtensionValue(string);
        if (byArray == null) {
            return null;
        }
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(byArray));
            ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1InputStream.readObject();
            aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(aSN1OctetString.getOctets()));
            return aSN1InputStream.readObject();
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException("exception processing extension " + string);
        }
    }

    private boolean withinDNSubtree(ASN1Sequence aSN1Sequence, ASN1Sequence aSN1Sequence2) {
        if (aSN1Sequence2.size() < 1) {
            return false;
        }
        if (aSN1Sequence2.size() > aSN1Sequence.size()) {
            return false;
        }
        int n = aSN1Sequence2.size() - 1;
        while (n >= 0) {
            if (!aSN1Sequence2.getObjectAt(n).equals(aSN1Sequence.getObjectAt(n))) {
                return false;
            }
            --n;
        }
        return true;
    }

    private void checkPermittedDN(HashSet hashSet, ASN1Sequence aSN1Sequence) throws CertPathValidatorException {
        if (hashSet.isEmpty()) {
            return;
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)iterator.next();
            if (!this.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) continue;
            return;
        }
        throw new CertPathValidatorException("Subject distinguished name is not from a permitted subtree");
    }

    private void checkExcludedDN(HashSet hashSet, ASN1Sequence aSN1Sequence) throws CertPathValidatorException {
        if (hashSet.isEmpty()) {
            return;
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)iterator.next();
            if (!this.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) continue;
            throw new CertPathValidatorException("Subject distinguished name is from an excluded subtree");
        }
    }

    private HashSet intersectDN(HashSet hashSet, ASN1Sequence aSN1Sequence) {
        if (hashSet.isEmpty()) {
            hashSet.add(aSN1Sequence);
            return hashSet;
        }
        HashSet<ASN1Sequence> hashSet2 = new HashSet<ASN1Sequence>();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)iterator.next();
            if (this.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) {
                hashSet2.add(aSN1Sequence);
                continue;
            }
            if (!this.withinDNSubtree(aSN1Sequence2, aSN1Sequence)) continue;
            hashSet2.add(aSN1Sequence2);
        }
        return hashSet2;
    }

    private HashSet unionDN(HashSet hashSet, ASN1Sequence aSN1Sequence) {
        if (hashSet.isEmpty()) {
            hashSet.add(aSN1Sequence);
            return hashSet;
        }
        HashSet<ASN1Sequence> hashSet2 = new HashSet<ASN1Sequence>();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)iterator.next();
            if (this.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) {
                hashSet2.add(aSN1Sequence2);
                continue;
            }
            if (this.withinDNSubtree(aSN1Sequence2, aSN1Sequence)) {
                hashSet2.add(aSN1Sequence);
                continue;
            }
            hashSet2.add(aSN1Sequence2);
            hashSet2.add(aSN1Sequence);
        }
        return hashSet2;
    }

    private HashSet intersectEmail(HashSet hashSet, String string) {
        String string2 = string.substring(string.indexOf(64) + 1);
        if (hashSet.isEmpty()) {
            hashSet.add(string2);
            return hashSet;
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (string2.endsWith(string3)) {
                hashSet2.add(string2);
                continue;
            }
            if (!string3.endsWith(string2)) continue;
            hashSet2.add(string3);
        }
        return hashSet2;
    }

    private HashSet unionEmail(HashSet hashSet, String string) {
        String string2 = string.substring(string.indexOf(64) + 1);
        if (hashSet.isEmpty()) {
            hashSet.add(string2);
            return hashSet;
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (string2.endsWith(string3)) {
                hashSet2.add(string3);
                continue;
            }
            if (string3.endsWith(string2)) {
                hashSet2.add(string2);
                continue;
            }
            hashSet2.add(string3);
            hashSet2.add(string2);
        }
        return hashSet2;
    }

    private HashSet intersectIP(HashSet hashSet, byte[] byArray) {
        return hashSet;
    }

    private HashSet unionIP(HashSet hashSet, byte[] byArray) {
        return hashSet;
    }

    private void checkPermittedEmail(HashSet hashSet, String string) throws CertPathValidatorException {
        if (hashSet.isEmpty()) {
            return;
        }
        String string2 = string.substring(string.indexOf(64) + 1);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!string2.endsWith(string3)) continue;
            return;
        }
        throw new CertPathValidatorException("Subject email address is not from a permitted subtree");
    }

    private void checkExcludedEmail(HashSet hashSet, String string) throws CertPathValidatorException {
        if (hashSet.isEmpty()) {
            return;
        }
        String string2 = string.substring(string.indexOf(64) + 1);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!string2.endsWith(string3)) continue;
            throw new CertPathValidatorException("Subject email address is from an excluded subtree");
        }
    }

    private void checkPermittedIP(HashSet hashSet, byte[] byArray) throws CertPathValidatorException {
        if (hashSet.isEmpty()) {
            return;
        }
    }

    private void checkExcludedIP(HashSet hashSet, byte[] byArray) throws CertPathValidatorException {
        if (hashSet.isEmpty()) {
            return;
        }
    }

    private PKIXPolicyNode removePolicyNode(PKIXPolicyNode pKIXPolicyNode, ArrayList[] arrayListArray, PKIXPolicyNode pKIXPolicyNode2) {
        PKIXPolicyNode pKIXPolicyNode3 = (PKIXPolicyNode)pKIXPolicyNode2.getParent();
        if (pKIXPolicyNode == null) {
            return null;
        }
        if (pKIXPolicyNode3 == null) {
            int n = 0;
            while (n < arrayListArray.length) {
                arrayListArray[n] = new ArrayList();
                ++n;
            }
            return null;
        }
        pKIXPolicyNode3.removeChild(pKIXPolicyNode2);
        this.removePolicyNodeRecurse(arrayListArray, pKIXPolicyNode2);
        return pKIXPolicyNode;
    }

    private void removePolicyNodeRecurse(ArrayList[] arrayListArray, PKIXPolicyNode pKIXPolicyNode) {
        arrayListArray[pKIXPolicyNode.getDepth()].remove(pKIXPolicyNode);
        if (pKIXPolicyNode.hasChildren()) {
            Iterator iterator = pKIXPolicyNode.getChildren();
            while (iterator.hasNext()) {
                PKIXPolicyNode pKIXPolicyNode2 = (PKIXPolicyNode)iterator.next();
                this.removePolicyNodeRecurse(arrayListArray, pKIXPolicyNode2);
            }
        }
    }

    private boolean isSelfIssued(X509Certificate x509Certificate) {
        return x509Certificate.getSubjectDN().equals(x509Certificate.getIssuerDN());
    }

    private boolean isAnyPolicy(Set set) {
        return set.contains(ANY_POLICY) || set.size() == 0;
    }

    private AlgorithmIdentifier getAlgorithmIdentifier(PublicKey publicKey) throws CertPathValidatorException {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(publicKey.getEncoded()));
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(aSN1InputStream.readObject());
            return subjectPublicKeyInfo.getAlgorithmId();
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException("exception processing public key");
        }
    }

    private final Set getQualifierSet(ASN1Sequence aSN1Sequence) throws CertPathValidatorException {
        HashSet<PolicyQualifierInfo> hashSet = new HashSet<PolicyQualifierInfo>();
        if (aSN1Sequence == null) {
            return hashSet;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            try {
                aSN1OutputStream.writeObject(enumeration.nextElement());
                hashSet.add(new PolicyQualifierInfo(byteArrayOutputStream.toByteArray()));
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("exception building qualifier set: " + iOException);
            }
            byteArrayOutputStream.reset();
        }
        return hashSet;
    }

    private boolean processCertD1i(int n, ArrayList[] arrayListArray, DERObjectIdentifier dERObjectIdentifier, Set set) {
        ArrayList arrayList = arrayListArray[n - 1];
        int n2 = 0;
        while (n2 < arrayList.size()) {
            PKIXPolicyNode pKIXPolicyNode = (PKIXPolicyNode)arrayList.get(n2);
            Set set2 = pKIXPolicyNode.getExpectedPolicies();
            if (set2.contains(dERObjectIdentifier.getId())) {
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.add(dERObjectIdentifier.getId());
                PKIXPolicyNode pKIXPolicyNode2 = new PKIXPolicyNode(new ArrayList(), n, hashSet, pKIXPolicyNode, set, dERObjectIdentifier.getId(), false);
                pKIXPolicyNode.addChild(pKIXPolicyNode2);
                arrayListArray[n].add(pKIXPolicyNode2);
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void processCertD1ii(int n, ArrayList[] arrayListArray, DERObjectIdentifier dERObjectIdentifier, Set set) {
        ArrayList arrayList = arrayListArray[n - 1];
        int n2 = 0;
        while (n2 < arrayList.size()) {
            PKIXPolicyNode pKIXPolicyNode = (PKIXPolicyNode)arrayList.get(n2);
            Set set2 = pKIXPolicyNode.getExpectedPolicies();
            if (ANY_POLICY.equals(pKIXPolicyNode.getValidPolicy())) {
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.add(dERObjectIdentifier.getId());
                PKIXPolicyNode pKIXPolicyNode2 = new PKIXPolicyNode(new ArrayList(), n, hashSet, pKIXPolicyNode, set, dERObjectIdentifier.getId(), false);
                pKIXPolicyNode.addChild(pKIXPolicyNode2);
                arrayListArray[n].add(pKIXPolicyNode2);
                return;
            }
            ++n2;
        }
    }

    public CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters certPathParameters) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        Iterator<PKIXCertPathChecker> iterator;
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Iterator iterator2;
        PublicKey publicKey;
        X500Principal x500Principal;
        if (!(certPathParameters instanceof PKIXParameters)) {
            throw new InvalidAlgorithmParameterException("params must be a PKIXParameters instance");
        }
        PKIXParameters pKIXParameters = (PKIXParameters)certPathParameters;
        if (pKIXParameters.getTrustAnchors() == null) {
            throw new InvalidAlgorithmParameterException("trustAnchors is null, this is not allowed for path validation");
        }
        List<? extends Certificate> list = certPath.getCertificates();
        int n2 = list.size();
        if (list.isEmpty()) {
            throw new CertPathValidatorException("CertPath is empty", null, certPath, 0);
        }
        Date date = pKIXParameters.getDate();
        if (date == null) {
            date = new Date();
        }
        Set<String> set = pKIXParameters.getInitialPolicies();
        TrustAnchor trustAnchor = this.findTrustAnchor((X509Certificate)list.get(list.size() - 1), pKIXParameters.getTrustAnchors());
        if (trustAnchor == null) {
            throw new CertPathValidatorException("TrustAnchor for CertPath not found", null, certPath, 0);
        }
        int n3 = 0;
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        ArrayList[] arrayListArray = new ArrayList[n2 + 1];
        int n4 = 0;
        while (n4 < arrayListArray.length) {
            arrayListArray[n4] = new ArrayList();
            ++n4;
        }
        HashSet<String> hashSet3 = new HashSet<String>();
        hashSet3.add(ANY_POLICY);
        PKIXPolicyNode pKIXPolicyNode = new PKIXPolicyNode(new ArrayList(), 0, hashSet3, null, new HashSet(), ANY_POLICY, false);
        arrayListArray[0].add(pKIXPolicyNode);
        HashSet hashSet4 = new HashSet();
        HashSet hashSet5 = new HashSet();
        HashSet hashSet6 = new HashSet();
        HashSet hashSet7 = new HashSet();
        HashSet hashSet8 = new HashSet();
        HashSet hashSet9 = new HashSet();
        HashSet hashSet10 = null;
        int n5 = pKIXParameters.isExplicitPolicyRequired() ? 0 : n2 + 1;
        int n6 = pKIXParameters.isAnyPolicyInhibited() ? 0 : n2 + 1;
        int n7 = pKIXParameters.isPolicyMappingInhibited() ? 0 : n2 + 1;
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        try {
            if (x509Certificate != null) {
                x500Principal = x509Certificate.getSubjectX500Principal();
                publicKey = x509Certificate.getPublicKey();
            } else {
                x500Principal = new X500Principal(trustAnchor.getCAName());
                publicKey = trustAnchor.getCAPublicKey();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertPathValidatorException("TrustAnchor subjectDN: " + illegalArgumentException.toString());
        }
        AlgorithmIdentifier algorithmIdentifier = this.getAlgorithmIdentifier(publicKey);
        DERObjectIdentifier dERObjectIdentifier = algorithmIdentifier.getObjectId();
        DEREncodable dEREncodable = algorithmIdentifier.getParameters();
        int n8 = n2;
        if (pKIXParameters.getTargetCertConstraints() != null && !pKIXParameters.getTargetCertConstraints().match((X509Certificate)list.get(0))) {
            throw new CertPathValidatorException("target certificate in certpath does not match targetcertconstraints", null, certPath, 0);
        }
        Iterator<PKIXCertPathChecker> iterator3 = pKIXParameters.getCertPathCheckers().iterator();
        while (iterator3.hasNext()) {
            iterator3.next().init(false);
        }
        X509Certificate x509Certificate2 = null;
        n3 = list.size() - 1;
        while (n3 >= 0) {
            Object object5;
            Iterator iterator4;
            Object object6;
            int n9 = n2 - n3;
            x509Certificate2 = (X509Certificate)list.get(n3);
            try {
                x509Certificate2.verify(publicKey, "BC");
                x509Certificate2.checkValidity(date);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new CertPathValidatorException("couldn't validate certificate: " + generalSecurityException);
            }
            if (pKIXParameters.isRevocationEnabled()) {
                boolean bl = false;
                X509CRLSelector x509CRLSelector = new X509CRLSelector();
                try {
                    x509CRLSelector.addIssuerName(x509Certificate2.getIssuerX500Principal().getEncoded());
                }
                catch (IOException iOException) {
                    throw new CertPathValidatorException("can't extract issuer from certificate: " + iOException);
                }
                x509CRLSelector.setCertificateChecking(x509Certificate2);
                iterator2 = this.findCRLs(x509CRLSelector, pKIXParameters.getCertStores()).iterator();
                while (iterator2.hasNext()) {
                    Object object7;
                    object4 = (X509CRL)iterator2.next();
                    if (!date.after(((X509CRL)object4).getThisUpdate())) continue;
                    if (((X509CRL)object4).getNextUpdate() == null || date.before(((X509CRL)object4).getNextUpdate())) {
                        bl = true;
                    }
                    if (x509Certificate != null && (object6 = (Object)x509Certificate.getKeyUsage()) != null && (((Object)object6).length < 7 || object6[6] == false)) {
                        throw new CertPathValidatorException("Issuer certificate keyusage extension does not permit crl signing.\n" + x509Certificate, null, certPath, n3);
                    }
                    try {
                        ((X509CRL)object4).verify(publicKey, "BC");
                    }
                    catch (Exception exception) {
                        throw new CertPathValidatorException("can't verify CRL: " + exception);
                    }
                    object3 = ((X509CRL)object4).getRevokedCertificate(x509Certificate2.getSerialNumber());
                    if (object3 != null && !date.before(((X509CRLEntry)object3).getRevocationDate())) {
                        throw new CertPathValidatorException("Certificate revokation after " + ((X509CRLEntry)object3).getRevocationDate(), null, certPath, n3);
                    }
                    object6 = this.getExtensionValue((X509Extension)object4, ISSUING_DISTRIBUTION_POINT);
                    object2 = this.getExtensionValue((X509Extension)object4, DELTA_CRL_INDICATOR);
                    if (object2 != null) {
                        object7 = new X509CRLSelector();
                        try {
                            ((X509CRLSelector)object7).addIssuerName(((X509CRL)object4).getIssuerX500Principal().getEncoded());
                        }
                        catch (IOException iOException) {
                            throw new CertPathValidatorException("can't extract issuer from certificate: " + iOException);
                        }
                        ((X509CRLSelector)object7).setMinCRLNumber(((DERInteger)object2).getPositiveValue());
                        ((X509CRLSelector)object7).setMaxCRLNumber(((DERInteger)this.getExtensionValue((X509Extension)object4, CRL_NUMBER)).getPositiveValue().subtract(BigInteger.valueOf(1L)));
                        boolean bl2 = false;
                        iterator4 = this.findCRLs((X509CRLSelector)object7, pKIXParameters.getCertStores()).iterator();
                        while (iterator4.hasNext()) {
                            object = (X509CRL)iterator4.next();
                            object5 = this.getExtensionValue((X509Extension)object, ISSUING_DISTRIBUTION_POINT);
                            if (object6 == null) {
                                if (object5 != null) continue;
                                bl2 = true;
                                break;
                            }
                            if (!object6.equals(object5)) continue;
                            bl2 = true;
                            break;
                        }
                        if (!bl2) {
                            throw new CertPathValidatorException("No base CRL for delta CRL");
                        }
                    }
                    if (object6 == null) continue;
                    object7 = IssuingDistributionPoint.getInstance(object6);
                    if (n2 - n9 > 1) {
                        if (!((IssuingDistributionPoint)object7).onlyContainsUserCerts()) continue;
                        throw new CertPathValidatorException("Intermediate CRL only contains user certificates");
                    }
                    if (!((IssuingDistributionPoint)object7).onlyContainsCACerts()) continue;
                    throw new CertPathValidatorException("End CRL only contains CA certificates");
                }
                if (!bl) {
                    throw new CertPathValidatorException("no valid CRL found", null, certPath, n3);
                }
            }
            if (!x509Certificate2.getIssuerX500Principal().equals(x500Principal)) {
                throw new CertPathValidatorException("IssuerName(" + x509Certificate2.getIssuerX500Principal() + ") does not match SubjectName(" + x500Principal + ") of signing certificate", null, certPath, n3);
            }
            if (!this.isSelfIssued(x509Certificate2) || n9 >= n2) {
                iterator2 = x509Certificate2.getSubjectX500Principal();
                object3 = new ASN1InputStream(new ByteArrayInputStream(((X500Principal)((Object)iterator2)).getEncoded()));
                try {
                    object4 = (ASN1Sequence)((ASN1InputStream)object3).readObject();
                }
                catch (IOException iOException) {
                    throw new CertPathValidatorException("exception extracting subject name when checking subtrees");
                }
                this.checkPermittedDN(hashSet4, (ASN1Sequence)object4);
                this.checkExcludedDN(hashSet7, (ASN1Sequence)object4);
                object6 = (ASN1Sequence)this.getExtensionValue(x509Certificate2, SUBJECT_ALTERNATIVE_NAME);
                if (object6 != null) {
                    int n10 = 0;
                    while (n10 < ((ASN1Sequence)object6).size()) {
                        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)((ASN1Sequence)object6).getObjectAt(n10);
                        switch (aSN1TaggedObject.getTagNo()) {
                            case 1: {
                                String string = DERIA5String.getInstance(aSN1TaggedObject, true).getString();
                                this.checkPermittedEmail(hashSet5, string);
                                this.checkExcludedEmail(hashSet8, string);
                                break;
                            }
                            case 4: {
                                iterator4 = ASN1Sequence.getInstance(aSN1TaggedObject, true);
                                this.checkPermittedDN(hashSet4, (ASN1Sequence)((Object)iterator4));
                                this.checkExcludedDN(hashSet7, (ASN1Sequence)((Object)iterator4));
                                break;
                            }
                            case 7: {
                                object = ASN1OctetString.getInstance(aSN1TaggedObject, true).getOctets();
                                this.checkPermittedIP(hashSet6, (byte[])object);
                                this.checkExcludedIP(hashSet9, (byte[])object);
                            }
                        }
                        ++n10;
                    }
                }
            }
            if ((iterator2 = (ASN1Sequence)this.getExtensionValue(x509Certificate2, CERTIFICATE_POLICIES)) != null && pKIXPolicyNode != null) {
                object3 = ((ASN1Sequence)((Object)iterator2)).getObjects();
                object4 = new HashSet();
                while (object3.hasMoreElements()) {
                    Set set2;
                    boolean bl;
                    object6 = PolicyInformation.getInstance(object3.nextElement());
                    object2 = ((PolicyInformation)object6).getPolicyIdentifier();
                    ((HashSet)object4).add(((DERObjectIdentifier)object2).getId());
                    if (ANY_POLICY.equals(((DERObjectIdentifier)object2).getId()) || (bl = this.processCertD1i(n9, arrayListArray, (DERObjectIdentifier)object2, set2 = this.getQualifierSet(((PolicyInformation)object6).getPolicyQualifiers())))) continue;
                    this.processCertD1ii(n9, arrayListArray, (DERObjectIdentifier)object2, set2);
                }
                if (hashSet10 == null) {
                    hashSet10 = object4;
                } else {
                    object6 = hashSet10.iterator();
                    object2 = new HashSet();
                    while (object6.hasNext()) {
                        Object e = object6.next();
                        if (!((HashSet)object4).contains(e)) continue;
                        ((HashSet)object2).add(e);
                    }
                    hashSet10 = object2;
                }
                if (n6 > 0 || n9 < n2 && this.isSelfIssued(x509Certificate2)) {
                    object3 = ((ASN1Sequence)((Object)iterator2)).getObjects();
                    while (object3.hasMoreElements()) {
                        object6 = PolicyInformation.getInstance(object3.nextElement());
                        if (ANY_POLICY.equals(((PolicyInformation)object6).getPolicyIdentifier().getId())) continue;
                        object2 = this.getQualifierSet(((PolicyInformation)object6).getPolicyQualifiers());
                        ArrayList arrayList = arrayListArray[n9 - 1];
                        int n11 = 0;
                        while (n11 < arrayList.size()) {
                            iterator4 = (PKIXPolicyNode)arrayList.get(n11);
                            object = ((PKIXPolicyNode)((Object)iterator4)).getExpectedPolicies().iterator();
                            while (object.hasNext()) {
                                Object object8;
                                String string;
                                object5 = object.next();
                                if (object5 instanceof String) {
                                    string = (String)object5;
                                } else {
                                    if (!(object5 instanceof DERObjectIdentifier)) continue;
                                    string = ((DERObjectIdentifier)object5).getId();
                                }
                                boolean bl = false;
                                Iterator iterator5 = ((PKIXPolicyNode)((Object)iterator4)).getChildren();
                                while (iterator5.hasNext()) {
                                    object8 = (PKIXPolicyNode)iterator5.next();
                                    if (!string.equals(((PKIXPolicyNode)object8).getValidPolicy())) continue;
                                    bl = true;
                                }
                                if (bl) continue;
                                object8 = new HashSet();
                                object8.add(string);
                                PKIXPolicyNode pKIXPolicyNode2 = new PKIXPolicyNode(new ArrayList(), n9, (Set)object8, (PolicyNode)((Object)iterator4), (Set)object2, string, false);
                                ((PKIXPolicyNode)((Object)iterator4)).addChild(pKIXPolicyNode2);
                                arrayListArray[n9].add(pKIXPolicyNode2);
                            }
                            ++n11;
                        }
                        break block44;
                    }
                }
                int n12 = n9 - 1;
                while (n12 >= 0) {
                    object2 = arrayListArray[n12];
                    int n13 = 0;
                    while (n13 < ((ArrayList)object2).size()) {
                        PKIXPolicyNode pKIXPolicyNode3 = (PKIXPolicyNode)((ArrayList)object2).get(n13);
                        if (!pKIXPolicyNode3.hasChildren() && (pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, arrayListArray, pKIXPolicyNode3)) == null) break;
                        ++n13;
                    }
                    --n12;
                }
                object2 = x509Certificate2.getCriticalExtensionOIDs();
                if (object2 != null) {
                    boolean bl = object2.contains(CERTIFICATE_POLICIES);
                    ArrayList arrayList = arrayListArray[n9];
                    int n14 = 0;
                    while (n14 < arrayList.size()) {
                        object = (PKIXPolicyNode)arrayList.get(n14);
                        ((PKIXPolicyNode)object).setCritical(bl);
                        ++n14;
                    }
                }
                int n15 = n9 - 1;
                while (n15 >= 0) {
                    ArrayList arrayList = arrayListArray[n15];
                    int n16 = 0;
                    while (n16 < arrayList.size()) {
                        object = (PKIXPolicyNode)arrayList.get(n16);
                        if (!((PKIXPolicyNode)object).hasChildren()) {
                            pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, arrayListArray, (PKIXPolicyNode)object);
                        }
                        ++n16;
                    }
                    --n15;
                }
            }
            if (iterator2 == null) {
                pKIXPolicyNode = null;
            }
            if (n5 <= 0 && pKIXPolicyNode == null && !this.isAnyPolicy(hashSet10)) {
                throw new CertPathValidatorException("Failure in process (f)");
            }
            if (n9 != n2) {
                boolean[] blArray;
                int n17;
                BigInteger bigInteger;
                BasicConstraints basicConstraints;
                int n18;
                ASN1Sequence aSN1Sequence;
                if (x509Certificate2 != null && x509Certificate2.getVersion() == 1) {
                    throw new CertPathValidatorException("Version 1 certs can't be used as CA ones");
                }
                object3 = this.getExtensionValue(x509Certificate2, POLICY_MAPPINGS);
                if (object3 != null) {
                    object4 = (ASN1Sequence)object3;
                    int n19 = 0;
                    while (n19 < ((ASN1Sequence)object4).size()) {
                        object2 = (ASN1Sequence)((ASN1Sequence)object4).getObjectAt(n19);
                        DERObjectIdentifier dERObjectIdentifier2 = (DERObjectIdentifier)((ASN1Sequence)object2).getObjectAt(0);
                        DERObjectIdentifier dERObjectIdentifier3 = (DERObjectIdentifier)((ASN1Sequence)object2).getObjectAt(1);
                        if (ANY_POLICY.equals(dERObjectIdentifier2.getId())) {
                            throw new CertPathValidatorException("IssuerDomainPolicy is anyPolicy");
                        }
                        if (ANY_POLICY.equals(dERObjectIdentifier3.getId())) {
                            throw new CertPathValidatorException("SubjectDomainPolicy is anyPolicy");
                        }
                        ++n19;
                    }
                }
                if ((object4 = (ASN1Sequence)this.getExtensionValue(x509Certificate2, NAME_CONSTRAINTS)) != null) {
                    ASN1Sequence aSN1Sequence2;
                    NameConstraints nameConstraints = new NameConstraints((ASN1Sequence)object4);
                    object2 = nameConstraints.getPermittedSubtrees();
                    if (object2 != null) {
                        Enumeration enumeration = ((ASN1Sequence)object2).getObjects();
                        while (enumeration.hasMoreElements()) {
                            GeneralSubtree generalSubtree = GeneralSubtree.getInstance(enumeration.nextElement());
                            GeneralName generalName = generalSubtree.getBase();
                            switch (generalName.getTagNo()) {
                                case 1: {
                                    hashSet5 = this.intersectEmail(hashSet5, DERIA5String.getInstance(generalName.getName()).getString());
                                    break;
                                }
                                case 4: {
                                    hashSet4 = this.intersectDN(hashSet4, (ASN1Sequence)generalName.getName());
                                    break;
                                }
                                case 7: {
                                    hashSet6 = this.intersectIP(hashSet6, ASN1OctetString.getInstance(generalName.getName()).getOctets());
                                }
                            }
                        }
                    }
                    if ((aSN1Sequence2 = nameConstraints.getExcludedSubtrees()) != null) {
                        Enumeration enumeration = aSN1Sequence2.getObjects();
                        while (enumeration.hasMoreElements()) {
                            GeneralSubtree generalSubtree = GeneralSubtree.getInstance(enumeration.nextElement());
                            object = generalSubtree.getBase();
                            switch (((GeneralName)object).getTagNo()) {
                                case 1: {
                                    hashSet8 = this.unionEmail(hashSet8, DERIA5String.getInstance(((GeneralName)object).getName()).getString());
                                    break;
                                }
                                case 4: {
                                    hashSet7 = this.unionDN(hashSet7, (ASN1Sequence)((GeneralName)object).getName());
                                    break;
                                }
                                case 7: {
                                    hashSet9 = this.unionIP(hashSet9, ASN1OctetString.getInstance(((GeneralName)object).getName()).getOctets());
                                }
                            }
                        }
                    }
                }
                if (!this.isSelfIssued(x509Certificate2)) {
                    if (n5 != 0) {
                        --n5;
                    }
                    if (n7 != 0) {
                        --n7;
                    }
                    if (n6 != 0) {
                        --n6;
                    }
                }
                if ((aSN1Sequence = (ASN1Sequence)this.getExtensionValue(x509Certificate2, POLICY_CONSTRAINTS)) != null) {
                    object2 = aSN1Sequence.getObjects();
                    while (object2.hasMoreElements()) {
                        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)object2.nextElement();
                        switch (aSN1TaggedObject.getTagNo()) {
                            case 0: {
                                n = DERInteger.getInstance(aSN1TaggedObject).getValue().intValue();
                                if (n >= n5) break;
                                n5 = n;
                                break;
                            }
                            case 1: {
                                n = DERInteger.getInstance(aSN1TaggedObject).getValue().intValue();
                                if (n >= n6) break;
                                n6 = n;
                            }
                        }
                    }
                }
                if ((object2 = (DERInteger)this.getExtensionValue(x509Certificate2, INHIBIT_ANY_POLICY)) != null && (n18 = ((DERInteger)object2).getValue().intValue()) < n6) {
                    n6 = n18;
                }
                if ((basicConstraints = BasicConstraints.getInstance(this.getExtensionValue(x509Certificate2, BASIC_CONSTRAINTS))) != null) {
                    if (!basicConstraints.isCA()) {
                        throw new CertPathValidatorException("Not a CA certificate");
                    }
                } else {
                    throw new CertPathValidatorException("Intermediate certificate lacks BasicConstraints");
                }
                if (!this.isSelfIssued(x509Certificate2)) {
                    if (n8 <= 0) {
                        throw new CertPathValidatorException("Max path length not greater than zero");
                    }
                    --n8;
                }
                if (basicConstraints != null && (bigInteger = basicConstraints.getPathLenConstraint()) != null && (n17 = bigInteger.intValue()) < n8) {
                    n8 = n17;
                }
                if ((blArray = x509Certificate2.getKeyUsage()) != null && !blArray[5]) {
                    throw new CertPathValidatorException("Issuer certificate keyusage extension is critical an does not permit key signing.\n", null, certPath, n3);
                }
                if (x509Certificate2.hasUnsupportedCriticalExtension()) {
                    HashSet<String> hashSet11 = new HashSet<String>(x509Certificate2.getCriticalExtensionOIDs());
                    hashSet11.remove(KEY_USAGE);
                    hashSet11.remove(CERTIFICATE_POLICIES);
                    hashSet11.remove(POLICY_MAPPINGS);
                    hashSet11.remove(INHIBIT_ANY_POLICY);
                    hashSet11.remove(ISSUING_DISTRIBUTION_POINT);
                    hashSet11.remove(DELTA_CRL_INDICATOR);
                    hashSet11.remove(POLICY_CONSTRAINTS);
                    hashSet11.remove(BASIC_CONSTRAINTS);
                    hashSet11.remove(SUBJECT_ALTERNATIVE_NAME);
                    hashSet11.remove(NAME_CONSTRAINTS);
                    iterator = pKIXParameters.getCertPathCheckers().iterator();
                    while (iterator.hasNext()) {
                        iterator.next().check(x509Certificate2, hashSet11);
                    }
                    if (!hashSet11.isEmpty()) {
                        throw new CertPathValidatorException("Certificate has unsupported critical extension", null, certPath, n3);
                    }
                }
            }
            x509Certificate = x509Certificate2;
            publicKey = x509Certificate.getPublicKey();
            try {
                x500Principal = x509Certificate.getSubjectX500Principal();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new CertPathValidatorException(x509Certificate.getSubjectDN().getName() + " :" + illegalArgumentException.toString());
            }
            algorithmIdentifier = this.getAlgorithmIdentifier(publicKey);
            dERObjectIdentifier = algorithmIdentifier.getObjectId();
            dEREncodable = algorithmIdentifier.getParameters();
            --n3;
        }
        if (!this.isSelfIssued(x509Certificate2) && n5 != 0) {
            --n5;
        }
        if ((iterator2 = (ASN1Sequence)this.getExtensionValue(x509Certificate2, POLICY_CONSTRAINTS)) != null) {
            object3 = ((ASN1Sequence)((Object)iterator2)).getObjects();
            while (object3.hasMoreElements()) {
                object4 = (ASN1TaggedObject)object3.nextElement();
                switch (((ASN1TaggedObject)object4).getTagNo()) {
                    case 0: {
                        n = DERInteger.getInstance(object4).getValue().intValue();
                        if (n != 0) break;
                        n5 = 0;
                    }
                }
            }
        }
        if (x509Certificate2.hasUnsupportedCriticalExtension()) {
            object3 = new HashSet<String>(x509Certificate2.getCriticalExtensionOIDs());
            object3.remove(KEY_USAGE);
            object3.remove(CERTIFICATE_POLICIES);
            object3.remove(POLICY_MAPPINGS);
            object3.remove(INHIBIT_ANY_POLICY);
            object3.remove(ISSUING_DISTRIBUTION_POINT);
            object3.remove(DELTA_CRL_INDICATOR);
            object3.remove(POLICY_CONSTRAINTS);
            object3.remove(BASIC_CONSTRAINTS);
            object3.remove(SUBJECT_ALTERNATIVE_NAME);
            object3.remove(NAME_CONSTRAINTS);
            iterator = pKIXParameters.getCertPathCheckers().iterator();
            while (iterator.hasNext()) {
                iterator.next().check(x509Certificate2, (Collection<String>)object3);
            }
            if (!object3.isEmpty()) {
                throw new CertPathValidatorException("Certificate has unsupported critical extension", null, certPath, n3);
            }
        }
        if (pKIXPolicyNode == null) {
            object3 = null;
        } else if (this.isAnyPolicy(set)) {
            if (pKIXParameters.isExplicitPolicyRequired()) {
                if (hashSet10.isEmpty()) {
                    throw new CertPathValidatorException("Explicit policy requested but none avaliable");
                }
                object4 = new HashSet();
                int n20 = 0;
                while (n20 < arrayListArray.length) {
                    object2 = arrayListArray[n20];
                    int n21 = 0;
                    while (n21 < ((ArrayList)object2).size()) {
                        PKIXPolicyNode pKIXPolicyNode4 = (PKIXPolicyNode)((ArrayList)object2).get(n21);
                        if (ANY_POLICY.equals(pKIXPolicyNode4.getValidPolicy())) {
                            Iterator iterator6 = pKIXPolicyNode4.getChildren();
                            while (iterator6.hasNext()) {
                                object4.add(iterator6.next());
                            }
                        }
                        ++n21;
                    }
                    ++n20;
                }
                object2 = object4.iterator();
                while (object2.hasNext()) {
                    PKIXPolicyNode pKIXPolicyNode5 = (PKIXPolicyNode)object2.next();
                    String string = pKIXPolicyNode5.getValidPolicy();
                    if (hashSet10.contains(string)) continue;
                    pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, arrayListArray, pKIXPolicyNode5);
                }
                if (pKIXPolicyNode != null) {
                    int n22 = n2 - 1;
                    while (n22 >= 0) {
                        ArrayList arrayList = arrayListArray[n22];
                        int n23 = 0;
                        while (n23 < arrayList.size()) {
                            object = (PKIXPolicyNode)arrayList.get(n23);
                            if (!((PKIXPolicyNode)object).hasChildren()) {
                                pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, arrayListArray, (PKIXPolicyNode)object);
                            }
                            ++n23;
                        }
                        --n22;
                    }
                }
            }
            object3 = pKIXPolicyNode;
        } else {
            object4 = new HashSet();
            int n24 = 0;
            while (n24 < arrayListArray.length) {
                object2 = arrayListArray[n24];
                int n25 = 0;
                while (n25 < ((ArrayList)object2).size()) {
                    PKIXPolicyNode pKIXPolicyNode6 = (PKIXPolicyNode)((ArrayList)object2).get(n25);
                    if (ANY_POLICY.equals(pKIXPolicyNode6.getValidPolicy())) {
                        Iterator iterator7 = pKIXPolicyNode6.getChildren();
                        while (iterator7.hasNext()) {
                            object4.add(iterator7.next());
                        }
                    }
                    ++n25;
                }
                ++n24;
            }
            object2 = object4.iterator();
            while (object2.hasNext()) {
                PKIXPolicyNode pKIXPolicyNode7 = (PKIXPolicyNode)object2.next();
                String string = pKIXPolicyNode7.getValidPolicy();
                if (set.contains(string)) continue;
                pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, arrayListArray, pKIXPolicyNode7);
            }
            object2 = object4.iterator();
            while (object2.hasNext()) {
                PKIXPolicyNode pKIXPolicyNode8 = (PKIXPolicyNode)object2.next();
                String string = pKIXPolicyNode8.getValidPolicy();
                if (hashSet10.contains(string)) continue;
                pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, arrayListArray, pKIXPolicyNode8);
            }
            if (pKIXPolicyNode != null) {
                int n26 = n2 - 1;
                while (n26 >= 0) {
                    ArrayList arrayList = arrayListArray[n26];
                    int n27 = 0;
                    while (n27 < arrayList.size()) {
                        object = (PKIXPolicyNode)arrayList.get(n27);
                        if (!((PKIXPolicyNode)object).hasChildren()) {
                            pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, arrayListArray, (PKIXPolicyNode)object);
                        }
                        ++n27;
                    }
                    --n26;
                }
            }
            object3 = pKIXPolicyNode;
        }
        if (n5 > 0 || object3 != null || this.isAnyPolicy(hashSet10)) {
            return new PKIXCertPathValidatorResult(trustAnchor, (PolicyNode)object3, publicKey);
        }
        throw new CertPathValidatorException("Path processing failed");
    }

    private final Collection findCRLs(X509CRLSelector x509CRLSelector, List list) {
        HashSet<? extends CRL> hashSet = new HashSet<CRL>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CertStore certStore = (CertStore)iterator.next();
            try {
                hashSet.addAll(certStore.getCRLs(x509CRLSelector));
            }
            catch (CertStoreException certStoreException) {
                certStoreException.printStackTrace();
            }
        }
        return hashSet;
    }

    /*
     * Unable to fully structure code
     */
    final TrustAnchor findTrustAnchor(X509Certificate var1_1, Set var2_2) throws CertPathValidatorException {
        var3_3 = var2_2.iterator();
        var4_4 = null;
        var5_5 = null;
        var6_6 = null;
        var7_7 = new X509CertSelector();
        try {
            var7_7.setSubject(var1_1.getIssuerX500Principal().getEncoded());
            if (true) ** GOTO lbl40
        }
        catch (IOException var8_8) {
            var8_8.printStackTrace();
            return null;
        }
        do {
            block15: {
                if ((var4_4 = (TrustAnchor)var3_3.next()).getTrustedCert() != null) {
                    if (var7_7.match(var4_4.getTrustedCert())) {
                        var5_5 = var4_4.getTrustedCert().getPublicKey();
                    } else {
                        var4_4 = null;
                    }
                } else if (var4_4.getCAName() != null && var4_4.getCAPublicKey() != null) {
                    try {
                        var8_9 = var1_1.getIssuerX500Principal();
                        var9_12 = new X500Principal(var4_4.getCAName());
                        if (var8_9.equals(var9_12)) {
                            var5_5 = var4_4.getCAPublicKey();
                            break block15;
                        }
                        var4_4 = null;
                    }
                    catch (IllegalArgumentException var8_10) {
                        var4_4 = null;
                    }
                } else {
                    var4_4 = null;
                }
            }
            if (var5_5 == null) continue;
            try {
                var1_1.verify(var5_5);
            }
            catch (Exception var8_11) {
                var6_6 = var8_11;
                var4_4 = null;
            }
lbl40:
            // 4 sources

        } while (var3_3.hasNext() && var4_4 == null);
        if (var4_4 == null && var6_6 != null) {
            throw new CertPathValidatorException("TrustAnchor found put certificate validation failed", var6_6);
        }
        return var4_4;
    }
}

