/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

public class FdfReader
extends PdfReader {
    HashMap fields;
    String fileSpec;
    PdfName encoding;

    public FdfReader(String filename) throws IOException {
        super(filename);
    }

    public FdfReader(byte[] pdfIn) throws IOException {
        super(pdfIn);
    }

    public FdfReader(URL url) throws IOException {
        super(url);
    }

    public FdfReader(InputStream is) throws IOException {
        super(is);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readPdf() throws IOException {
        block6: {
            this.fields = new HashMap<K, V>();
            try {
                this.tokens.checkFdfHeader();
                this.rebuildXref();
                this.readDocObj();
            }
            catch (Throwable var2_1) {
                var1_2 = null;
                try {
                    this.tokens.close();
                    throw var2_1;
                }
                catch (Exception var3_4) {
                    // empty catch block
                }
                throw var2_1;
            }
            {
                var1_3 = null;
            }
            ** try [egrp 1[TRYBLOCK] [2 : 36->46)] { 
lbl18:
            // 1 sources

            this.tokens.close();
            break block6;
lbl20:
            // 1 sources

            catch (Exception var3_5) {
                // empty catch block
            }
        }
        this.readFields();
    }

    protected void kidNode(PdfDictionary merged, String name) {
        PdfArray kids = (PdfArray)FdfReader.getPdfObject(merged.get(PdfName.KIDS));
        if (kids == null || kids.getArrayList().size() == 0) {
            if (name.length() > 0) {
                name = name.substring(1);
            }
            this.fields.put(name, merged);
        } else {
            merged.remove(PdfName.KIDS);
            ArrayList ar = kids.getArrayList();
            int k = 0;
            while (k < ar.size()) {
                PdfDictionary dic = new PdfDictionary();
                dic.merge(merged);
                PdfDictionary newDic = (PdfDictionary)FdfReader.getPdfObject((PdfObject)ar.get(k));
                PdfString t = (PdfString)FdfReader.getPdfObject(newDic.get(PdfName.T));
                String newName = name;
                if (t != null) {
                    newName = String.valueOf(newName) + "." + t.toUnicodeString();
                }
                dic.merge(newDic);
                dic.remove(PdfName.T);
                this.kidNode(dic, newName);
                ++k;
            }
        }
    }

    protected void readFields() throws IOException {
        PdfArray fld;
        this.catalog = (PdfDictionary)FdfReader.getPdfObject(this.trailer.get(PdfName.ROOT));
        PdfDictionary fdf = (PdfDictionary)FdfReader.getPdfObject(this.catalog.get(PdfName.FDF));
        PdfString fs = (PdfString)FdfReader.getPdfObject(fdf.get(PdfName.F));
        if (fs != null) {
            this.fileSpec = fs.toUnicodeString();
        }
        if ((fld = (PdfArray)FdfReader.getPdfObject(fdf.get(PdfName.FIELDS))) == null) {
            return;
        }
        this.encoding = (PdfName)FdfReader.getPdfObject(fdf.get(PdfName.ENCODING));
        PdfDictionary merged = new PdfDictionary();
        merged.put(PdfName.KIDS, fld);
        this.kidNode(merged, "");
    }

    public HashMap getFields() {
        return this.fields;
    }

    public PdfDictionary getField(String name) {
        return (PdfDictionary)this.fields.get(name);
    }

    public String getFieldValue(String name) {
        PdfDictionary field = (PdfDictionary)this.fields.get(name);
        if (field == null) {
            return null;
        }
        PdfObject v = FdfReader.getPdfObject(field.get(PdfName.V));
        if (v == null) {
            return null;
        }
        if (v.isName()) {
            return PdfName.decodeName(((PdfName)v).toString());
        }
        if (v.isString()) {
            PdfString vs = (PdfString)v;
            if (this.encoding == null || vs.getEncoding() != null) {
                return vs.toUnicodeString();
            }
            byte[] b = vs.getBytes();
            if (b.length >= 2 && b[0] == -2 && b[1] == -1) {
                return vs.toUnicodeString();
            }
            try {
                if (this.encoding.equals(PdfName.SHIFT_JIS)) {
                    return new String(b, "SJIS");
                }
                if (this.encoding.equals(PdfName.UHC)) {
                    return new String(b, "MS949");
                }
                if (this.encoding.equals(PdfName.GBK)) {
                    return new String(b, "GBK");
                }
                if (this.encoding.equals(PdfName.BIGFIVE)) {
                    return new String(b, "Big5");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return vs.toUnicodeString();
        }
        return null;
    }

    public String getFileSpec() {
        return this.fileSpec;
    }
}

