/*
 * JaLingo, http://jalingo.sourceforge.net/
 *
 * Copyright (c) 2002-2006 Oleksandr Shyshko
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package ja.lingo.readers.ptkdictmysql;

import junit.framework.TestCase;
import ja.lingo.engine.reader.IConverter;
import ja.lingo.engine.beans.Info;

public class PtkDictMySqlConverterTest extends TestCase {
    private IConverter converter;

    protected void setUp() throws Exception {
        super.setUp();

        Info i = new Info();
        i.setDataFileEncoding( "ISO-8859-1" );
        converter = new PtkDictMySqlConverter( i );
    }

    public void testGetTitle() {
        checkTitle( "\"\'\n", "\\\"\\'\\n" );
    }

    public void testGetBody() {
        checkBody( "body\"'<br>", "title", "body\\\"\\'\\n" );

        checkBody( "body", "title", "body" );
        checkBody( "body", "title", "title: body" );
        checkBody( "body", "title", "title:\\nbody" );
        checkBody( "body", "title", "title body" );
    }

    private void checkTitle( String expectedTitle, String rawTitle ) {
        byte[] titleBytes = rawTitle.getBytes();
        assertEquals( expectedTitle, converter.getTitle( titleBytes, 0, titleBytes.length ) );
    }
    private void checkBody( String expectedBody, String rawTitle, String rawBody ) {
        byte[] titleBytes = rawTitle.getBytes();
        byte[] bodyBytes = rawBody.getBytes();
        assertEquals( expectedBody, converter.getBody(
                titleBytes, 0, titleBytes.length,
                bodyBytes, 0, bodyBytes.length ) );
    }
}