/*
 * JaLingo, http://jalingo.sourceforge.net/
 *
 * Copyright (c) 2002-2006 Oleksandr Shyshko
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package ja.lingo.engine.searchindex;

import junit.framework.TestCase;

public class BaseSearchIndexTest extends TestCase {
    private BaseSearchIndex searchIndex;

    protected void setUp() throws Exception {
        super.setUp();

        searchIndex = new BaseSearchIndex() {
            protected void assertNotClosed() {
            }

            public void close() {
            }
        };
        IMutableNode root = Node.createRoot();

        IMutableNode c = Node.create( 'c', 2 );

        root.addChild( Node.create( 'a', 0 ) ); // 0: a
        root.addChild( Node.create( 'b', 1 ) ); // 1: b
        root.addChild( c );                     // 2: c
        c.addChild( Node.create( 'a', 3 ) );    // 3: ca
        c.addChild( Node.create( 'b', 4 ) );    // 4: cb

        searchIndex.rootNode = root;
    }

    public void testIndexOfFirstLike() {
        assertEquals( 0, searchIndex.indexOfFirstLike( "aaa" ) );
        assertEquals( 1, searchIndex.indexOfFirstLike( "bbb" ) );
        assertEquals( 2, searchIndex.indexOfFirstLike( "CcC" ) );
        assertEquals( 2, searchIndex.indexOfFirstLike( "c" ) );
        assertEquals( 3, searchIndex.indexOfFirstLike( "cacc" ) );
        assertEquals( 3, searchIndex.indexOfFirstLike( "CA" ) );
        assertEquals( 4, searchIndex.indexOfFirstLike( "CBa" ) );
        assertEquals( 4, searchIndex.indexOfFirstLike( "cbA" ) );


        assertEquals( -1, searchIndex.indexOfFirstLike( "ddd" ) );
        assertEquals( -1, searchIndex.indexOfFirstLike( "" ) );
    }
}