/*
 * JaLingo, http://jalingo.sourceforge.net/
 *
 * Copyright (c) 2002-2006 Oleksandr Shyshko
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package ja.lingo.engine.mergedindex;

import junit.framework.TestCase;

public class ArticleTest extends TestCase {
    public void testEquals() {
        MockDictionaryIndex reader = new MockDictionaryIndex();
        reader.addArticle( "1" );
        reader.addArticle( "2" );
        reader.addArticle( "3" );

        Article article1 = new Article( reader, 0 );
        Article article2 = new Article( reader, 1 );
        Article article3 = new Article( reader, 2 );

        assertTrue( article1.equals( article1 ) );
        assertTrue( article2.equals( article2 ) );
        assertTrue( article3.equals( article3 ) );

        assertFalse( article1.equals( article2 ) );
        assertFalse( article2.equals( article3 ) );
        assertFalse( article3.equals( article1 ) );

        Article article1_1 = new Article( reader, 0 );
        assertTrue( article1.equals( article1_1 ) );
    }
}